;;;;; Temp Stacks for Exception Handlers ;;;;;;;
;;;;; by : Peter Quiring

comment ~
Stack looks as follows when an Exception handler is called:
 31     0
 0      SS   |
    ESP      |- You may modify
  EFlags     |
 0      CS   |
    EIP      |
 Error Code
 0    Ret CS
 Return EIP   <-- SS:ESP
~
.data?

_exc struct
  ret_eip  dd ?
  ret_cs   dd ?
  _errcode dd ?
  _eip     dd ?
  _cs      dd ?
  _eflags  dd ?
  _esp     dd ?
  _ss      dd ?
_exc ends

TstackSiz equ (4*1024)   ;stack size (must be power of 2)
TstackShift equ 12     ;# bits to shift (2^this = TstackSiz)

NooTstacks equ 32
align dword
TheTstacks db NooTstacks*TstackSiz dup (?)

;temp crap
align dword
old_ret dd ?
old_es dd ?     ;DWORDs to pop it off stack!
old_ds dd ?     
old_ss dd ?
old_esp dd ?
new_ss dd ?
new_esp dd ?

.data

align dword
AvlTstacks dd 0

crash_msg db 'Stacks all used!  System halted!',0

.code

Switch2Stack proc
  push ds
  mov ds,cs:seldata
  pop old_ds
  pop old_ret

  mov old_ss,ss
  mov old_esp,esp
  pushad      ;there must be at least enough to do this!
  mov eax,AvlTstacks
  inc AvlTstacks
  .if AvlTstacks==NooTstacks   ;if no more stacks available then crash
    mov es,seldata
    mov edi,0b8000h
    mov esi,offset crash_msg
    mov ecx,sizeof crash_msg
@@:
    movsb
    inc edi
    dec ecx
    jnz @b
@@:           
    jmp @b     ;CRAAAASH (not even Win95 can survive this crash)
  .endif

  ifdef debug_stacks
;;
  push ebx
  push eax
  mov eax,AvlTstacks
  mov ebx,0b8000h
  add al,'0'
  mov [ebx],al
  pop eax
  pop ebx
;;
  endif

  shl eax,TstackShift   ;mul by 256
  add eax,offset TheTstacks + TstackSiz   ;EAX = new ESP value

  ;push old_ss/old_esp to new stack
  mov ebx,old_ss
  sub eax,4
  mov [eax],ebx
  mov ebx,old_esp
  sub eax,4
  mov [eax],ebx

  ;push exc data to new stack
  mov cl,8
  lea edx,[esp + 8*4+8*4]   ;8*4=pushad 8*4=exc data
@@:
  sub edx,4              ; get from old stack
  mov ebx,ss:[edx]       ;
  sub eax,4              ; push into new stack
  mov [eax],ebx          ;
  dec cl
  jnz @b

  mov new_esp,eax

  popad

  mov ss,seldata
  mov esp,new_esp

  push old_ret
  mov ds,old_ds
  ret
Switch2Stack endp

RestoreStack proc
  push ds
  push es
  mov ds,cs:seldata
  pop old_es
  pop old_ds
  pop old_ret

  pushad      ;there must be at least enough to do this (should be since
              ; we are on our own stack now)

  lea edx,[esp+8*4+8*4]

  mov es,ss:[edx+4]     ;get saved SS
  mov new_ss,es
  mov edi,ss:[edx]      ;get saved ESP

  ;push exc data to old stack
  mov cl,8
@@:
  sub edx,4              ; get from old stack
  mov ebx,ss:[edx]       ;
  sub edi,4              ; push into new stack
  mov es:[edi],ebx       ;
  dec cl
  jnz @b

  mov new_esp,edi

  popad

  mov ss,new_ss
  mov esp,new_esp

  push old_ret

  dec AvlTstacks

  ifdef debug_stacks
;;
  push ebx
  push eax
  mov eax,AvlTstacks
  mov ebx,0b8000h
  add al,'0'
  mov [ebx],al
  pop eax
  pop ebx
;;
  endif

  mov es,old_es
  mov ds,old_ds
  ret
RestoreStack endp
