include src\qlib.inc
include src\alloc.inc
include errno.inc
include string.inc

.code

public coreleft

align 4
__memfree proc private  ;Private prevents user usage
; query free ram
; out:
;   eax=largest free
;   ebx=total used
;   edx=total free
; trashes EAX,EBX,ECX,EDX

  mov errno,0     ;the only way to test for error is if errno changes
                  ;do not check for errors on return values

  xor  eax,eax                         ; size of largest free block
  xor  ebx,ebx                         ; total used ram
  xor  edx,edx                         ; total free ram

; _baseram check should be for 0, not MCB
  mov  ecx,_baseram                    ; get offset of heap pool
  test ecx,ecx                         ; no heap pool?
  jnz  loop1

  ; _baseram==0 if we get here
  ret

corrupt:
  mov errno,ECONTR   ;memory blocks destroyed
  xor eax,eax
  xor ebx,ebx
  xor edx,edx
  ret

loop1:
; now, start adding up
  ifdef __MEM_CHK__
    cmp [ecx].heads.magic,MB_SIG
    jne corrupt
  endif

  test [ecx].heads.flgs,MB_FREE        ; check if this block is marked "free"
  jz   notfree

  add  edx,[ecx].heads.siz             ; add to "total free"
  cmp  eax,[ecx].heads.siz             ; block > current largest block?
  jae  i_ok1
  mov eax,[ecx].heads.siz              ; update "largest block free"
  jmp  i_ok1
notfree:
  add  ebx,[ecx].heads.siz             ; add to "used"

i_ok1:

  test [ecx].heads.flgs,MB_LAST        ; check if this is the last block
  jnz  done                            ; if it is, then we're done

  ; move pointer to next MCB, then loop the loop
  add  ecx,[ecx].heads.siz
  add  ecx,sizeof heads                ; ECX=next MCB
  jmp  loop1

done:

  ret
__memfree endp

_memtotal proc uses ebx ecx edx
  call __memfree
  add ebx,edx   ;add "total free" to "total used"
  mov eax,ebx
  ret
_memtotal endp

coreleft:
_memavl proc uses ebx ecx edx
  call __memfree
  mov  eax,edx
  ret
_memavl endp

_memmax proc uses ebx ecx edx
  call __memfree
  ret
_memmax endp

_memused proc uses ebx ecx edx
  call __memfree
  mov  eax,ebx
  ret
_memused endp

_endseg

end

