/*/

  Q LINK Utility v1.00b

  new : v1.00a: set 2nd arg!
  new : v1.00b: Now uses QDLLFIX.

/*/

void fsplit(char *,char *,char *,char *);

#include <qlib.h>
#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <process.h>
#include <string.h>
#include <alloc.h>
#include <stdlib.h>
#include <sys\stat.h>

#include <misc.h>
#include "parse.h"

void usage(void) {
  printf("Usage : QLINK [options] name[.exe] file(s)[...]\n");
  printf("  name = filename for EXE to be created\n");
  printf("  file(s) = files to add [OBJs and LIBs]\n");
  printf("  DOS Extender options:\n");
  printf("   /P - use PMODE/W DOS extender (default)\n");
  printf("   /W - use WDOSX DOS extender\n");
  printf("   /D - use DOS/4GW DOS extender\n");
  printf("   /S[=<stub>] - use other or no DOS extender\n");
  printf("  Other options:\n");
  printf("   /L - use PMWLITE to compress LE-EXE\n");
  printf("   /M - generate map file (*.map)\n");
  printf("   /Z - add Debug info\n");
  printf("   /X - Create a QDLL file (compressed)\n");
  printf("   /STD - Create stand alone app (no default LIBs/startup code)\n");
  exit(0);
}

char dosX=0;  //DOS extender
byte lite=0,map=0,bug=0,qdll=0,_rfn=0,std=0;
char fn[0x80],fn_name[0x80],fn_ext[0x80],fn_path[0x80];
char tn[0x400],rfn[0x80];
char fn1[0x80],fn2[0x80];  //output filename  (EXE or LE/QDL)
char *stubfn;
int rfh,ho;
char *qlib,*lib;
char *buf;
char cmd[0x400];

void cleanup(void) {
  if (_rfn) {
    close(rfh);
    unlink(rfn);
  }
}

void writeln(char *s) {
  word a;

  a=strlen(s);

  if (write(ho,s,a)!=a) error("Write error?");

}

int CreatTemp(void) {
  char str[0x80];
  word a;
  int h;

  for (a=0;a<=999;a++) {
    sprintf(str,"$QLINK$.%03d",a);
    h=_creat(str,FA_ARCH);
    if (h!=-1) {
      strcpy(rfn,str);
      _rfn=1;  //cleanup() will now delete rfn on error
      return h;
    }
  }

  error("Could not create a tempfile");

  return 0;  //just to shut-up compiler

}

void CopyFile(int hd,char *f) {
  sdword a;
  int hs;

  hs=open(f,O_BINARY | O_RDONLY);

  if (hs==-1) {
    sprintf(tn,"Could not open %s",f);
    error(tn);
  }

  while (1) {
    a=read(hs,buf,bufsiz);
    if (a==-1) error("Read error?");
    if (a==0) break;
    if (write(hd,buf,a)!=a) error("Write error?");
  }

}

void main(void) {
  word a;
  char *p;

  printf("QLINK v1.00b  (by : Peter Quiring)\n");

  if ((qlib=getenv("QLIB"))==NULL) error("QLIB Environment variable not set");
  buf=(char*)malloc(bufsiz);
  lib=getenv("LIB");

  parse_args();

  if (arg_namesc<2) usage();

  for (a=0;a<arg_optsc;a++) {
    p=arg_opts[a][0];
    if (!stricmp(p,"S")) if (dosX) usage(); else {
      dosX='O';
      if (arg_opts[a][1]==NULL)
        stubfn=NULL;
      else
        stubfn=arg_opts[a][1];
      continue;
    }
    if (arg_opts[a][1]!=NULL) usage();
    if (!stricmp(p,"W")) if (dosX) usage(); else { dosX='W'; continue; }
    if (!stricmp(p,"P")) if (dosX) usage(); else { dosX='P'; continue; }
    if (!stricmp(p,"D")) if (dosX) usage(); else { dosX='D'; continue; }

    if (!stricmp(p,"L")) if (lite) usage(); else { lite=1; continue; }
    if (!stricmp(p,"M")) if (map) usage(); else { map=1; continue; }
    if (!stricmp(p,"Z")) if (bug) usage(); else { bug=1; continue; }
    if (!stricmp(p,"X")) if (qdll) usage(); else { qdll=1; continue; }
    if (!stricmp(p,"STD")) if (std) usage(); else { std=1; continue; }

  }

  if ((qdll)&&(dosX)) usage();

  if (qdll) dosX='L';  //QDLL

  //setup defaults
  if (!dosX) dosX='P';  //PMODE/W

  //get name
  strcpy(fn,arg_names[0]);
  fsplit(fn,fn_path,fn_name,fn_ext);
  strcpy(tn,fn_path);  //Copy path into name
  strcat(tn,fn_name);
  strcpy(fn_name,tn);

  if (qdll) {
    //QDLL Cleanup
    strcpy(fn1,fn_name);
    strcat(fn1,".EXE");
    unlink(fn1);
    strcpy(fn2,fn_name);
    strcat(fn2,".QDL");
    unlink(fn2);
  } else {
    //EXE Cleanup
    strcpy(fn1,fn_name);
    strcat(fn1,".EXE");
    unlink(fn1);
  }

  ho=_creat("qlink.tmp",FA_ARCH);
  if (ho==-1) error("Could not creat 'qlink.tmp'");
  strcpy(tn,qlib);
  strcat(tn,"\\bin\\qlib.lnk");
  CopyFile(ho,tn);

  writeln("system ");
  switch (dosX) {
    case 'W':writeln("wdosx\r\n");break;
    case 'D':writeln("dos4g\r\n");break;
    case 'P':writeln("pmodew\r\n");break;
    case 'L':writeln("qdll\r\n");break;
    case 'O':
      writeln("other\r\n");
      if (stubfn!=NULL) {
        writeln("option stub=");
        writeln(stubfn);
        writeln("\r\n");
      }
      break;
  }

  if (bug) writeln("debug watcom all\r\n");

  strcpy(tn,"libpath .;");
  strcat(tn,qlib);
  strcat(tn,"\\lib;");
  if (lib!=NULL) strcat(tn,lib);
  strcat(tn,"\r\n");
  writeln(tn);

  strcpy(tn,"path .;");
  strcat(tn,qlib);
  strcat(tn,"\\lib;");
  if (lib!=NULL) strcat(tn,lib);
  strcat(tn,"\r\n");
  writeln(tn);

  if (qdll) {
    strcpy(tn,"name ");
    strcat(tn,fn1);
    strcat(tn,"\r\n");
    writeln(tn);
    if (!std) {
      strcpy(tn,"file ");
      strcat(tn,qlib);
      strcat(tn,"\\lib\\c0dll.obj\r\n");
      writeln(tn);
//      strcpy(tn,"library ");
//      strcat(tn,qlib);
//      strcat(tn,"\\lib\\qdll.lib\r\n");
//      writeln(tn);
    }
  } else {
    strcpy(tn,"name ");
    strcat(tn,fn);
    if (!strlen(fn_ext)) strcat(tn,".exe");
    strcat(tn,"\r\n");
    writeln(tn);
    if (!std) {
      strcpy(tn,"file ");
      strcat(tn,qlib);
      strcat(tn,"\\lib\\c0.obj\r\n");
      writeln(tn);
      strcpy(tn,"library ");
      strcat(tn,qlib);
      strcat(tn,"\\lib\\qlib.lib\r\n");
      writeln(tn);
    }
  }
  if (map) {
    strcpy(tn,"option map=");
    strcat(tn,fn_name);
    strcat(tn,".map\r\n");
    writeln(tn);
  }

  for(a=1;a<arg_namesc;a++) {
    fsplit(arg_names[a],NULL,tn,NULL);
    if (!stricmp(tn,"LIB")) {
      strcpy(tn,"library ");
      strcat(tn,arg_names[a]);
    } else {
      strcpy(tn,"file ");
      strcat(tn,arg_names[a]);
    }
    strcat(tn,"\r\n");
    writeln(tn);
  }

  close(ho);

  system("wlink @qlink.tmp");
  printf("\n");

  ho=open(fn1,O_BINARY | O_RDONLY);
  if (ho==-1) error("Link unsuccessful");
  close(ho);

  unlink("qlink.tmp");

  strcpy(tn,fn_name);
  strcat(tn,".bld");
  ho=open(tn,O_BINARY | O_RDONLY);
  if (ho!=-1) {
    close(ho);
    strcpy(cmd,"qbuild ");
    strcat(cmd,tn);
    system(cmd);
  }

  if (qdll) {
    strcpy(cmd,"qdllfix ");
    strcat(cmd,fn1);
    strcat(cmd," -bd");
    system(cmd);
    printf("Complete!\n");
    exit(0);
  }

  strcpy(tn,fn_name);
  strcat(tn,".SET");
  ho=open(tn,O_BINARY | O_RDONLY);
  if (ho!=-1) {
    close(ho);
    ho=_creat("$qset$.bat",FA_ARCH);
    if (ho==-1) error("Could not create '$qset$.bat'");
    CopyFile(ho,tn);
    close(ho);
    strcpy(cmd,"$qset$.bat ");
    strcat(cmd,fn_name);
    strcat(cmd,".exe ");
    switch (dosX) {
      case 'W':strcat(cmd,"wdosx");break;
      case 'D':strcat(cmd,"dos4g");break;
      case 'P':strcat(cmd,"pmodew");break;
      case 'L':strcat(cmd,"qdll");break;
    }
    system(cmd); //execute BAT file
    unlink("$qset$.bat"); //delete it
  } else {
    if (dosX=='P') {
      strcpy(cmd,"pmwsetup /B0 ");
      strcat(cmd,fn1);
      system(cmd);
    }
  }

  if ((lite)&&(dosX=='P')) {
    strcpy(cmd,"QLITE ");
    strcat(cmd,fn1);
    system(cmd);  //compress EXE
  }

}
