/* evtest.c
 *
 * a event scheduling example
 */

#include <stdio.h>
#include <stdlib.h>
#include "simc.h"

/*----------------------------------------------------------*/
/*--- Data Structures ---*/
typedef struct 
{
  int      Status;
  Set_ID   Queue;
} 
Server_Type;

typedef struct 
{
  double Entry_Time;
  int    Number;
}
Customer_Type;

/*----------------------------------------------------------*/
Server_Type Server;

double Entry_Interval,
       Service_Interval;
int    Sample_Number = 1,
       Sample_Size;

Tally_ID Average_Queue_Time,
         Average_System_Time;

#define _Free 0
#define _Busy 1

/*----------------------------------------------------------*/
int    Entry( void);
int    Start( void);
int    Finish( Customer_Type* );

/*----------------------------------------------------------*/
void main( void)
{
  Average_Queue_Time  = TallyCreate();
  Average_System_Time = TallyCreate();
  Server.Queue = SetCreate();

  printf( "\n"
    "Enter\n"
    "Sample Size, Entry Interval, Service Interval\n");

  scanf( "%d %lf %lf",
    &Sample_Size,
    &Entry_Interval,
    &Service_Interval);

  EvSchedule( Entry, NULL, 0.0);
  EvSimulate();

  printf( "\n"
    "Average Queue Time  was %8.2f\n"
    "Average System Time was %8.2f\n",
    TallyMean( Average_Queue_Time),
    TallyMean( Average_System_Time));
}

/*----------------------------------------------------------*/
int Entry( void)
{
  Customer_Type *Customer;

  Create( Customer, Customer_Type);

  Customer->Entry_Time = EvClock();

  SetSaveLast( Server.Queue, Customer);

  EvSchedule( Start, NULL, 0.0);

  Customer->Number = Sample_Number ++;

  printf( "Customer %3d Enters   at %8.2f\n",
          Customer->Number,
          EvClock());

  if( Sample_Number <= Sample_Size)
    EvSchedule( Entry, NULL, Entry_Interval);

  return( 0);
}

/*----------------------------------------------------------*/
int Start( void)
{
  Customer_Type *This_Customer;

  if( Server.Status          == _Free
  &&  SetSize( Server.Queue) >  0)
  {
    Server.Status = _Busy;

    This_Customer = ( Customer_Type*) SetGetFirst( Server.Queue);

    Tally( Average_Queue_Time,
           (EvClock() - This_Customer->Entry_Time));

    printf( "Customer %3d Starts   at %8.2f\n",
            This_Customer->Number,
            EvClock());

    EvSchedule( Finish, This_Customer, Service_Interval);
  }
  return( 0);
}

/*----------------------------------------------------------*/
int Finish( Customer_Type* This_Customer)
{
  Server.Status = _Free;

  EvSchedule( Start, NULL, 0.0);

  Tally( Average_System_Time,
         (EvClock() - This_Customer->Entry_Time));

  printf( "Customer %3d Finishes at %8.2f\n",
          This_Customer->Number,
          EvClock());

  free( This_Customer);

  return( 0);
}

/*----------------------------------------------------------*/
