/* prtest.c
 *
 * Server-Customer process-oriented model
 */


#include <stdio.h>
#include <malloc.h>
#include <Time.h>
#include "simc.h"

/*----------------------------------------------------------*/
/*--- Data Structures ---*/
struct Customer_Type
{
  double Entry_Time;
  int    Number;
}
*Customer;

/*----------------------------------------------------------*/
Svr_ID Server;

double Entry_Interval,
       Service_Interval;
int    Sample_Number = 1,
       Sample_Size;

Tally_ID Average_Queue_Time,
         Average_System_Time;

/*--- Prototypes ---*/
int    Entry_Generator( void);
int    Service( struct Customer_Type *);

/*----------------------------------------------------------*/
void main( void)
{
  int Capacity;

  printf( "\n"
    "Enter\n"
    "Number of       Intervals\n"
    "Server, Sample, Entry, Service\n");

  scanf( "%d %d %lf %lf",
         &Capacity,
         &Sample_Size,
         &Entry_Interval,
         &Service_Interval);

  Average_Queue_Time  = TallyCreate();
  Average_System_Time = TallyCreate();
  Server              = SvrCreate( Capacity);

  EvSetPriority( Entry_Generator, 2);
  EvSetPriority( Service,         1);

  EvSchedule( Entry_Generator, NULL, 0.0);
  EvSimulate();

  printf( "\n"
    "Average Queue Time  was %8.2f\n"
    "Average System Time was %8.2f\n",
    TallyMean( Average_Queue_Time),
    TallyMean( Average_System_Time));
}

/*----------------------------------------------------------*/
int Entry_Generator( void)
{
  ProcessBegin;

  while( Sample_Number <= Sample_Size)
  {
    Create( Customer, struct Customer_Type);

    Customer->Number     = Sample_Number ++;
    Customer->Entry_Time = EvClock();
    printf( "Customer %3d Enters   at %8.2f\n",
            Customer->Number,
            EvClock());

    EvSchedule( Service, Customer, 0.0);

    Wait( Entry_Interval);
  }
  ProcessEnd;
}

/*----------------------------------------------------------*/
int Service( struct Customer_Type *Customer)
{
  ProcessBegin;

  Request( 1, Server);

  Tally( Average_Queue_Time,
         (EvClock() - Customer->Entry_Time));

  printf( "Customer %3d Starts   at %8.2f\n",
          Customer->Number,
          EvClock());

  Wait( Service_Interval);

  Tally( Average_System_Time,
         (EvClock() - Customer->Entry_Time));

  printf( "Customer %3d Finishes at %8.2f\n",
          Customer->Number,
          EvClock());

  Release( 1, Server);

  free( Customer);

  ProcessEnd;
}
/*----------------------------------------------------------*/
