/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n,
int vectrow)
{
fraction k;
fraction l;
fraction kplsl;

double pbu    [MXR][MXC*TWOCOL];matrix mu    ={MXR,MXC*TWOCOL,&pbu    [0][0]};
double pbku   [MXR][MXC*TWOCOL];matrix mku   ={MXR,MXC*TWOCOL,&pbku   [0][0]};
double pblu   [MXR][MXC*TWOCOL];matrix mlu   ={MXR,MXC*TWOCOL,&pblu   [0][0]};

double pkplsl_u[MXR][MXC*TWOCOL];matrix mkplsl_u={MXR,MXC*TWOCOL,&pkplsl_u[0][0]};
double pkuplslu[MXR][MXC*TWOCOL];matrix mkuplslu={MXR,MXC*TWOCOL,&pkuplslu[0][0]};

double pkuplslu_mns_kplsl_u[MXR][MXC*TWOCOL];
matrix mkuplslu_mns_kplsl_u={MXR,MXC*TWOCOL,&pkuplslu_mns_kplsl_u[0][0]};

if(vectrow)
  {
           mu.rows = 1;                   mu.cols = n*TWOCOL;
          mku.rows = 1;                  mku.cols = n*TWOCOL;
          mlu.rows = 1;                  mlu.cols = n*TWOCOL;
     mkplsl_u.rows = 1;             mkplsl_u.cols = n*TWOCOL;
     mkuplslu.rows = 1;             mkuplslu.cols = n*TWOCOL;

     mkuplslu_mns_kplsl_u.rows = 1;
     mkuplslu_mns_kplsl_u.cols = n*TWOCOL;
  }
else
  {
           mu.rows = n;                   mu.cols = 1*TWOCOL;
          mku.rows = n;                  mku.cols = 1*TWOCOL;
          mlu.rows = n;                  mlu.cols = 1*TWOCOL;
     mkplsl_u.rows = n;             mkplsl_u.cols = 1*TWOCOL;
     mkuplslu.rows = n;             mkuplslu.cols = 1*TWOCOL;

     mkuplslu_mns_kplsl_u.rows = n;
     mkuplslu_mns_kplsl_u.cols = 1*TWOCOL;
   }
/*-------------------------------- PROGRAM ---------------------------------- */
  k = rndFI (5);
  l = rndFI (5);

  rndmI(&mu,5);

  clrscrn();
  printf("                                 k = %3.0f\n", k.numer);
  printf("                                 l = %3.0f\n", l.numer);
  kplsl = addF(k,l);
  printf("                             k + l = %3.0f\n", kplsl.numer);

  printf("                                 u");
  printmI3(&mu);
  printf("                         (k + l) u");
  smultmF(kplsl,&mu,&mkplsl_u);
  printmI3(         &mkplsl_u);
  getchar();

  clrscrn();
  printf("                                 k = %3.0f\n", k.numer);
  printf("                                 l = %3.0f\n", l.numer);
  printf("                                 u");
  printmI3(&mu);
  printf("                                ku");
  smultmF(k,&mu,&mku);
  printmI3(     &mku);
  printf("                                lu");
  smultmF(l,&mu,&mlu);
  printmI3(     &mlu);
  printf("                           ku + lu");
  addmF(&mku,&mlu,&mkuplslu);
  printmI3(       &mkuplslu);
  getchar();

  clrscrn();
  printf("                           ku + lu");
  printmI3(&mkuplslu);
  printf("                         (k + l) u");
  printmI3(&mkplsl_u);
  printf("            [ku + lu] - [(k + l) u]");
  submF(&mkuplslu, &mkplsl_u,&mkuplslu_mns_kplsl_u);
  printmI3(                  &mkuplslu_mns_kplsl_u);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n            Vector space axioms.                  ");
  printf("\n                                                  ");
  printf("\n          [ku + lu] = [(k + l) u]                 ");
  printf("\n          ***********************                 ");
  printf("\n\n\n                                              ");
  printf("\n The size of u, v : 2x1 ... 4x1.                \n");
  printf("\n     ex : \"vfI.exe\"                           \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"vfI.exe 2\" -> 2x1  (1x2)             ");
  printf("\n          \"vfI.exe 4\" -> 4x1  (1x4)           \n");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
int    vectrow = 1;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {    n=rndpI(4);}
   if(n<2){n=2;}

if( vectrow){vectrow = 0;}
else        {vectrow = 1;}


  AB(n,vectrow);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












