/* gaussjordan4.c                   freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* --------------------------------- MAIN ----------------------------------- */
 main()
{
fraction f;

double pbu1[1][3*TWOCOL]=
{
 1,1, 1,1, 1,1,
};
matrix mu1={1,3*TWOCOL,&pbu1[0][0]};

double pbu2[1][3*TWOCOL]=
{
 0,1, 1,1, 1,1,
};
matrix mu2={1,3*TWOCOL,&pbu2[0][0]};

double pbu3[1][3*TWOCOL]=
{
 0,1, 0,1, 1,1,
};
matrix mu3={1,3*TWOCOL,&pbu3[0][0]};


double pbv1[1][3*TWOCOL];matrix mv1={1,3*TWOCOL,&pbv1[0][0]};
double pbv2[1][3*TWOCOL];matrix mv2={1,3*TWOCOL,&pbv2[0][0]};
double pbv3[1][3*TWOCOL];matrix mv3={1,3*TWOCOL,&pbv3[0][0]};
double pbvn[1][3*TWOCOL];matrix mvn={1,3*TWOCOL,&pbvn[0][0]};
double pbvT[1][3*TWOCOL];matrix mvT={1,3*TWOCOL,&pbvT[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */
   printf("\n Consider the vector space R**3 with the Euclidean\n");
   printf("       inner product, and a basis of R**3.\n");

   printmF(&mu1);
   printmF(&mu2);
   printmF(&mu3);

  copymF(&mu1,&mv1);
  projwn(&mu2,&mv1,&mvn);
   submF(&mu2,&mvn,&mv2);

  projwn(&mu3,&mv1,&mvn);
   submF(&mu3,&mvn,&mvT);
  projwn(&mu3,&mv2,&mvn);
   submF(&mvT,&mvn,&mv3);

  printf("\n If we apply the Gram-Schmidt process on the vectors\n");
  printf("         we obtain a orthogonal basis.\n");

  printmF3(&mv1);
  printmF3(&mv2);
  printmF3(&mv3);

  f = innerprod(&mv1,&mv2);
  printf("\n  v1.v2 =  %6.0lf/%-6.0lf\n",f.numer,f.denom);

  f = innerprod(&mv1,&mv3);
  printf("  v1.v3 =  %6.0lf/%-6.0lf\n",f.numer,f.denom);

  f = innerprod(&mv2,&mv3);
  printf("  v2.v3 =  %6.0lf/%-6.0lf\n",f.numer,f.denom);

 printf("\n Press return to continue");
 getchar();

 return 0;
}



