/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
invB(int n)
{
fraction det;
double pbA      [MXR][MXC*TWOCOL];matrix mA       ={MXR,MXC*TWOCOL,&pbA      [0][0]};
double pbB      [MXR][MXC*TWOCOL];matrix mB       ={MXR,MXC*TWOCOL,&pbB      [0][0]};
double pbP      [MXR][MXC*TWOCOL];matrix mP       ={MXR,MXC*TWOCOL,&pbP      [0][0]};
double pbAP     [MXR][MXC*TWOCOL];matrix mAP      ={MXR,MXC*TWOCOL,&pbAP     [0][0]};
double pbT1     [MXR][MXC*TWOCOL];matrix mT1      ={MXR,MXC*TWOCOL,&pbT1     [0][0]};
double pbT2     [MXR][MXC*TWOCOL];matrix mT2      ={MXR,MXC*TWOCOL,&pbT2     [0][0]};
double pinvP    [MXR][MXC*TWOCOL];matrix minvP    ={MXR,MXC*TWOCOL,&pinvP    [0][0]};
double pinvPAP  [MXR][MXC*TWOCOL];matrix minvPAP  ={MXR,MXC*TWOCOL,&pinvPAP  [0][0]};
double pbTrpsA  [MXR][MXC*TWOCOL];matrix mTrpsA   ={MXR,MXC*TWOCOL,&pbTrpsA  [0][0]};
double pbTrpsB  [MXR][MXC*TWOCOL];matrix mTrpsB   ={MXR,MXC*TWOCOL,&pbTrpsB  [0][0]};
double pbTrpsP  [MXR][MXC*TWOCOL];matrix mTrpsP   ={MXR,MXC*TWOCOL,&pbTrpsP  [0][0]};
double pTrpsinvP[MXR][MXC*TWOCOL];matrix mTrpsinvP={MXR,MXC*TWOCOL,&pTrpsinvP[0][0]};

double pinv_TrpsinvP[MXR][MXC*TWOCOL];
matrix minv_TrpsinvP={MXR,MXC*TWOCOL,&pinv_TrpsinvP[0][0]};

                      mA.rows=n;                    mA.cols=n*TWOCOL;
                      mB.rows=n;                    mB.cols=n*TWOCOL;
                      mP.rows=n;                    mP.cols=n*TWOCOL;
                     mAP.rows=n;                   mAP.cols=n*TWOCOL;
                     mT1.rows=n;                   mT1.cols=n*TWOCOL;
                     mT2.rows=n;                   mT2.cols=n*TWOCOL;
                   minvP.rows=n;                 minvP.cols=n*TWOCOL;
                  mTrpsA.rows=n;                mTrpsA.cols=n*TWOCOL;
                  mTrpsB.rows=n;                mTrpsB.cols=n*TWOCOL;
                  mTrpsP.rows=n;                mTrpsP.cols=n*TWOCOL;
                 minvPAP.rows=n;               minvPAP.cols=n*TWOCOL;
               mTrpsinvP.rows=n;             mTrpsinvP.cols=n*TWOCOL;
           minv_TrpsinvP.rows=n;         minv_TrpsinvP.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  do
  {
               rndmI(&mP,5);
          det = detF(&mP);
  }while(!det.numer);

  rndmI(&mA,5);

  inverseF(&mP,&minvP);
    multmF(&mA,&mP,&mAP);
    multmF(&minvP,&mAP,&mB);

  clrscrn();
  printf(" If A and B are square matrices, \n");
  printf(" we say that B is similar to A\n");
  printf(" if there is an invertible matrix P such that :\n\n");
  printf("            B = invPAP\n\n");
  printf("                                                               A :");
  printmI(&mA);
  printf("                                                               B :");
  printmF3(&mB);
  printf("                                                         If P is :");
  printmI(&mP);
  printf("                                                         invP is :");
  printmF3(&minvP);
  getchar();

  clrscrn();
  printf("                                                               B :");
  printmF4(&mB);
  printf("                                                          invPAP :");
  multmF(&mA,&mP,&mAP);
  multmF(&minvP,&mAP,&minvPAP);
  printmF4(          &minvPAP);
  printf("                               B = invPAP also B is similar to A :\n\n");
  getchar();

  clrscrn();
  printf(" If B = invPAP then  TrpsB = inv(Trps(invP)) TrpsA Trps(invP) \n\n");
  transposemF(&mA,&mTrpsA); transposemF(&mB,&mTrpsB); transposemF(&mP,&mTrpsP);
  transposemF(&minvP,&mTrpsinvP);
  printf("                                                           TrpsA :");
  printmI(&mTrpsA);
  printf("                                                           TrpsB :");
  printmF3(&mTrpsB);
  printf("                                                     If TrpsP is :");
  printmI(&mTrpsP);
  printf("                                                     TrpsinvP is :");
  printmF3(&mTrpsinvP);
  getchar();

  clrscrn();
  printf("                                                           TrpsB :");
  printmF4(&mTrpsB);
  printf("                                inv(Trps(invP)) TrpsA Trps(invP) :");
  inverseF(&mTrpsinvP,&minv_TrpsinvP);
  multmF(             &minv_TrpsinvP,&mTrpsA,&mT1);
  multmF(                                    &mT1,&mTrpsinvP,&mT2);
  printmF4(                                                  &mT2);
  printf("\n\n    TrpsB = inv(Trps(invP)) TrpsA Trps(invP)\n\n");
  printf("          also TrpsB is similar to TrpsA\n\n");
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n            If B is similar to A,               \n");
  printf("\n      then TrpsB and TrpsA are similar.         \n");
  printf("\n                 *************                  \n");
  printf("\n The size of mA : 2x2 ... 3x3.                  \n");
  printf("\n           ex : \"simil9.exe\"                  \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"simil9.exe 2\" -> mA 2x2        ");
  printf("\n                \"simil9.exe 3\" -> mA 3x3        ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 3){n=3;}}
else
 {  n = rndpI(3);}
if( n < 2){n=2;}


  invB(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}



