/*
==============================================================================
                      WordUp Graphics Toolkit Version 5.0                     
                             Demonstration Program 48                         
                                                                              
 Demonstrates the use of the wremap command. A block will be loaded and      
 shown in its desired colors. It will then be shown using the default        
 palette, and then remapped and shown again with the default palette.        
 The routine will produce an image which fits the current palette as much    
 as possible.                                                                
                                                                              
 *** PROJECT ***                                                             
 This program requires the WGT5_WC.LIB file to be linked.                    
                                                                              
 *** DATA FILES ***                                                          
 WGT1.PCX must be in the executable directory.                  
                                                           WATCOM C++ VERSION 
==============================================================================
*/

#include <stdlib.h>
#include <conio.h>
#include <wgt5.h>

block myimage;
color desired[256], defaultpal[256];

void main (void)
{
  short oldmode;

  if ( !vgadetected () )
  {
    printf ("Error - VGA card required for any WGT program.\n");
    exit (0);
  }
  printf ("WGT Example #48\n\n");
  printf ("The WREMAP command is demonstrated by loading in image from disk and trying\n");
  printf ("to display it with the default palette. The same image is then displayed\n");
  printf ("after being remapped. Press a key to skip each screen.\n");
  printf ("\n\nPress any key to continue.\n");
  getch();

  oldmode = wgetmode ();         /* Store current video mode     */
  vga256 ();                     /* Initialize WGT system        */

  wtextcolor (15);              /* Text color will be white */
  wtexttransparent (TEXTFGBG);  /* No transparencies */

  myimage = wloadpcx ("wgt1.pcx", desired); /* Load the image */
  wreadpalette (0, 255, defaultpal);    /* Store default palette */

  wsetpalette (0, 255, desired);        /* Now set the palette */
  wputblock (0, 0, myimage, NORMAL);    /* And show the image */
  wouttextxy (10, 180, NULL, "Using image palette");
  getch ();                             /* Wait for keypress */

  wsetpalette (0, 255, defaultpal);     /* Set to default palette */
  wouttextxy (10, 180, NULL, "Using default palette");
  getch ();                             /* Wait for keypress */

  wremap (desired, myimage, defaultpal);/* Remap the image */
  wputblock (0, 0, myimage, NORMAL);    /* And show the image */
  wouttextxy (10, 180, NULL, "Using default palette after WREMAP");
  getch ();                             /* Wait for keypress */

  wfreeblock (myimage);                 /* Deallocate the image */

  wsetmode (oldmode);                   /* Reset to text mode */
}
