/*
 *                      *************
 *                      * X R F . H *
 *                      *************
 *
 * This is the common header for the C xrf'er.
 *
 * Version V1.3          9-May-80
 * Version V1.4		10-Jul-80 MM
 * Version V1.5		 2-Jan-85 MC	Rainbow implementation
 * Version V1.6		12-Jan-85 MC	allow for procid (2 extraa chars)
 */
#define SCPS   8                /* CI86 Relevant characters per symbol SMALL*/
#define LCPS   31               /* CI86 Relevant characters per symbol LARGE*/

#define FFLAG  2                /* number of chars added to Symbol for procid*/
#define NCPS   LCPS+FFLAG       /* CI86 max Symbol size  [incl proc id '()'] */
#define CPS    symbolsize+FFLAG /* characters per Symbol [incl proc id '()'] */
#define LWIDTH 132              /* Listing width, characters */
#define RSIZE  5		/* Reference width in format statement */
#define MAXLIN 57               /* Listing lines per page (excl. header) */

/*
 * Structure definitions.
 */

struct  ref     {                       /* REFERENCE LIST NODE */
                int lno;                /* Line number of reference */
                struct ref *next;       /* Link to next ref in chain */
                };

struct  idt     {                       /* ID TREE NODE STRUCTURE */
                char *keyp;             /* Pointer to stashed key string */
                struct ref *first;      /* Pointer to head of ref chain */
                struct ref *last;       /* Pointer to tail of ref chain */
                struct idt *left;       /* Left link in id tree */
                struct idt *right;      /* Right link in id tree */
                };

/*
 * Global Variables.
 */

extern FILE *src;               /* Source file pointer */
extern FILE *lst;               /* List file pointer */

extern int prnflg;              /* Print source file flag */
extern int conflg;              /* Concatanate source file flag */
extern int verbose;             /* chatty mode flag */

extern char scanbf[LWIDTH+1];   /* Source line scan buffer */
extern char *scanp;             /* Scan pointer */

extern char idbuf[NCPS+1];      /* ID string buffer */
extern char lastsym[NCPS+1];    /* previous symbol [XRF3] (avoid repitition) */

extern char progname[9];	/* current source program name */
extern char pghead[LWIDTH+1];   /* Listing page heading */
extern char thetime[9];         /* For unix flavored systems*/
extern char thedate[23];        /* For unix flavored systems*/

extern int  lineno;             /* Current source line number */
extern int  linpg;              /* Lines-per-page count */
extern int  linewidth;		/* line width */
extern int  rperline;		/* References per line */
extern int  symbolsize;		/* Symbol size (df=8) (-i changes to NCPS)*/
extern struct idt *root;        /* --> root of ident tree */
