; DEVICE.ASM (C) 1986 Communication Horizons
; Author : Neil Weicher
; Syntax : CALL DEVICE WITH <expC>
; Purpose: Redirects printer output to the specified device or
;          file
; Notes  : <expC> is a legal device name or file name.  If a
;          device name is specified it should not have a
;          trailing colon ':'.  If a file name is specified it
;          will be created, if necessary.  Any data in an
;          existing file will be lost.  The file will not be
;          closed until another CALL DEVICE is performed, or 
;          until the program ends.  Can be used with Clipper,
;          dBase III or Lattice C.  Example: CALL DEVICE WITH
;          "LPT2" CALL DEVICE WITH "LPT1" && default at program
;          startup CALL DEVICE WITH "C:OUTPUT.TXT"

        PUBLIC  DEVICE
CLIPPER EQU     1                   ;1 = CLIPPER , 0 = DBASE III

_PROG   SEGMENT BYTE
        ASSUME  CS:_PROG
DEVICE  PROC    FAR

        ;DIFFERENT SUBROUTINE LINKAGE BETWEEN CLIPPER AND DBASE
        IF      CLIPPER
        PUSH    BP
        MOV     BP,SP
        PUSH    DS
        LDS     DX,DWORD PTR [BP+6]    ;DS:DX = FILE NAME
        ELSE
        MOV     DX,BX                   ;DS:DX = FILE NAME
        ENDIF

        ;CLOSE THE CURRENTLY DEFINED PRINTER (HANDLE 4)
        MOV     AH,3EH
        MOV     BX,4
        INT     21H

        ;TRY TO OPEN SPECIFIED FILE
        MOV     AX,3D01H                ;OPEN FILE
        INT     21H
        JNC     EXIT

        ;NOT SUCCESSFUL, TRY TO CREATE FILE
        MOV     AH,3CH                  ;CREATE FILE
        SUB     CX,CX                   ;ATTRIBUTE
        INT     21H

EXIT:
        IF      CLIPPER
        POP     DS
        POP     BP
        ENDIF
        RET

DEVICE  ENDP
_PROG   ENDS

        END

; End of file
