* Function: ATINSAY
* Author..: Richard Low
* Syntax..: ATINSAY( <expN1>, <expN2>, <expC1>, <expC2> )
* Returns.: A Null ('') string after SAYing <expC2>.
* Notes...: @ <expN1>, <expN2> SAYs <expC2> in color setting <expC1>
*

FUNCTION ATINSAY

PARAMETERS p_row, p_col, p_color, p_string

PRIVATE f_incolor

*-- first verify parameters were passed and are correct types
IF TYPE('p_row')   + TYPE('p_col') +;
   TYPE('p_color') + TYPE('p_string') = 'NNCC'
   f_incolor = SETCOLOR(p_color)               && save old and set new color
   @ p_row,p_col SAY p_string                    && say the string
   SETCOLOR(f_incolor)                        && restore old color
ENDIF

RETURN ('')
