* Function.: STR2DATE
* Author...: Richard Low
* Syntax...: STR2DATE( <expC> )
* Returns..: <expC> as a dBase date type variable.
* Parameter: exp<c> = string type date (Jan 1, 1987)
* Notes....: Converts a string in the format (January 1, 1987) to a date.
*            If an invalid date string is given, an empty date is returned.

FUNCTION STR2DATE
PARAMETER p_strdate
PRIVATE f_mthnames, f_month, f_day, f_year

*-- take the first 3 characters of the string, and convert to numeric month
f_mthnames = '  JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC'
f_month = INT( AT( UPPER( SUBSTR( LTRIM(p_strdate) ,1,3) ), f_mthnames ) / 3)

IF f_month = 0
   *-- if not found, invalid date string
   RETURN (CTOD('  /  /  '))
ENDIF

*-- left pad this number with zeros and convert to string
f_month = SUBSTR(STR(f_month+100,3,0),2,2)

*-- the day starts at the first space, VAL will stop at a space or comma
f_day = INT( VAL( SUBSTR( p_strdate, AT(' ',p_strdate) ) ) )

*-- convert this numeric day to zero padded string
f_day = SUBSTR(STR(f_day+100,3,0),2,2)

f_year = VAL( SUBSTR( p_strdate, AT(',',p_strdate)+1 ) )

*-- see if they gave full year or short year (full year > 100)
f_year = IF( f_year > 100, STR(f_year,4,0), '00' + STR(f_year,2,0) )

*-- now get just the last 2 digits
f_year = SUBSTR(f_year,3,2)

*-- now concoct date by adding string month, string day, and str year
RETURN ( CTOD( f_month + '/' + f_day + '/' + f_year ) )
