; ----- BREAKOUT: Play a breakout game.
; ----------------------------------------------------------------
;	Note: This script plays a breakout-style game.	Cursor control
;	keys or mouse may be used to control the paddle.  Comments in
;	this script have been limited for execution speed.
; ----------------------------------------------------------------
;
; Initialize
;
GOSUB Init
SET FLAG OFF
; Move the ball until keypress or obstruction
Ball:
IF GE N1 79
   N1 = 79
   N3 = -1
   ENDIF
IF LE N1 0
   N1 = 0
   N3 = 1
   ENDIF
IF HITKEY GOTO Paddle
N4 = N0
N5 = N1
N0 = N0+N2
N1 = N1+N3
SWIT N4
  CASE 1
  ATSAY N4,N5 (Blac,blue) S4
  ENDC
  CASE 2
  ATSAY N4,N5 (Blac,cyan) S4
  ENDC
  CASE 3
  ATSAY N4,N5 (Blac,yell) S4
  ENDC
  CASE 4
  ATSAY N4,N5 (Blac,red) S4
  ENDC
  CASE 22
  ATSAY N4,N5 (Blac,Gree) S4
  ENDC
  DEFA
  ATSAY N4,N5 (Blac,Whit) S4
  ENDC
ENDS
ATSCR N0,N1 1 S4
N4 = N0
N5 = N1
ATSAY N0,N1 (Blac,Whit) "o"
IF LE N0,0
   GOTO Hit_Top
   ENDIF
IF LT N0 5
   GOTO In_Bricks
   ENDIF
SET FLAG OFF
IF GE N0,22
   GOTO On_Paddle
   ENDIF
IF LE N1,0
   GOTO Wall
   ENDIF
IF GE N1,79
   GOTO Wall
   ENDIF
GOTO Ball
;
;	We've hit the top
;
Hit_Top:
N2 = -N2
SET FLAG ON
GOTO Ball
;
;	We've hit the left or right wall
;
Wall:
N3 = -N3
SOUND 100 10
IF GE N0 4 ; test in bricks
   GOTO Ball
   ENDIF
;
;	We're in the bricks
;
In_Bricks:
IF NULL S4
   GOTO Ball
   ENDIF
IF GT N2 0 ; going down
   GOTO Breakout
   ENDIF
;
;	Take a brick
;
Take_Brick:
N8 = (N1/4)*4
N7 = N8+3
SWIT N0
   CASE  1
   S0(N8:N7) = "    "
   S3(N1:N1) = "o"
   ATSAY 1,N8 (Blac,Blue) S0(N8:N7)
   SOUND 4000 1
   N10 = N10+4
   ENDC

   CASE  2
   S1(N8:N7) = "    "
   S3(N1:N1) = "o"
   ATSAY 2,N8 (Blac,cyan) S1(N8:N7)
   SOUND 2000 1
   N10 = N10+3
   ENDC

   CASE  3
   S2(N8:N7) = "    "
   S3(N1:N1) = "o"
   ATSAY 3,N8 (Blac,yell) S2(N8:N7)
   SOUND 1000 1
   N10 = N10+2
   ENDC

   CASE  4
   S3(N8:N7) = "    "
   S3(N1:N1) = "o"
   ATSAY 4,N8 (Blac,red ) S3(N8:N7)
   SOUND 500 1
   N10 = N10+4
   ENDC
ENDS
S4 = " "
N2 = -N2
GOTO Ball
;
;	We have a breakout
;
Breakout:
IF NOT FLAG
   GOTO Ball
   ENDIF
SWIT N0
   CASE  1
   ENDC

   CASE  2
   N8 = N1+N3
   IF NULL S2(N8:N8)
      N2 = -N2
      ENDIF
   ENDC

   CASE  3
   N8 = N1+N3
   IF NULL S3(N8:N8)
      N2 = -N2
      ENDIF
   ENDC

   CASE  4
   N2 = -N2
   ENDC
ENDS
GOTO Take_Brick
;
;	We're on the paddle line
;
On_Paddle:
N8 = N9-1
IF EQ N1 N8
   GOTO Reverse
   ENDIF
N8 = N9+4
IF EQ N1 N8
   GOTO Reverse
   ENDIF
IF EQ N1 N9
   GOTO English
   ENDIF
N8 = N9+3
IF EQ N1 N8
   GOTO English
   ENDIF
IF LT N1 N9
   GOTO Missed
   ENDIF
IF GT N1 N8
   GOTO Missed
   ENDIF
;
;	Hit on the paddle
;
SOUND 300 10
N2 = -N2
IF LT N3 0
   N3 = -1
ELSE
   N3 = 1
ENDIF
GOTO Ball
;
;	Give some english
;
English:
SOUND 300 10
N2 = -N2
IF LT N3 0
   N3 = N3-1
ELSE
   N3 = N3+1
ENDIF
GOTO Ball
;
;	Return the ball
;
Reverse:
SOUND 200 10
N2 = -N2
N3 = -N3
GOTO Ball
;
;	Move the paddle
;
Paddle:
KEYGET S7
IF STRCMP S7(0:3) "4D00" GOTO Right_paddle
IF STRCMP S7(0:3) "4B00" GOTO Left_Paddle
GOTO Ball
;
;	Move the paddle right
;
Right_Paddle:
ATSAY 22,N9 (Blac,Gree) "    "
IF LT N9 76
   N9 = N9+3
ELSE
   N9 = 76
   ENDIF
ATSAY 22,N9 (Blac,Gree) "____"
IF HITKEY GOTO Paddle
GOTO Ball
;
;	Move the paddle left
;
Left_Paddle:
ATSAY 22,N9 (Blac,Gree) "    "
IF GT N9 3
   N9 = N9-3
ELSE
   N9 = 0
   ENDIF
ATSAY 22,N9 (Blac,Gree) "____"
IF HITKEY GOTO Paddle
GOTO Ball
;
;	Missed the ball with the paddle
;
Missed:
N10 = N10/40 ; 200 max
SWIT N10
   CASE 0
   SOUND 50 100
   ATSAY 22,0 (Blac,gree) "Too bad..."
   ENDC
   CASE 1
   ATSAY 22,0 (Blac,gree) "Not bad..."
   SOUND 50 100
   ENDC
   CASE 2
   ATSAY 22,0 (Blac,gree) "Better than average..."
   ALARM
   ENDC
   CASE 3
   ATSAY 22,0 (Blac,gree) "Real good..."
   SOUND 100,100
   ENDC
   CASE 4
   ATSAY 22,0 (Blac,gree) "Why did you stop?"
   SOUND 100,100
   ENDC
   CASE 5
   ATSAY 22,0 (Blac,gree) "WOW..."
   ALARM
   ENDC
ENDS
EXIT
;
;	Initialization...
;	.. Placed here to cache all pgm labels when we start
;	.. S0-S3 are the rows of bricks
;	.. S4	 is the character replaced by the ball
;	.. N0,N1 is the position of the ball (row/col)
;	.. N2,N3 is the vector of motion (row/col offsets)
;	.. N9	 is the paddle col #
;
Init:
S0 = ""
S1 = ""
S2 = ""
S3 = ""
S4 = " "
N0 = 5
N1 = 0
N2 = 1
N3 = 1
N4 = N0
N5 = N1
N9 = 38
N10 = 0
;
;	Set states
;
CLEAR (Blac,Gree)
LEGEND "                              ... Breakout ..."
CUROFF
SET TTHRU OFF
;
;	Paint the screen
;
ATSAY 1,0 (Blac,Blue) S0
ATSAY 2,0 (Blac,cyan) S1
ATSAY 3,0 (Blac,yell) S2
ATSAY 4,0 (Blac,red) S3
ATSAY 22,N9 (Blac,Gree) "____"
RETURN
