
/*
	SYSTEM.HPP
	Created 1995 by Dejvid Zaninovic
*/

#ifndef SYSTEM_HPP
#define SYSTEM_HPP

#include <dos.h>
#include <stdio.h>
#include <io.h>
#include "c.hpp"

#define BIOS_READ 2
#define BIOS_WRITE 3
#define BIOS_VERIFY 4
#define BIOS_FORMAT 5

#define FA_ALL (FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_ARCH)
#define FA_NORMAL FA_ARCH

struct boot {
	char oem[8+1];						// OEM ID
	unsigned int sectorsize;			// bytes per sector
	unsigned char clustersize;			// sectors per cluster
	unsigned int reservedsectors;		// reserved sectors at beginning 
	unsigned char fatcnt;				// FAT copies
	unsigned int rootsize;				// root directory entries
	unsigned int totalsectors;			// total sectors on disk
	unsigned char media;				// media descriptor byte
	unsigned int fatsize;				// sectors per FAT
	unsigned int tracksize;				// sectors per track
	unsigned int heads;					// sides
	unsigned int hiden;					// special hidden sectors
	unsigned long total;				// big total number of sectors
	unsigned num;						// physical drive number 
	unsigned char extsign;				// extended boot record signature
	unsigned long serial;				// volume serial number
	char label [11+1];					// volume label
	char sysid [8+1];					// file system ID
};

int getboot (int drive, struct boot *boot);	// get boot info (bios)
int biosver (date &d);						// get BIOS date
unsigned machid();							// get machine id
void icaget (char *buf);					// get 16 bytes from ICA
void icaput (char *buf);					// put 16 bytes into ICA
boolean drvready (int drv);					// is drive ready (bios)
boolean drvwrite (int drv);					// can we write to drive (bios)
long getdiskfree (int drv);					// bytes free on disk (dos)
void filedel (char fname[]);				// file delete, wildcards allowed
int truename (char fname[]);				// get true path, resolve JOIN, SUBST...
int setcwd (char dir[]);					// set directory across disks
long filelength (FILE *f);					// get file length
long filelength (char name[]);              // get file length
int dostobios (int dos);                    // dos to bios drive num trans
int biostodos (int bios);                   // bios to dos drive num trans
byte getcmos (byte m);						// get cmos memory
byte setcmos (byte m, byte d);				// set cmos memory
void enable70();							// enable int 70
void disable70();							// disable int 70

inline void nmi_enable() {					// enable nmi
	outportb (0xA0, BIT7);
}

inline void nmi_disable() {					// disable nmi
	outportb (0xA0, 0);
}

inline boolean fileexist (char fname[])	{	// is file exist
	return !access (fname, 0);
}

inline void rewind (int handle) {			// set seek pointer to begin
	lseek (handle, 0, SEEK_SET);
}

inline void seekend (int handle) {          // set seek pointer to begin
	lseek (handle, 0, SEEK_END);
}

inline void seekend (FILE *f) {				// seek end of file
	fseek (f, 0, SEEK_END);
}

#endif
