/****************************************************************************/
/* FILES                                                                    */
/*--------------------------------------------------------------------------*/
/* Fonctions de manipulation des fichiers                                   */
/*--------------------------------------------------------------------------*/
/* Author      : DELPRAT Jean-Pierre                                        */
/* Created on  : 17-Apr-95                                                  */
/****************************************************************************/

#include <ctype.h>
#include <fcntl.h>
#include <io.h>
#include <share.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys\stat.h>

#include "Compat.h"

#include "Strings.h"

#include "Files.h"


#define CF        1


#ifdef __TCPLUSPLUS__
#else
extern char *__dos_argv0;
#endif

/****************************************************************************/
/* FileExists                                                               */
/*--------------------------------------------------------------------------*/
/* Indique si un fichier existe ou non                                      */
/****************************************************************************/

boolean FileExists(char *file_name)
{
  int handle;

  handle = sopen(file_name, O_RDONLY | O_BINARY, SH_DENYWR, S_IREAD);

  if (handle<0)
    return(FALSE);

  close(handle);
  return(TRUE);
}

/****************************************************************************/
/* GetCurrentDir                                                            */
/*--------------------------------------------------------------------------*/
/* Retourne le rpertoire courant du disque courant                         */
/* Retourne "" en cas de problme 		                            */
/****************************************************************************/


char *GetCurrentDir()
{
  static char s_current_dir[MAX_PATH];
  #ifdef __TCPLUSPLUS__
  #else
  char work_path[MAX_PATH];
  struct ffblk ffblk;
  char *ptr1,*ptr2;
  #endif

  if (getcwd(s_current_dir, MAX_PATH)==NULL)
    {
      s_current_dir[0]=0;
      return(s_current_dir);
    }

  #ifdef __TCPLUSPLUS__
  #else

  // Correction du rpertoire
  // -> majuscules, minuscules
  // -> \ au lieu de /


  // Drive en majuscules

  strcpy(work_path,s_current_dir);
  s_current_dir[0]=toupper(work_path[0]);
  s_current_dir[2]='\\';
  s_current_dir[3]=0;
  ptr1=work_path+3;
  ptr2=strchr(ptr1,'/');
  while (ptr2!=NULL)
    {
      (*ptr2)=0;
      findfirst(work_path,&ffblk,FA_RDONLY|FA_HIDDEN|FA_SYSTEM|FA_DIREC|FA_ARCH);
      strcat(s_current_dir,ffblk.ff_name);
      strcat(s_current_dir,"\\");
      (*ptr2)='\\';
      ptr1=ptr2+1;
      ptr2=strchr(ptr1,'/');
    }
  if (ptr1[0]!=0)
    {
      findfirst(work_path,&ffblk,FA_RDONLY|FA_HIDDEN|FA_SYSTEM|FA_DIREC|FA_ARCH);
      strcat(s_current_dir,ffblk.ff_name);
    }

  #endif

  return(s_current_dir);
}

/****************************************************************************/
/* FullPath                                                                 */
/*--------------------------------------------------------------------------*/
/* Returns the full path of a file or directory                             */
/* (or the root of the current drive in case of failure)                    */
/* full_path must be MAX_PATH bytes length (including /0)                   */
/* If a drive is indicated, this drive must exist                           */
/* Returns a boolean which indicates success or failure                     */
/****************************************************************************/

boolean FullPath(char *full_path,char *path)
{
  boolean success=TRUE;
  char last_char;
  char *ptr;

  if (strlen(path)>(MAX_PATH-1))
    {
      path="\\";
      success=FALSE;
    }

  #ifdef __TCPLUSPLUS__

  char *ptr2;

  if (_fullpath(full_path, path, MAX_PATH)==NULL)
    {
      _fullpath(full_path,"\\",MAX_PATH);
      success=FALSE;
    }

  ptr=strchr(full_path,'/');
  while (ptr!=NULL)
    {
      (*ptr)='\\';
      ptr=strchr(ptr+1,'/');
    }

  ptr=strchr(full_path,'\\');
  while (ptr!=NULL)
    {
      ptr2=ptr+1;
      while (*(ptr2)=='\\')
	ptr2++;
      ptr2--;

      if (ptr2!=ptr)
	strcpy(ptr,ptr2);

      ptr++;
      ptr=strchr(ptr,'\\');
    }

  #else
  _fixpath(path,full_path);
  ptr=strchr(full_path,'/');
  while (ptr!=NULL)
    {
      (*ptr)='\\';
      ptr=strchr(ptr+1,'/');
    }
  #endif

  last_char=EndOfString(path);

  if (   ((last_char=='\\') || (last_char=='/'))
      && (EndOfString(full_path)!='\\'))
    strcat(full_path,"\\");

  return(success);
}

/****************************************************************************/
/* FullPathOfFileInExeDir                                                   */
/*--------------------------------------------------------------------------*/
/* Returns the full path of a file or directory located in the directory of */
/* the .exe                                                                 */
/* full_path must be MAX_PATH bytes length (including /0)                   */
/* file_name must be a file_name without directory information              */
/* (if file_name have some directory information, this file name is         */
/* returned unchanged)							    */
/****************************************************************************/

void FullPathOfFileInExeDir(char *full_path,char *file_name)
{
  char *ptr;
  char *exe_name;
  int available;

  if (strchr(file_name,'\\')!=NULL)
    {
      ptr=full_path;
    }
  else
    {
      #ifdef __TCPLUSPLUS__
      exe_name=_argv[0];
      #else
      exe_name=__dos_argv0;
      #endif

      strcpy(full_path,exe_name);
      ptr=strrchr(full_path,'\\');
      if (ptr==NULL)
	ptr=full_path;
      else
	ptr++;
    }
  available=MAX_PATH-1 - ((int)(ptr-full_path));
  strncpy(ptr,file_name,available);
  full_path[MAX_PATH-1]=0;
}


/****************************************************************************/
/* DriveExists                                                              */
/*--------------------------------------------------------------------------*/
/* Checks whether a drive exists                                            */
/* 0='A', 1='B' ...                                                         */
/****************************************************************************/

boolean DriveExists(int drive)
{
  __dpmi_regs regs;

  // Le lecteur existe ?

  drive++;

  regs.x.ax=0x4409;
  regs.h.bl=drive;
  __dpmi_int(0x21, &regs);
  if ((regs.x.flags & CF)!=0)
    return(FALSE);

  // Si le lecteur est diffrent de A: ou B:, c'est suffisant

  if (drive>2)
    return(TRUE);


  // Sinon, on regarde si c'est le dernier nom logique affect au lecteur

  regs.x.ax=0x440E;
  regs.h.bl=drive;
  __dpmi_int(0x21, &regs);

  if (   ((regs.x.flags & CF)==0)
      & ( (regs.h.al==0) || (regs.h.al==drive)) )
    return(TRUE);

  return(FALSE);
}

