/****************************************************************************/
/* KEYBOARD                                                                 */
/*--------------------------------------------------------------------------*/
/* Fonctions de manipulation du clavier                                     */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 10/01/95                                                    */
/****************************************************************************/

#include <conio.h>
#include <ctype.h>

#include "Compat.h"
#include "Mouse.h"

#include "keyboard.h"


/*ͻ*/
/*                               CONSTANTES                               */
/*ͼ*/

#define ZF		     64 // Zero flag


#define RIGHT_SHIFT_PRESSED  0x01
#define LEFT_SHIFT_PRESSED   0x02
#define SHIFT_PRESSED        0x03
#define CTRL_PRESSED         0x04
#define ALT_PRESSED          0x08

#define EXTENDED             0x10

/*ͻ*/
/*                                 FONCTIONS                              */
/*ͼ*/

/****************************************************************************/
/* ResetKeyboard                                                            */
/*--------------------------------------------------------------------------*/
/* Remise  zro du clavier (vide le buffer clavier)                        */
/****************************************************************************/

void ResetKeyboard()
{
  while (KeyPressed())
    getch();
}

/****************************************************************************/
/* KeyPressed                                                               */
/*--------------------------------------------------------------------------*/
/* Indicates whether a key has peen pressed 				    */
/****************************************************************************/

boolean KeyPressed()
{
  __dpmi_regs regs;

  regs.h.ah = 0x11;
  __dpmi_int(0x16, &regs);

  if (regs.x.flags & ZF)
    return(FALSE);

  return(TRUE);
}



/****************************************************************************/
/* GetKey                                                                   */
/*--------------------------------------------------------------------------*/
/* Retourne la touche frappe.                                              */
/*                                                                          */
/* Pour les caractres ALT :                                                */
/* - key.keyboard_state & ALT_PRESSED=TRUE                                  */
/* - key.hot_character vaut la lettre frappe.                              */
/*                                                                          */
/* Pour un caractre non tendu, key.hot_character vaut la lettre frappe   */
/* convertie en majuscules                                                  */
/*                                                                          */
/* Sinon, hot_character vaut 255                                              */
/****************************************************************************/

void GetKey(TKey &key)
{
  __dpmi_regs regs;
  int keyboard_state;
  boolean extended;

  key.character = getch();

  // Touche tendue

  key.hot_character=255;
  extended=FALSE;
  if (!key.character)
    {
      extended=TRUE;
      key.character=getch();
    }
  else
    key.hot_character=toupper(key.character);


  if (extended)
    {
      regs.h.ah=0x2;
      __dpmi_int(0x16, &regs);
      keyboard_state=regs.h.al&(SHIFT_PRESSED|CTRL_PRESSED|ALT_PRESSED);
      keyboard_state|=EXTENDED;

      // Si ALT a t frapp, pas de distinction minuscules/majuscules

      if (keyboard_state&ALT_PRESSED)
	keyboard_state&=(~(SHIFT_PRESSED));
      else
	{
	  // Pas de distinction LEFT_SHIFT, RIGHT_SHIFT

	  if ((keyboard_state&RIGHT_SHIFT_PRESSED) || (keyboard_state&LEFT_SHIFT_PRESSED))
	    keyboard_state|=SHIFT_PRESSED;
	}

      key.character|=(keyboard_state<<8);

      // Dtermination de la hot-key si appui sur ALT

      if (keyboard_state&ALT_PRESSED)
	{
	  switch (key.character)
	    {
	      case ALT_1         : key.hot_character='1';break;
	      case ALT_2         : key.hot_character='2';break;
	      case ALT_3         : key.hot_character='3';break;
	      case ALT_4         : key.hot_character='4';break;
	      case ALT_5         : key.hot_character='5';break;
	      case ALT_6         : key.hot_character='6';break;
	      case ALT_7         : key.hot_character='7';break;
	      case ALT_8         : key.hot_character='8';break;
	      case ALT_9         : key.hot_character='9';break;
	      case ALT_0         : key.hot_character='0';break;

	      case ALT_BACKSPACE : key.hot_character=BACKSPACE;break;

	      case ALT_A         : key.hot_character='A';break;
	      case ALT_B         : key.hot_character='B';break;
	      case ALT_C         : key.hot_character='C';break;
	      case ALT_D         : key.hot_character='D';break;
	      case ALT_E         : key.hot_character='E';break;
	      case ALT_F         : key.hot_character='F';break;
	      case ALT_G         : key.hot_character='G';break;
	      case ALT_H         : key.hot_character='H';break;
	      case ALT_I         : key.hot_character='I';break;
	      case ALT_J         : key.hot_character='J';break;
	      case ALT_K         : key.hot_character='K';break;
	      case ALT_L         : key.hot_character='L';break;
	      case ALT_M         : key.hot_character='M';break;
	      case ALT_N         : key.hot_character='N';break;
	      case ALT_O         : key.hot_character='O';break;
	      case ALT_P         : key.hot_character='P';break;
	      case ALT_Q         : key.hot_character='Q';break;
	      case ALT_R         : key.hot_character='R';break;
	      case ALT_S         : key.hot_character='S';break;
	      case ALT_T         : key.hot_character='T';break;
	      case ALT_U         : key.hot_character='U';break;
	      case ALT_V         : key.hot_character='V';break;
	      case ALT_W         : key.hot_character='W';break;
	      case ALT_X         : key.hot_character='X';break;
	      case ALT_Y         : key.hot_character='Y';break;
	      case ALT_Z         : key.hot_character='Z';break;
	    }
	}
    }
}

/****************************************************************************/
/* IsPrintableKey                                                           */
/*--------------------------------------------------------------------------*/
/* Indique si la touche est un caractre imprimable (32  255)              */
/****************************************************************************/

boolean IsPrintableKey(TKey key)
{
  return((boolean)((key.character>=32) && (key.character<=255)));
}

/****************************************************************************/
/* IsExtendedKey                                                            */
/*--------------------------------------------------------------------------*/
/* Indique si la touche est une touche tendue (>255)                       */
/****************************************************************************/

boolean IsExtendedKey(TKey key)
{
  return((boolean)(key.character>255));
}

/****************************************************************************/
/* IsAltKey                                                                 */
/*--------------------------------------------------------------------------*/
/* Indique si la touche est une touche ALT+...                              */
/****************************************************************************/

boolean IsAltKey(TKey key)
{
  return((boolean)((key.character & (ALT_PRESSED << 8) )!=0));
}

/****************************************************************************/
/* GetNullKey                                                               */
/*--------------------------------------------------------------------------*/
/* Retourne un caractre dit NULL                                           */
/****************************************************************************/

TKey GetNullKey()
{
  TKey key;

  key.character=0;
  key.hot_character=0;

  return(key);
}

/****************************************************************************/
/* IsNullKey                                                                */
/*--------------------------------------------------------------------------*/
/* Indique si un caractre est le caractre dit NULL                        */
/****************************************************************************/

boolean IsNullKey(TKey key)
{
  if (   (key.character==0)
      && (key.hot_character==0))
    return(TRUE);
  return(FALSE);
}

/****************************************************************************/
/* WaitKeyRelease                                                           */
/*--------------------------------------------------------------------------*/
/* Attend le relchement de la touche actuellement presse                  */
/****************************************************************************/

void WaitKeyRelease()
{
  while (!(inportb(0x60) & 0x80))
    ResetKeyboard();
}

/****************************************************************************/
/* WaitLeftClickOrKeyPressed                                                */
/*--------------------------------------------------------------------------*/
/* Attend que l'utilisateur clique avec le bouton gauche ou appuie sur une  */
/* touche. Retourne la touche frappe ou le caractre nul sinon.            */
/****************************************************************************/

TKey WaitLeftClickOrKeyPressed()
{
  boolean done=FALSE;

  int x,y,button_state;
  TKey key;

  while (!done)
    {
      GetMouseState(x,y,button_state);
      if (button_state==LEFT_BUTTON_PRESSED)
	{
	  while (button_state==LEFT_BUTTON_PRESSED)
	    GetMouseState(x,y,button_state);
	  key=GetNullKey();
	  done=TRUE;
	}

      if (KeyPressed())
	{
	  GetKey(key);
	  done=TRUE;
	}
    }

  return(key);
}
