/*  EDITL.H    One-line-editor. After exiting keeps its string in
    global[global_num], where global_num is the number of this line
    in container.
*/

#ifndef __EDIT_LINE_H_
#define __EDIT_LINE_H_

#include <alloc.h>
#include <string.h>

#include "formline.h"
#include "output.h"
#include "visible.h"

#define MAX_LEN 80    // maximum visible len, total max is 255

class EditLine : public FormLine, public Visible
    {
    protected:
	char* string;         // string to edit, default ""
	int ins;              // insert flag
	int outkey;           // char to draw
	loc xy;               // left - top
	int len;              // length
	int maxlen;           // maximum length
	int pattern;              // Pattern number, PATTERN.*
    public:
	EditLine(loc pos, int l, int max_len = 0,
	    BORDERS b_type = BUTTON_BORDER, int pat = 0, int insert = 1);

	virtual ~EditLine() { delete string; }
	virtual void repose(rect new_coord);
	virtual void exe(int act = 0);
	virtual void show()   {  FormLine::show(xy, len, string, pattern); }
	virtual rect bound();
	void put_string(char* str);
	char* get_string() { return string; }
	void draw_char(int* cur_pos, int* vis_pos);
	void left(int* cur_pos, int* vis_pos);
	void right(int* cur_pos, int* vis_pos);
	void home(int* cur_pos, int* vis_pos);
	void del(int* cur_pos, int* vis_pos);
	void bksp(int* cur_pos, int *vis_pos);
	void end(int* cur_pos, int* vis_pos);

	void redraw_string(loc pos, int tmp, int start = 0);
	void insert(int* cur_pos);

	void hilite();
	void unhilite();
    };



#endif __EDIT_LINE_H_


