#ifndef __KH_QUERRY_H_
#define __KH_QUERRY_H_

#include "strtable.h"

/*  CHECKERS are markers, which tells to AskManager, how to work with
    data. For example, CHECK marked field exclude duplicated records,
    CHECKPLUS includes them. In ver. 1.0 only ZERO - NOT ZERO difference
    is significant.
*/
enum KH_CHECKERS { QFREE = 0, QCHECK = 1, QCHECKPLUS = 2, QGROUP = 4,
		   QCALC = 8 };


struct KH_QUERRY
    {
    KH_STRTABLE* querry;                   // Text of querries
    int* querryNumbers;                    // Numbers of fields to querry
    KH_STRTABLE* examples;                 // List of EXAMPLES in querry
    int* exampleNumbers;                   // Numbers of examples fields
    int* checkedFields;                    // Fields to show in "ANSWER"

/*
    QUERRY constructor gets the full list of querry strings ("" for field
    with no condition), and integer containing the number of columns
    in the table. The output is the list of non-empty conditions with
    corresponding column numbers, list of EXAMPLES and list of checkers.
*/
    KH_QUERRY(char** q, char** e, char* c, int numOfColumns);
    KH_QUERRY(KH_STRTABLE* q, KH_STRTABLE* e, char* c, int numOfColumns)
	{ KH_QUERRY(q->strings, e->strings, c, numOfColumns); }

    ~KH_QUERRY();
    };

#endif __KH_QUERRY_H_