#ifndef __BASIC_H_
#define __BASIC_H_

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <ctype.h>

#include "slangtab.h"
#include "var_tab.h"

#define NUM_LAB   100     // Number of labels
#define LAB_LEN   10      // Length of label name
#define FOR_NEST  25      // Number of nested FOR cycles
#define SUB_NEST  25      // Number of nested SUBROUTINES calls
#define PROG_SIZE 10000   // Maximum program size (or use multifile projects)
#define LINE_LEN 160      // Program line len (LINE - CR - LINE ...)

struct for_stack
    {
    char name[10];  // Counter - cycle variable name
    double endval;  // Cycle end value
    char* entrance; // Point in the program string
    };

struct play_stack
    {
    char* prog;                            // Name of file
    int shift;                             // Offset in this file
    play_stack(char* s, int i)
        { prog = strdup(s); shift = i; }
    ~play_stack() { delete prog; }
    };

struct label               // Label : LABEL NAME and pointer to the place
    {                      // in the program
    char name[LAB_LEN];
    char* p;
    };

class Slang                     // The base interpreter class
    {
    public:
	int error;                         // Number of the error
	char* program;          // SLANG program (contents of current file)
	char* substack[SUB_NEST];          // Subroutines stack
	play_stack* playstack[SUB_NEST];   // External files player
	for_stack fstack[FOR_NEST];        // FOR stack

    int variable_type;  // Type of current variable
    char   token_type;  // Type of token obtained
    char tok;           // Group of token obtained
    char token[LINE_LEN]; // Token obtained
    char* theName;
    int for_used;       // FOR stack top
    int sub_used;       // Gosub stack top
    int play_used;      // Play stack top

    char* prog;         // Program - from the current point to the end

    label* labels;      // Table of labels in current file

    VarTable* variables; // Table of variables

    public:
	Slang();
	~Slang();

	void del();
	void set_error(int err) { error = err; }
	int get_argument(double* x);
	int get_error() { return error; }
	void set_program(char* p) { program = p; }
	char* get_program() { return program; }
	char* load_program(char*); // Remove old program and load new file
	char* find_label(char*);   // Find label name in the table
	char* sub_pop();           // Get subroutine parameters from stack
	void sub_push(char*);      // Push Gosub parameters to stack
	for_stack for_pop();       // Get FOR parameters from stack
	void for_push(for_stack);  // Push FOR parameters to stack
	void playpush(char*, int); // Push external file parameters to stack
	play_stack* playpop();     // Get external file parameters from stack
	void print();              // General output function
	void input();              // General input function
	void scan_labels();        // Scan file and fill labels
	void find_eol();           // Scip line
	void find_return();        // Search for RETURN (\r\n)
	void slang_goto();         // GOTO operator
	void slang_if();           // IF operator
	void slang_for();          // FOR operator
	void next();               // NEXT operator
	void gosub();              // Pass control to the subroutine
	void sub_return();         // Return from subroutine
	void label_init();         // Init labels
	int get_next_label(char*); // Get next label
	int reassign_arguments();  // We use assign_ and reassign_arguments
	int assign_arguments();    // with subroutines calls to pass args.
	void release_var(char* );  // Remove variable from table
	void assigment();          // Assign value to variable
	void basic(char*);         // Executes program pointed by char*
	void play();               // Play external file
	virtual void interprete(); // basic() call it in cycle
	void get_label();

	void math(double* result);  // sin, cos...
	void pause();               // See "C" delay() function

	char* get_exp(double*), *level2(double*); // Recursive analyser
	char* level3(double*), *level4(double*);  // User could modify
	char* level5(double*), *level6(double*);  // the "primitive" function
	char* level7(double*);                    // and add COMMAND group
	char* primitive(double*);                 // user-defined functions
	void arith(char, double*, double*);
	void unary(char, double*);

	virtual void serror(int);  // Error processor
	virtual void error_report(char* text); // Overload for your own print

	void putback();            // Put token back
	int get_token();           // Get token from prog
	int iswhite(char);         // Recognize symbols to skip
	int isdelim(char);         // Recognize delimiters (),:;" and so on

	virtual void terminate();  // User-defined terminator (ESC and so on)
	};

#endif __BASIC_H_





