/*
 * Librarian definitions
 */
#define MAX(x,y) (x > y ? x : y)

/* Rotations */
#define ROTR(x,bits) (((x << (16 - bits)) | (x >> bits)) & 0xffff)
#define ROTL(x,bits) (((x << bits) | (x >> (16 - bits))) & 0xffff)

/* Library page size and buckets per page */
#define LIB_BUCKETS 37
#define LIB_PAGESIZE 512

/* OMF hash structure */
typedef struct _hash_ {
  uint block_x, block_d, bucket_x, bucket_d;
} hash;

/* A Dictionary page looks like this */
typedef union _dictpage_ {
  BYTE bytes[LIB_PAGESIZE];		/* Either 512 bytes */
  struct {
	  BYTE htab[LIB_BUCKETS];		/* Or the 37 buckets */
    BYTE fflag;					/* followed by the next free position */
    BYTE names[LIB_PAGESIZE-LIB_BUCKETS-1];	/* followed by names section */
  } f;
} DICTPAGE;
/* No structure is defined for a dictionary name, (it would have to be variable length)
 *	the borland structure is:
 *   1 byte count
 *   (count) bytes ascii name
 *   2 byte paragraph number of module (limits dictionary to 1MB)
 *   2 bytes unknown
 *   1 byte seems to be a bucket pointer
 */

/* The structure defining a dictionary module which must be loaded in pass 2 */
typedef struct _modlist_ {
  char *lib;		/* Library name */
  char *module;	/* Module name as defined in THEADR record */
  long paragraph;	/* Base paragraph to load from */
  uint pagesize;
} MODLIST;
#include "libs.p"