/*
 * Assembler core
 *
 * Copyright (c) 1996 LADSOFT
 *
 * David Lindauer, camille@bluegrass.net
 *
 * Core for a retargetable assembler
 *
 * This program may be freely used and redistributed, as long as the 
 * copyright notice remains intact.  The author holds no liabilty;
 * all risks, both direct and consequential, are the responsibilty of
 * the user.  You use this program at your own risk!
 *
 */
/*
 * extern.c
 *
 * handle externals and fixups
 */
#include <stdio.h>
#include <string.h>
#include "utype.h"
#include "umem.h"
#include "asm.h"
#include "extern.h"
#include "input.h"
#include "linker.h"
#include "sections.h"
#include "gencode.h"

extern BOOL sizeoneisbad;
extern int basetype;
extern HASHREC **hashtable;
extern int pass;
extern BOOL ifskip;
extern int sectionnum;
extern int opcodesize;
extern long org;
extern SECTIONREC *cursection;

BOOL ToFixup = TRUE;
char fixlistvals[4];
int fixlistnum = 0;

static unsigned pubid, extid;

void extinit(void)
{
	pubid = 1;
	extid = 1;
	fixlistnum = 0;
}
/*
 * Add a new public to the hash table
 */
void AddPublic(EXPRESSION *data)
{
	if (!ifskip)
	  if (!data->name) {
			Error("Illegal public name");
		}
		else {
			if (pass == 1) {
				EXPRESSION *q;
				data->isdef = FALSE;
				data->isintermed = FALSE;
				data->size = 0;
				data->ispublic = TRUE;
				data->id = pubid++;
				data->defpass = pass;
				data->section = 0;
				if (q = AddHash(hashtable, data)) {
					if (!q->ispublic)
						q->id = data->id;
					q->ispublic = TRUE;
					q->isextern = FALSE;
					q->type = data->type;
					data->isintermed = TRUE;
					delexpr(data,0);
				}
			}
			else
				if (pass == 2) {
					EXPRESSION **q = LookupHash(hashtable, data->name);
					if (!q || !(*q)->isdef) {
						char buf[BUFLEN];
						sprintf(buf,"Undefined public %s", data->name);
						Error(buf);
					}
				}
		}
}

/* Add a new external to the hash table */
void AddExtern(EXPRESSION *data, unsigned size)
{
	if (!ifskip)
	  if (!data->name) {
			Error("Illegal extern name");
		}
		else {
			if (pass == 1) {
				EXPRESSION *q;
				data->islabel = TRUE;
				data->isintermed = FALSE;
				data->isextern = TRUE;
				data->isdef = FALSE;
				if (!data->size)
					data->size = size;
				data->section = 0;
				data->id = extid++;
				data->defpass = pass;
				if (AddHash(hashtable, data)) {
					q->type = data->type;
					q->isextern = TRUE;
					data->isintermed = TRUE;
					delexpr(data,0);
					Error("Redefined extern");
				}
			}
		}
}
/* create a fixup table entry
 */
static void dofixup(EXPRESSION *data, long size, BOOL rel)
{
			LIST *flist;
			FIXUP *fix = AllocateMemory(sizeof(FIXUP));
			if (size == TBYTE && sizeoneisbad)
				Error("Byte sized fixups not allowed");
			if (!ToFixup) {
				ToFixup = TRUE;
				return;
			}
			fix->address = org + opcodesize;
			fix->rel = rel;
			fix->size = size;
			fix->relpc = data->relpc;
			fix->id = data->id;
			fix->section = data->section;
			fix->link = 0;
			if (fix->section == 0)
				fix->section = sectionnum;
			if (!size)
				Error("Internal Error 1");
			if (data->relmode) {
				FIXUP *fix2 = AllocateMemory(sizeof(FIXUP));
				EXPRESSION *rdata = data->ext;
				if (data->isextern) {
					fix->type = FIXEXTERN;
					fixlistvals[fixlistnum++] = 'x';
				}
				else {
					if (data->rel) {
						fix->type = FIXPC;
						fix->reladdress = -data->x.value + opcodesize + org;
						fixlistvals[fixlistnum++] = 'p';
					}
					else {
						EXPRESSION **q = LookupHash(hashtable, data->name);
						if (q) {
							if ((*q)->islabel && (*q)->section) {
								fix->type = FIXRELSECT;
								fix->reladdress = (*q)->x.value;
								fixlistvals[fixlistnum++] = 'r';
							}
							else {
								fix->type = FIXVALUE;
								fix->reladdress = (*q)->x.value;
							}
						}
						else {
							fix->type = FIXVALUE;
							fix->reladdress = data->x.value;
						}
					}
				}
				if (data->relmode == RM_MEXT || data->relmode == RM_MPUB)
					fix->type |= FIXMINUS;
				else
					fix->type |= FIXPLUS;
				fix2->address = org + opcodesize;
				fix2->rel = FALSE;
				fix2->size = size;
				fix2->relpc = FALSE;
				fix2->id = rdata->id;
				fix2->section = rdata->section;
				fix2->link = 0;
				if (fix2->section == 0)
					fix2->section = sectionnum;
				fix2->type = FIXEXTERN;
				if (rdata->isextern) {
					fix2->type = FIXEXTERN;
					fixlistvals[fixlistnum++] = 'x';
				}
				else {
					if (rdata->rel) {
						fix2->reladdress = - rdata->x.value + opcodesize + org;
						fix2->type = FIXPC;
						fixlistvals[fixlistnum++] = 'p';
					}
					else {
						EXPRESSION **q = LookupHash(hashtable, rdata->name);
						if (q) {
							if ((*q)->islabel && (*q)->section) {
								fix2->type = FIXRELSECT;
								fix2->reladdress = (*q)->x.value;
								fixlistvals[fixlistnum++] = 'r';
							}
							else {
								fix2->type = FIXVALUE;
								fix2->reladdress = (*q)->x.value;
							}
						}
						else {
							fix2->type = FIXVALUE;
							fix2->reladdress = rdata->x.value;	
						}
					}
				}
				fix->link = fix2;
			}
			else {
				if (data->isextern) {
					fix->type = FIXEXTERN;
					fixlistvals[fixlistnum++] = 'x';
				}
				else {
					if (data->rel) {
						fix->type = FIXPC;
						fix->reladdress = - data->x.value + opcodesize + org;
						fixlistvals[fixlistnum++] = 'p';
					}
					else {
						EXPRESSION **q = LookupHash(hashtable, data->name);
						if (q) {
							if ((*q)->islabel && (*q)->section) {
								fix->type = FIXRELSECT;
								fix->reladdress = (*q)->x.value;
								fixlistvals[fixlistnum++] = 'r';
							}
							else {
								fix->type = FIXVALUE;
								fix->reladdress = (*q)->x.value;
							}
						}
						else
							fix->type = FIXNONE;
					}
				}
			}
			flist = AllocateMemory(sizeof(LIST));
			(*(cursection->fixuppos)) = flist;
			flist->link = 0;
			flist->data = fix;
			cursection->fixuppos = &flist->link;
}
void lnfixup(long addr, long fixaddr, short sectionnum)
{
			LIST *flist;
			FIXUP *fix = AllocateMemory(sizeof(FIXUP));
			fix->address = fixaddr;
			fix->rel = FALSE;
			fix->size = TLONG;
			fix->relpc = FALSE;
			fix->id = 0;
			fix->section = sectionnum;
			fix->link = 0;
			fix->type = FIXRELSECT;
			fix->reladdress = addr;
			flist = AllocateMemory(sizeof(LIST));
			(*(cursection->fixuppos)) = flist;
			flist->link = 0;
			flist->data = fix;
			cursection->fixuppos = &flist->link;
}
/* global routines to register fixups as needed 
 */
void registersamefixup(EXPRESSION*data, long size)
{
  if (cursection && !data->isextern && data->name && !data->relmode && (data->section == sectionnum))
		dofixup(data,size,FALSE);
}
void registerfixup(EXPRESSION*data, long size, BOOL rel)
{
	if (cursection && ((data->isextern &&data->name)|| (data->relmode && data->ext->name) || (data->section&&data->islabel))) {
		if ((data->section != sectionnum) || data->isextern ||data->relmode) {
			dofixup(data,size,rel);
		}
	}
}