/*
 * ------------------------------------------------------------------
 * Home Libarian 1.1 by Deepwoods Software
 * ------------------------------------------------------------------
 * TkCardRecord.h - Tcl/Tk interface for the CardRecord class (defs)
 * Created by Robert Heller on Mon Apr 17 14:01:39 1995
 * ------------------------------------------------------------------
 * Modification History: 
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Home Librarian Database -- a program for maintaining a database
 *                                for a home library
 *     Copyright (C) 1991-1995  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */
#ifndef _TKCARDRECORD_H_
#define _TKCARDRECORD_H_

#include <String.h>

#include <tcl.h>
#include <tclExtend.h>

#include <iostream.h>
#include <strstream.h>
#include <CardRecord.h>
#include <vBTree.h>
#include <ctype.h>

class TkCardRecord {
private:
	String Author,Title,Publisher,City,Description;
public:
	CardRecord *CardRec;
	TkCardRecord(Record* record) {CardRec = new CardRecord(record);}
	TkCardRecord(CoreItem* coreitem) {CardRec = new CardRecord(coreitem);}
	TkCardRecord(Card* card) {CardRec = new CardRecord(card);}
	TkCardRecord(CardRecord& cardrecord) {CardRec = new CardRecord(cardrecord);}
	~TkCardRecord() {if (CardRec != NULL) delete CardRec;}
	int TclFunction(Tcl_Interp *interp,int argc, char *argv[]);
	static void_pt Handles;
};

int createTkCardRecord(Tcl_Interp *interp,Record* record);
int createTkCardRecord(Tcl_Interp *interp,CoreItem* coreitem);
int createTkCardRecord(Tcl_Interp *interp,Card* card);
int createTkCardRecord(Tcl_Interp *interp,CardRecord& cardrecord);
TkCardRecord* FindCardByHandle(Tcl_Interp *interp,char* handle);

#endif // _TKCARDRECORD_H_

