/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
   list_fun.c: compile list of references, standard format
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <signal.h>
#include <malloc.h>
#include <dos.h>
#include "refs.h"
#include "keycodes.h"
#include "ix01_fun.h"
#include "ix02_fun.h"
#include "fl_ut.h"
#include "str_fun.h"
#include "l_menu.h"
#include "str_refs.h"
#include "abbruch.h"
#include "cfg_fun.h"

#define REFZAHL_LEN 7
#define TEXTZEILEN_LEN 65
#define TXTBUF_SIZE 15000
#define BBTBUF_SIZE 4000

 extern char journal_pix_name[PFAD_LEN];
 extern char journal_name[PFAD_LEN];
 extern char book_name[PFAD_LEN];
 extern char autorjl_name[PFAD_LEN];
 extern char autorbu_name[PFAD_LEN];
 extern char quell_pix_name[PFAD_LEN];
 extern char quell_name[PFAD_LEN];
 static char txt_name[PFAD_LEN];
 static char log_name[PFAD_LEN];
 static char bbt_name[PFAD_LEN];
 static char haupt_schluessel[KENNZIFFER_LEN + 1];
 static char quell_schluessel[QUELLKUERZEL_LEN + 1];
 static char txt_buf[TXTBUF_SIZE];
 static char bbt_buf[BBTBUF_SIZE];
 static unsigned int delaywrite;

 extern char fehlermeldung[250];
 extern char wrtxtbu[WRTXTBU_LEN];


 extern FILE * ix01file;
 extern FILE * ix02file;
 extern FILE * fpjournal;
 extern FILE * fpbuch;
 extern FILE * fpautorjl;
 extern FILE * fpautorbu;
 extern FILE * fpsource;
  static FILE * fpbbt;
  static FILE * fptxt;
  static FILE * fplog;


  static char * au_zeile;
  static char * ed_zeile;
  static char * ex_au_zeile;
  static char * ausgabe_zeile;

 extern config_set one_config_set;


 extern journal_rec            one_journal_rec;
 extern buch_rec               one_buch_rec;
 extern quell_rec              one_quell_rec;
 extern refspix_rec            ix01rec;
 extern quellpix_rec           ix02rec;
 extern author_rec             one_aued_rec;
 static bbatchtable_rec        one_bbt_rec;

 int list_fun_main(char * datpath);
 static int getfilenames(void);
 static int dateien_oeffnen_list_fun(void);
 static void dateien_schliessen_list_fun(void);
 static void machlist_list_fun(void);
 static void compile_j1(void);
 static void compile_b1(void);
 static void compile_b2(void);
 static void compile_aued(FILE * fpaued, char * auedstring, long zeiger);



int list_fun_main(char * datpath)
{
     delaywrite=one_config_set.delay_list_write;

     if (!getfilenames())
     {
        return 1;
     }
     if ((au_zeile =  (char *) malloc((AUTORZEILE_LEN+1) * sizeof(char)))==NULL)
     {
        sprintf(fehlermeldung,"'List' 'StandardFormat' memory allocation error 001");
        beenden(fehlermeldung,2);
     }
     if ((ed_zeile =  (char *) malloc((AUTORZEILE_LEN+1) * sizeof(char)))==NULL)
     {
        sprintf(fehlermeldung,"'List' 'StandardFormat' memory allocation error 002");
        beenden(fehlermeldung,2);
     }
     if ((ex_au_zeile =  (char *) malloc((AUTORZEILE_LEN+1) * sizeof(char)))==NULL)
     {
        sprintf(fehlermeldung,"'List' 'StandardFormat' memory allocation error 003");
        beenden(fehlermeldung,2);
     }
     if ((ausgabe_zeile =  (char *) malloc((AUSGABEZEILE_LEN+1) * sizeof(char)))==NULL)
     {
        sprintf(fehlermeldung,"'List' 'StandardFormat' memory allocation error 004");
        beenden(fehlermeldung,2);
     }
     if (dateien_oeffnen_list_fun())
     {
       machlist_list_fun();
       dateien_schliessen_list_fun();
     } else
     {
         tastelesen();
     }

     free(au_zeile);
     free(ed_zeile);
     free(ex_au_zeile);
     free(ausgabe_zeile);


     return 0;
}


static int getfilenames(void)
{
  int taste;
  static char eingabe[DOSDATEIVORNAME_LEN +1];
  static int dateipos;
  do
  {
    if (strlen(eingabe)==0) strcpy(eingabe,"REFLIST");
    cls_line("REFERENCES VERSION 3.6 * LIST - STANDARD FORMAT");
    info_zeile("Edit filename for textfile, extension '.TXT' will be appended by the program");
    strcpy(wrtxtbu,"File name......");
    wrtxt(wrtxtbu);
    taste = e_zle(
                  1+strlen(wrtxtbu),
                  one_config_set.sl-1,
                  eingabe,
                  DOSDATEIVORNAME_LEN,DOSDATEIVORNAME_LEN,0
                     );
    sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
    if (taste==ESC_KEY)
    {
        cls_line("");
        return 0;
    }
    if (!isdosfilename(eingabe)) continue;
    if (taste==ENTER_KEY && strlen(eingabe) > 0) break;
  } while (1);
  upper(eingabe);
  strcpy(txt_name,eingabe);
  strcat(txt_name,".TXT");
  strcpy(log_name,eingabe);
  strcat(log_name,".LOG");
  if (isfile(txt_name))
  {
     taste = lotus_menu("Cancel$File with the name already exists, do not overwrite"
                "@Overwrite$The contents of the existing file will be lost");
     if (taste<=1) return 0;
  }
  cls_line("");
  taste = datei_suchen_default("*.BBT",bbt_name,&dateipos);
  if (taste) return 1;
  else
  {
     wrtxt("\n[Please press any key]>");
     tastelesen();
     return 0;
  }
}


static int dateien_oeffnen_list_fun(void)
{
  if (filesize(journal_pix_name)==0)
  {
    wrtxt("ERROR: main index file is empty\n");
    return 0;
  }
  if (!read_ix01(journal_pix_name)) return 0;
  if (!read_ix02(quell_pix_name)) return 0;
  if ((fpjournal=fopen(journal_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",journal_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    return 0;
  }

  if ((fpbuch=fopen(book_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",book_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    return 0;
  }
  if ((fpautorjl=fopen(autorjl_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",autorjl_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpbuch);
    return 0;
  }
  if ((fpautorbu=fopen(autorbu_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",autorbu_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    return 0;
  }

  if ((fpbbt=fopen(bbt_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",bbt_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    return 0;
  }
  if (setvbuf(fpbbt,bbt_buf,_IOFBF,BBTBUF_SIZE)!=0)
  {
    wrtxt("ERROR: Cannot allocate memory for fpbbt\n");
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpbbt);
    return 0;
  }

  if ((fpsource=fopen(quell_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",quell_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpbbt);
    return 0;
  }

  if ((fptxt=fopen(txt_name,"w"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: write read %s\n",txt_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpbbt);
    fclose(fpsource);
    return 0;
  }
  if (setvbuf(fptxt,txt_buf,_IOFBF,TXTBUF_SIZE)!=0)
  {
    wrtxt("ERROR: Cannot allocate memory for fptxt\n");
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpbbt);
    fclose(fpsource);
    fclose(fptxt);
    return 0;
  }
  if ((fplog=fopen(log_name,"w"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: write read %s\n",log_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpbbt);
    fclose(fpsource);
    fclose(fptxt);
    return 0;
  }

  return 1;
}

static void dateien_schliessen_list_fun(void)
{
   close_ix01();
   close_ix02();
   fclose(fpjournal);
   fclose(fpbuch);
   fclose(fpautorjl);
   fclose(fpautorbu);
   fclose(fpbbt);
   fclose(fpsource);
   fclose(fptxt);
   fclose(fplog);
}


static void machlist_list_fun(void)
{
   long i, j, byte_zeiger, rec_zeiger, anzahl_records;
   static int menupos, taste, ok;
   int schleifeok;
   /* long verzoegerung; */
   char zahl[REFZAHL_LEN+1];
   fseek(fpbbt,0L,SEEK_END);
   byte_zeiger = ftell(fpbbt);
   anzahl_records = byte_zeiger/sizeof(one_bbt_rec);
   anzahl_records--;
   wrtxt("\n");

   strcpy(zahl,"1");
   if (anzahl_records==-1)
   {
      wrtxt("[Current BBT-file is empty, please press any key]>");
      tastelesen();
      return;
   }


   taste=lotus_menu_default(
      &menupos,
     "@1:[]$Leading number: [1] REFERENCE..."
     "@2:[]<>$Leading number and reference number [1] <REFNO> REFERENCE..."
     "@3:<>$Leading reference number <REFNO> REFEREENCE..."
     "@4:VOID$No leading numbers"
     "@5:REFNO*00000N$Format for translation back into a *.BBT file, word-wrap 65 characters"
     "@6:REFNO*BBT-TEXT$Format for translation back into a BBT file, word-wrap, Text"
                          );
   if (taste==0)
   {
      return;
   }
   if (taste==1 || taste==2 || taste==5)
   {
    schleifeok = 0;
    do
    {
      int wahl;
      sc_gotoxy(1,one_config_set.sl-1);
      info_zeile("Enter number assigned to the first reference");
      strcpy(wrtxtbu,"[n].......");
      wrtxt(wrtxtbu);
      wahl = e_zle(
                  1+strlen(wrtxtbu),
                  one_config_set.sl-1,
                  zahl,
                  REFZAHL_LEN,
                  REFZAHL_LEN,
                  0);
      string_in_long(zahl,&j,&ok);
      if ((ok) && wahl==ENTER_KEY) schleifeok=1; else schleifeok=0;
      sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      sc_gotoxy(1,one_config_set.sl);sc_clreol();
      sc_gotoxy(1,one_config_set.sl-1);

     }
     while (!schleifeok);
   }
  schleifeok = 0;
  strcpy(zahl,"0");
  
  /*
  do
  {
    int wahl;
    sc_gotoxy(1,one_config_set.sl-1);
    info_zeile("Enter delay time between processing of references in milliseconds");
    strcpy(wrtxtbu,"[msec]....");
    wrtxt(wrtxtbu);
    wahl = e_zle(
                    1+strlen(wrtxtbu),
                    one_config_set.sl-1,
                    zahl,
                    REFZAHL_LEN,
                    REFZAHL_LEN,
                    0);
    string_in_long(zahl,&verzoegerung,&ok);
    if ((ok) && wahl==ENTER_KEY && verzoegerung >=0 && verzoegerung <= 5000) schleifeok=1; else schleifeok=0;
    sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
    sc_gotoxy(1,one_config_set.sl);sc_clreol();
    sc_gotoxy(1,one_config_set.sl-1);

   }
   while (!schleifeok);
   */
   sprintf(wrtxtbu,"Compiling %li references, please wait...\n",anzahl_records+1);
   wrtxt(wrtxtbu);
   rewind(fpbbt);
   for (i=0;i<=anzahl_records;i++)
   {
/*
#if defined(__EMX__)
        if (verzoegerung > 0) _sleep2((unsigned) verzoegerung);
#endif
#if defined(__DJGPP__)
        if (verzoegerung > 0) delay((unsigned) verzoegerung);
#endif
*/
        if (abbrechen()) return;
        sc_gotoxy(1,one_config_set.sl);
        sprintf(wrtxtbu,"%.1f%% completed", (double) 100.0*(i+1)/(anzahl_records+1));
        wrtxt(wrtxtbu);
        sc_clreol();sc_gotoxy(1,one_config_set.sl);
        fread(&one_bbt_rec, sizeof(one_bbt_rec),1,fpbbt);
        strlimcpy(haupt_schluessel,one_bbt_rec.kennziffer,KENNZIFFER_LEN);
        if (locate_ix01(haupt_schluessel,&ix01rec) > -1)
        {
           rec_zeiger = ix01rec.journal_rptr;
           byte_zeiger = rec_zeiger * sizeof(one_journal_rec);
           fseek(fpjournal,byte_zeiger,SEEK_SET);
           fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);

           if (taste==1) sprintf(ausgabe_zeile,"[%li] ",j);
           else if (taste==2) sprintf(ausgabe_zeile,"[%li] <%s> ",j,haupt_schluessel);
           else if (taste==3) sprintf(ausgabe_zeile,"<%s> ",haupt_schluessel);
           else if (taste==4) strcpy(ausgabe_zeile,"");
           else if (taste==5) sprintf(ausgabe_zeile,"*%s*%06li* ",haupt_schluessel,j);
           else sprintf(ausgabe_zeile,"*%s* %s * ",haupt_schluessel,one_bbt_rec.sortierfeld);

           if (!strcmp(one_journal_rec.reftyp,"j1")) compile_j1();
           else if (!strcmp(one_journal_rec.reftyp,"b1")) compile_b1();
           else compile_b2();
           if (taste==5 || taste==6)
           {
               wwrap(ausgabe_zeile,TEXTZEILEN_LEN);
               if (ausgabe_zeile[strlen(ausgabe_zeile)-1]=='\n')
                  ausgabe_zeile[strlen(ausgabe_zeile)-1]='\0';
               fprintf(fptxt,"%s\n\n",ausgabe_zeile);
           }
           else
               fprintf(fptxt,"%s\n\n",ausgabe_zeile);
           if (delaywrite > 0)
           {
#if defined(__EMX__)
              if (((i+1) % 200)==0) { _sleep2 (delaywrite); }
#endif
#if defined(__DJGPP__)
              if (((i+1) % 200)==0) {  delay(delaywrite); }
#endif
           }

        }
        else
          fprintf(fplog,"# %s: Reference not found\n",haupt_schluessel);
        j++;
   }
   sc_gotoxy(1,one_config_set.sl);sc_clreol();
   sprintf(wrtxtbu,"\n[Done: textfile %s closed, please press any key]>",txt_name);
   wrtxt(wrtxtbu);
   tastelesen();
}

static void compile_j1(void)
{
   compile_aued(fpautorjl, au_zeile,ix01rec.autorjl_rptr);
   strlimcat(ausgabe_zeile,au_zeile,AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,". ",AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,one_journal_rec.titel,AUSGABEZEILE_LEN);
   if (!satzzeichen(ausgabe_zeile))
      strlimcat(ausgabe_zeile,". ",AUSGABEZEILE_LEN);
   else
      strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);

   strncpy(quell_schluessel,one_journal_rec.kuerzel,KUERZEL_LEN);
   if (locate_ix02(quell_schluessel,&ix02rec) > -1)
   {
       long byte_zeiger;
       byte_zeiger = ix02rec.quell_rptr * sizeof(one_quell_rec);
       fseek(fpsource,byte_zeiger,SEEK_SET);
       fread(&one_quell_rec,sizeof(one_quell_rec),1,fpsource);
       strlimcat(ausgabe_zeile,one_quell_rec.quell_zeitschrift,AUSGABEZEILE_LEN);
       strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
   }
   else
   {
      strlimcat(ausgabe_zeile,"[",AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,quell_schluessel,AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,"] ",AUSGABEZEILE_LEN);
      fprintf(fplog,"# %s: JOURNAL name corresponding to [%s] not found\n",haupt_schluessel,quell_schluessel);
   }

   strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,"; ",AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,": ",AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,one_journal_rec.seite_von,AUSGABEZEILE_LEN);
   if (strcmp(one_journal_rec.seite_von,one_journal_rec.seite_bis)!=0 &&
       strlen(one_journal_rec.seite_bis)>0)
   {
       strlimcat(ausgabe_zeile,"-",AUSGABEZEILE_LEN);
       strlimcat(ausgabe_zeile,one_journal_rec.seite_bis,AUSGABEZEILE_LEN);
   }
   strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
}


static void compile_b1(void)
{
   long byte_zeiger;
   compile_aued(fpautorbu, ed_zeile,ix01rec.autorbu_rptr);
   strlimcat(ausgabe_zeile,ed_zeile,AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,". ",AUSGABEZEILE_LEN);
   byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
   fseek(fpbuch,byte_zeiger,SEEK_SET);
   fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);


   strlimcat(ausgabe_zeile,one_buch_rec.titel_bu,AUSGABEZEILE_LEN);
   if (!satzzeichen(ausgabe_zeile))
      strlimcat(ausgabe_zeile,". ",AUSGABEZEILE_LEN);
   else
     strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
   if (strlen(one_journal_rec.band) >0)
   {
      strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,". ed. ",AUSGABEZEILE_LEN);
   }
    strlimcat(ausgabe_zeile,one_buch_rec.publ_ort,AUSGABEZEILE_LEN);
    strlimcat(ausgabe_zeile,": ",AUSGABEZEILE_LEN);
    strlimcat(ausgabe_zeile,one_buch_rec.verlag,AUSGABEZEILE_LEN);
    strlimcat(ausgabe_zeile,", ",AUSGABEZEILE_LEN);
    strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);

    if (strlen(one_journal_rec.seite_von)>0)
    {
       strlimcat(ausgabe_zeile,": ",AUSGABEZEILE_LEN);
       strlimcat(ausgabe_zeile,one_journal_rec.seite_von,AUSGABEZEILE_LEN);
       if (strcmp(one_journal_rec.seite_von,one_journal_rec.seite_bis)!=0 &&
           strlen(one_journal_rec.seite_bis)>0)
       {
           strlimcat(ausgabe_zeile,"-",AUSGABEZEILE_LEN);
           strlimcat(ausgabe_zeile,one_journal_rec.seite_bis,AUSGABEZEILE_LEN);
       }
       strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
    }
    else strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
}



static void compile_b2(void)
{
   long byte_zeiger;
   compile_aued(fpautorbu, ed_zeile,ix01rec.autorbu_rptr);
   compile_aued(fpautorjl, au_zeile,ix01rec.autorjl_rptr);

   strlimcat(ausgabe_zeile,au_zeile,AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,". ",AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,one_journal_rec.titel,AUSGABEZEILE_LEN);
   if (!satzzeichen(ausgabe_zeile))
     strlimcat(ausgabe_zeile,". In: ",AUSGABEZEILE_LEN);
   else
     strlimcat(ausgabe_zeile," In: ",AUSGABEZEILE_LEN);

   strlimcat(ausgabe_zeile,ed_zeile,AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,", ",AUSGABEZEILE_LEN);
   strlimcat(ausgabe_zeile,"editors. ",AUSGABEZEILE_LEN);

   byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
   fseek(fpbuch,byte_zeiger,SEEK_SET);
   fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);
   strlimcat(ausgabe_zeile,one_buch_rec.titel_bu,AUSGABEZEILE_LEN);
   if (!satzzeichen(ausgabe_zeile))
      strlimcat(ausgabe_zeile,". ",AUSGABEZEILE_LEN);
   else
      strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);

   if (strlen(one_journal_rec.band) >0)
   {
      strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
      strlimcat(ausgabe_zeile,". ed. ",AUSGABEZEILE_LEN);
   }
    strlimcat(ausgabe_zeile,one_buch_rec.publ_ort,AUSGABEZEILE_LEN);
    strlimcat(ausgabe_zeile,": ",AUSGABEZEILE_LEN);
    strlimcat(ausgabe_zeile,one_buch_rec.verlag,AUSGABEZEILE_LEN);
    strlimcat(ausgabe_zeile,", ",AUSGABEZEILE_LEN);
    strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
    strlimcat(ausgabe_zeile,": ",AUSGABEZEILE_LEN);
    strlimcat(ausgabe_zeile,one_journal_rec.seite_von,AUSGABEZEILE_LEN);
    if (strcmp(one_journal_rec.seite_von,one_journal_rec.seite_bis)!=0 &&
        strlen(one_journal_rec.seite_bis)>0)
    {
        strlimcat(ausgabe_zeile,"-",AUSGABEZEILE_LEN);
        strlimcat(ausgabe_zeile,one_journal_rec.seite_bis,AUSGABEZEILE_LEN);
    }
    strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
}



static void compile_aued(FILE * fpaued, char * auedstring, long zeiger)
{
   int anzahl_n, i;
   long byte_zeiger;
   strcpy(auedstring,"");
   byte_zeiger = zeiger * sizeof(one_aued_rec);
   fseek(fpaued,byte_zeiger,SEEK_SET);
   fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);
   fseek(fpaued,byte_zeiger,SEEK_SET);
   anzahl_n = one_aued_rec.au_n;
   for (i=1;i<=anzahl_n;i++)
   {
        fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);
        strlimcat(auedstring,one_aued_rec.au_nachname,AUTORZEILE_LEN);
        strlimcat(auedstring," ",AUTORZEILE_LEN);
        strlimcat(auedstring,one_aued_rec.au_vornamen,AUTORZEILE_LEN);
        if  (i<anzahl_n) strlimcat(auedstring,", ",AUTORZEILE_LEN);
   }
}


#undef REFZAHL_LEN
