/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/
/*
   xtrrm.c: extract reference numbers from manuscript
            (in form of a text file)
*/

#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <signal.h>
#include <stdlib.h>
#include <conio.h>
#include "str_fun.h"
#include "fl_ut.h"
#include "abbruch.h"
#include "refs.h"
#include "l_menu.h"
#include "cfg_fun.h"
#include "str_refs.h"
#include "xtrrm.h"
#include "keycodes.h"

 extern char fehlermeldung[250];
 extern char wrtxtbu[WRTXTBU_LEN];


#define SPATTERN "refscite()"

#define LZEILE_LEN 262144

#define MUSTER_STR_LEN 40
#define MASKEN_LEN 10


 static char * lzeile;
 static char * ex_zeile;
 static char * exex_zeile;
 static char musterstr[MUSTER_STR_LEN + 1];

 extern config_set one_config_set;
 static long anz_refs;
 static bbatchtable_rec one_bbt_rec;


 static char text_name[PFAD_LEN];
 static FILE * fptext;
 static char bbt_name[PFAD_LEN];
 static FILE * fpbbt;

 static int mustertyp;
  /* 1 normal, 2 curly braces */

 int xtrrm_main(char * datenpfad);
 static int zeile_parsen(char * muster, char * zle);
 static int hauptmenu_xtrrm(void);
 static int text_lesen(void);
 static int issearchpattern(char * muster);


int xtrrm_main(char * datenpfad)
{
     mustertyp = 1;

     if ((lzeile =  (char *) malloc((LZEILE_LEN + 1) * sizeof(char)))==NULL)
     {
         sprintf(fehlermeldung,"ERROR: Cannot allocate memory for input line");
         beenden(fehlermeldung,2);
     }
     if ((ex_zeile =  (char *) malloc((LZEILE_LEN +1) * sizeof(char)))==NULL)
     {
         sprintf(fehlermeldung,"ERROR: Cannot allocate memory for text buffer_1");
         beenden(fehlermeldung,2);
     }
     if ((exex_zeile =  (char *) malloc((LZEILE_LEN + 1) * sizeof(char)))==NULL)
     {
         sprintf(fehlermeldung,"ERROR: Cannot allocate memory for text buffer_1");
         beenden(fehlermeldung,2);
     }
     cls_line(XTRRMTITEL);

     hauptmenu_xtrrm();
     free(lzeile);
     free(ex_zeile);
     free(exex_zeile);
     wrtxt(" Ok...");
     return 0;
}


static int zeile_parsen(char * muster, char * zle)
{
    int i;
    int fund;
    int f_ende;

    char ex_musterstr[MUSTER_STR_LEN + 1];
    strcpy(ex_musterstr,muster);
    ex_musterstr[strlen(muster) - 1] = '\0';

    fund = -1; i = 0;
    do
    {
       fund = locate_substring(ex_musterstr,zle+i);
       if (fund > -1 )
       {
           f_ende = -1;
           if (mustertyp==1)
           {
              f_ende = locate_substring(")",zle+i+fund);
           }
           else // ==2
           {
              f_ende = locate_substring("}",zle+i+fund);
           }
           if (f_ende > -1)
           {
               int ausgeben_ok;
               ausgeben_ok = 1;
               extract_subs(
                    ex_zeile,
                    (zle + i + fund),
                    0,
                    f_ende + 1
                           );

                    if (mustertyp==1)
                    {
                       extractargument(
                           muster,
                           ex_zeile,
                           exex_zeile
                       );
                    }
                    else
                    {
                       extractargument_curly(
                           muster,
                           ex_zeile,
                           exex_zeile
                       );
                    }

                    if (locate_substring(ex_musterstr,exex_zeile) >= 0)
                    {
                        ausgeben_ok = 0;
                        break;
                    }
                    if (strlen(exex_zeile) > KENNZIFFER_LEN)
                    {
                         ausgeben_ok = 0;
                    }
                    if (strlen(exex_zeile) == 0)
                    {
                         ausgeben_ok = 0;
                    }
                    if (ausgeben_ok)
                    {
                       memset(&one_bbt_rec,0,sizeof(one_bbt_rec));
                       strcpy(one_bbt_rec.kennziffer,exex_zeile);
                       fwrite(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt);
                       anz_refs++;
                    }
           }
       }
       else
       {
           break;
       }
       i = i + fund + 1;
    }
    while (1);
    return 0;
}

static int hauptmenu_xtrrm(void)
{
     char eingabe[DOSDATEIVORNAME_LEN+1];
     int taste;
     char maske[MASKEN_LEN];
     strcpy(maske,"*.txt");

     anz_refs = 0;
     strcpy(musterstr,SPATTERN);

     cls_line(XTRRMTITEL);
     sc_gotoxy(1,one_config_set.sl - 11);
     wrtxt(XTRRM_HILFE01);
     sc_gotoxy(1,one_config_set.sl);
     wrtxt("[Please press any key]>");
     tastelesen();

     cls_line(XTRRMTITEL);
     wrtxt("\n[Next menu: filename extension of the text file "
           "to be processed]>");
     tastelesen();
     sc_gotoxy(1,one_config_set.sl);
     sc_clreol();
     cls_line(XTRRMTITEL);

     taste = lotus_menu(
       "@Text$Process (extract reference #) text file with extension TXT (ASCII-file)"
       "@Batch$Process (extract reference #) text batch table with extension TBT (ASCII-file)"
       "@ASCII$Process (extract reference #) text file with extension ASC (ASCII-file)"
       "@Doc$Process (extract reference #) text file with extension DOC (ASCII-file)"
       "@(La)TeX$Process (extract reference #) TeX or LaTeX file with extension TEX (ASCII-file)"
                       );
     if (taste==0)
     {
         wrtxt("\n[Function aborted: please press any key]>");
         tastelesen();
         return 0;
     }
     if (taste==1)
     {
         strcpy(maske,"*.TXT");
     }
     if (taste==2)
     {
         strcpy(maske,"*.TBT");
     }
     if (taste==3)
     {
         strcpy(maske,"*.ASC");
     }
     if (taste==4)
     {
         strcpy(maske,"*.DOC");
     }
     if (taste==5)
     {
         strcpy(maske,"*.TEX");
     }


     wrtxt("\n[Next file selection screen: file to processed]>");
     tastelesen();
     sc_gotoxy(1,one_config_set.sl);
     sc_clreol();


     strcpy(eingabe,"");
     if (!datei_suchen(maske,text_name))
     {
         wrtxt("\n[Please press any key]>");
         tastelesen();
         return 0;
     }
     strcpy(eingabe,"REFSC01");


     wrtxt("\n\n");
     sc_gotoxy(1,one_config_set.sl-1);


     do
     {
         info_zeile("Enter a filename for the output BBT file, [Esc] to leave");
         strcpy(wrtxtbu,"BBT file...........");
         wrtxt(wrtxtbu);
         taste = e_zle(
                     1+strlen(wrtxtbu),
                     one_config_set.sl-1,
                     eingabe,
                     DOSDATEIVORNAME_LEN,
                     DOSDATEIVORNAME_LEN,
                     0
                  );
         sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
         if (taste==ESC_KEY)
         {
            wrtxt("\n[Function aborted: please press any key]>");
            sc_clreol();
            tastelesen();
            return 0;
         }
         if (isdosfilename(eingabe)==0)
         {
             taste=200;
             continue;
         }
         upper(eingabe);
     }
     while (taste!=ENTER_KEY);
     sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
     sc_gotoxy(1,one_config_set.sl);sc_clreol();
     sc_gotoxy(1,one_config_set.sl-1);
     if (!strcmp(eingabe,""))
     {
         sc_clreol();
         wrtxt("\n[Function aborted with empty string: please press any key]>");
         tastelesen();
         return 0;
     }
     strcpy(bbt_name,eingabe);
     strcat(bbt_name,".BBT");
     if (isfile(bbt_name))
     {
        taste =lotus_menu(
          "Cancel$BBT file already exists, do not overwrite@"
          "Overwrite$Overwrite existing BBT file@"
          );
          if (taste==0 || taste == 1)
          {
             wrtxt("\n[Function aborted: please press any key]>");
             tastelesen();
             return 0;
          }
     }


     do
     {
         info_zeile("Please accept 'refscite()' or enter search "
                     "pattern of type 'cite{}', 'cite()'");
         strcpy(wrtxtbu,"Search pattern.....");
         wrtxt(wrtxtbu);
         taste = e_zle(
                     1+strlen(wrtxtbu),
                     one_config_set.sl-1,
                     musterstr,
                     MUSTER_STR_LEN,
                     MUSTER_STR_LEN,
                     0
                  );
         sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
         if (taste==ESC_KEY)
         {
             wrtxt("\n[Function aborted: please press any key]>");
             sc_clreol();
             tastelesen();
             return 0;
         }
         mustertyp=issearchpattern(musterstr);
         if (mustertyp==0)
         {
             taste=200;
             strcpy(musterstr,SPATTERN);
             continue;
         }
     }
     while (taste!=ENTER_KEY);
     sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
     sc_gotoxy(1,one_config_set.sl);sc_clreol();
     sc_gotoxy(1,one_config_set.sl-1);

     text_lesen();
     sprintf(wrtxtbu,
       "\n"
       "Completed: %li reference numbers extracted into file %s"
       "\n",anz_refs,bbt_name);
     wrtxt(wrtxtbu);
     wrtxt("\n[Please press any key]>");
     tastelesen();

     return 1;
}

static int text_lesen(void)
{

     if ((fptext = fopen(text_name,"rt"))==NULL)
     {
          sprintf(fehlermeldung,"ERROR: Cannot read %s",text_name);
          beenden(fehlermeldung,2);
     }
     if ((fpbbt = fopen(bbt_name,"wb"))==NULL)
     {
          sprintf(fehlermeldung,"ERROR: Cannot create %s",bbt_name);
          beenden(fehlermeldung,2);
     }
     wrtxt("Reading text file, please wait...\n");

     while (fgets(lzeile,LZEILE_LEN,fptext)!=NULL)
     {
        if (strlen(lzeile) >= LZEILE_LEN - 1)
        {
            sprintf(wrtxtbu,"\nProblem: Input line > %i characters "
               "(too long)\n",LZEILE_LEN);
            wrtxt(wrtxtbu);
            break;
        }
        rtrim(lzeile,'\n');
        zeile_parsen(musterstr,lzeile);
     }
     fclose(fptext);
     fclose(fpbbt);

     return 0;
}

static int issearchpattern(char * muster)
{
   int laenge;
   int typ; /* xxx1 (), xxx2{} */
   laenge = strlen(muster);

   typ = 0;

   if (laenge < 3 || laenge > MUSTER_STR_LEN)
   {
      return 0;
   }
   if (countitem(muster," \n\t")!=1)
   {
      return 0;
   }
   if (muster[laenge-1]==')') typ = 1;
   if (muster[laenge-1]=='}') typ = 2;

   if (typ==0) return typ;

   if (typ==1)
   {
      if (locate_substring("(",muster)!=laenge-2)
      {
         return 0;
      }
   }

   if (typ==2)
   {
      if (locate_substring("{",muster)!=laenge-2)
      {
         return 0;
      }
   }
   return typ;
}
