* Program..: Inscrn2.PRG
* Author...: Christopher White
* Date.....: April 1, 1985
* Version..: dBASE III, any version
* Note(s)..: This program allows multiple input screens using
*            format files for each new record entered into a
*            database and movement between input screens.
*            It is applicable to all versions of dBASE III.
*
*            Be sure that the memory variable last reflects
*            the number of screens that you have defined and
*            that the names of your database and index files are
*            in the USE command.
* ---Set up.
SET TALK OFF
lastpage = 3
more = .T.
USE Yourfile INDEX Yourfile
* ---Add records to database until more is false.
DO WHILE more
   pagecount = 1
   next = .F.
   APPEND BLANK
   * ---Add to the current record until next is true.
   DO WHILE .NOT. next
      *---Convert pagecount to Format screen subscript.
      sub = STR( pagecount,1 )
      * ---Get current screen.
      SET FORMAT TO Screen&sub
      READ
      CLOSE FORMAT
      * ---Display prompt line and get what to do next.
      * ---The default is to go to the next screen.
      choice = " "
      DO WHILE .NOT. choice $ "+-FLNE"
         choice = "+"
         @ 22,3 SAY "+)next page -)prev page F)irst page L)ast page " +;
                    "N)ext record E)xit to menu " GET choice PICTURE "!"
         READ
      ENDDO choice
      * ---Do something.
      DO CASE
      CASE choice = "+"
         * ---Go to next screen.
         IF pagecount <> lastpage
            pagecount = pagecount + 1
         ENDIF
      CASE choice = "-"
         * ---Go to previous screen.
         IF pagecount <> 1
            pagecount = pagecount - 1
         ENDIF
      CASE choice = "F"
         * ---Go to first screen.
         pagecount = 1
      CASE choice = "L"
         * ---Go to lastpage screen.
         pagecount = lastpage
      CASE choice = "N"
         * ---Go to next record.
         next = .T.
      CASE choice = "E"
         * ---Exit from this routine.
         more = .F.
         next = .T.
      ENDCASE
   ENDDO next
ENDDO more
CLOSE DATABASE
RETURN
* EOP Inscrn2.PRG