/*
 *  Cheshiresoft Calendar-Almanac
 *  Copyright (c) 2003 by Andrew Ziem.  All rights reserved.
 *  http://chesire.freeservers.com
 *  http://cday.sourceforge.net
 *
 *    TESTCAL.C -- tests calendar math
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */



/*
 * TO DO
 *  - add other calendars
 *  - make easier to read
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "cday.h"
#include "scaldate.h"


char *sok[] = { "ok", "---NOT OK---" };

char *
ok (int a, int b)
{
  if (a == b)
    return sok[0];
  else
    return sok[1];
}


int
main ()
{
  struct shire_tm *my_shire_tm;
  struct tm *my_tm;
  long scalar;
  int yr, mo, day;
  int iok;
  time_t t;

  tzset ();
  t = time (NULL);
  my_tm = localtime (&t);

  printf ("Testing CDAY calendar math...\n");

  printf ("** daynum.c\n");
  printf ("time.h:  yday = %i\n", my_tm->tm_yday + 1); /* originally 0 to 365 */
  printf ("daynu.c: yday = %i\n",
	  daynum (my_tm->tm_year + 1900, my_tm->tm_mon + 1, my_tm->tm_mday)); /* 1 to 366 */
  printf ("matches: %s\n",
	  ok (my_tm->tm_yday + 1,
	      daynum (my_tm->tm_year + 1900, my_tm->tm_mon + 1,
		      my_tm->tm_mday)));
  scalar = ymd_to_scalar (2003, 05, 25);
  printf ("ym_to_scalar(2003,5,25) = %i\n", scalar);
  scalar_to_ymd (scalar, &yr, &mo, &day);
  iok = (2003 == yr && 5 == mo && 25 == day);
  printf ("ymd_to_scalar and back: %s\n", ok (iok, TRUE));
  
/*long ymd_to_scalar (unsigned yr, unsigned mo, unsigned day)
void scalar_to_ymd (long scalar, unsigned *yr, unsigned *mo, unsigned *day)*/
    printf ("** Shire (2003-05-25):\n");
  my_shire_tm = shire_date (2003, 05, 25, 144);

  printf ("holiday: %i %s\n", my_shire_tm->sh_holiday,
	  ok (my_shire_tm->sh_holiday, 0));
  printf ("wday: %s (%i) %s\n", shire_days_archaic[my_shire_tm->sh_wday],
	  my_shire_tm->sh_wday, ok (my_shire_tm->sh_wday, 7));
  printf ("dom: %i %s\n", my_shire_tm->sh_mday, ok (my_shire_tm->sh_mday, 3));
  printf ("month: %s (%i) %s\n", shire_months[my_shire_tm->sh_mon],
	  my_shire_tm->sh_mon);
  printf ("year: %i %s\n", my_shire_tm->sh_year,
	  ok (my_shire_tm->sh_year, 7467));
	  
  exit(EXIT_SUCCESS);

}
