#include "help.h"
#include "mouser.h"
#include <ctype.h>
#include "advanced.h"
#include "gifford.h"

advanced::advanced (data dta, bstring hm, Mcursor & mouse) : the_mouse (mouse), buttons(15)
	{
	home = hm;
	the_data = dta;
	}

advanced::~advanced()
	{
	}

data advanced::show ()
	{
	display ();
	set ();
	get ();

	return the_data;
	}

void advanced::display ()
	{
	gr_clear ();
	type0 ();
	type1 ();
	type2 ();
	type3 ();
	type4 ();
	type5 ();
	type6 ();
	type7 ();
	type8 ();
	type9 ();
	type10 ();
//	type11 ();
	type12 ();
	type13 ();

	current ();
	}


void advanced::current ()
	{
	settextjustify (LEFT_TEXT, CENTER_TEXT);
	setcolor (WHITE);
	outtextxy (10,440, "Current Settings:");
	setcolor (BLACK);

	switch (the_data.occur_type1)
		{
		case -1:
			moveto (50,450);
			outtext ("This has not been set yet.");
			break;
		case 0:
			type0 (the_data.occur_type2, 1);
			break;
		case 1:
			type1 (1);
			break;
		case 2:
			type2 (the_data.occur_type2,1);
			break;
		case 3:
			type3 (the_data.occur_type2, the_data.occur_type3, 1);
			break;
		case 4:
			type4 (the_data.occur_type2,1);
			break;
		case 5:
			type5 (the_data.occur_type2,1);
			break;
		case 6:
			type6 (the_data.occur_type2,1);
			break;
		case 7:
			type7 (the_data.occur_type2,1);
			break;
		case 8:
			type8 (the_data.occur_type2,1);
			break;
		case 9:
			type9 (the_data.occur_type2,1);
			break;
		case 10:
			type10 (0, the_data.occur_type3, the_data.occur_type5,
				the_data.occur_type4, the_data.occur_type6,
				the_data.occur_type2, 1);
			break;
		case 12:
			type12 (1);
			break;

		case 13:
			type13 (1);
			break;
		}
	}

void advanced::type0 (int temp_1, int curr)
	{
// type 0
	settextjustify (LEFT_TEXT, CENTER_TEXT);
	setcolor (BLACK);
	moveto (50,20);
	if (curr)
		moveto (50,450);
	outtext ( "Occurs on the last ");
	bstring temp_text = date_manip.DayName (date_manip.DayOfWeek (the_data.real_day,
		the_data.real_month, the_data.real_year));
	outtext (temp_text.return_string ());
	outtext ( " of ");
	bstring mon_text = date_manip.MonthName (the_data.real_month);
	outtext (mon_text.return_string ());
	outtext ( " every ");
	setcolor (LIGHTRED);
	moveto (432,20);
	if (curr)
		moveto (432,450);
	outtext ("[ ");
	if (temp_1 == -1)
		outtext ("num");
	else
		convert (temp_1);
	outtext (" ]");
	setcolor (BLACK);
	outtext ( " year(s).");
	}

void advanced::type1 (int curr)
	{
// type 1
	settextjustify (LEFT_TEXT, CENTER_TEXT);
	setcolor (BLACK);
	moveto (50,55);
	if (curr)
		moveto (50,450);
	outtext ( "Occurs daily.");
	}

void advanced::type2 (int temp_1, int curr)
	{
// type 2
	settextjustify (LEFT_TEXT, CENTER_TEXT);
	setcolor (BLACK);
	moveto (50,90);
	if (curr)
		moveto (50,450);
	outtext ("Occurs every ");
	setcolor (LIGHTRED);
	outtext ("[ ");
	if (temp_1 == -1)
		outtext ("num");
	else
		convert (temp_1);
	outtext (" ]");
	setcolor (BLACK);
	outtext ( " week(s) on ");
	bstring temp_text = date_manip.DayName (date_manip.DayOfWeek (the_data.real_day,
		the_data.real_month, the_data.real_year));
	outtext (temp_text.return_string ());
	outtext ( ".");
	}

void advanced::type3 (int temp_1, int temp_2, int curr)
	{
	settextjustify (LEFT_TEXT, CENTER_TEXT);
	setcolor (BLACK);
	moveto (50,125);
	if (curr)
		moveto (50,450);
	outtext ( "Occurs on the ");
	temp_1 = date_manip.timesoccured (the_data.real_day,
			the_data.real_month, the_data.real_year);
	outtext (date_manip.Number (temp_1));
	outtext (" ");
	bstring temp_text = date_manip.DayName (date_manip.DayOfWeek
		(the_data.real_day, the_data.real_month, the_data.real_year));
	outtext (temp_text.return_string ());
	outtext ( " of ");
	bstring mon_text = date_manip.MonthName (the_data.real_month);
	outtext (mon_text.return_string ());
	outtext ( " every ");
	setcolor (LIGHTRED);

	moveto (456,125);
	if (curr)
		moveto (456,450);
	outtext ("[ ");
	if (temp_2 == -1)
		outtext ("num");
	else
		convert (temp_2);
	outtext (" ]");
	setcolor (BLACK);
	outtext ( " year(s)");
	outtext ( ".");
	}

void advanced::type4 (int temp_1, int curr)
	{
// type 4
	settextjustify (LEFT_TEXT, CENTER_TEXT);
	setcolor (BLACK);
	moveto (50,160);
	if (curr)
		moveto (50,450);
	outtext ("Occurs on ");
	bstring mon_text = date_manip.MonthName (the_data.real_month);
	outtext (mon_text.return_string ());
	outtext (" ");

	print_day();

	outtext ( " every ");
	setcolor (LIGHTRED);
	moveto (280,160);
	if (curr)
		moveto (280,450);
	outtext ("[ ");
	if (temp_1 == -1)
		outtext ("num");
	else
		convert (temp_1);
	outtext (" ]");
	setcolor (BLACK);
	outtext ( " year(s).");
	}

void advanced::type5 (int temp_1, int curr)
	{
	settextjustify (LEFT_TEXT, CENTER_TEXT);
	setcolor (BLACK);
	moveto (50,195);
	if (curr)
		moveto (50,450);
	outtext ("Every "); // Every (3rd) (Tues) of every (third) month
	int temp_str = date_manip.timesoccured (the_data.real_day,
			the_data.real_month, the_data.real_year);
	outtext (date_manip.Number (temp_str));
	outtext (" ");
	bstring temp_text = date_manip.DayName (date_manip.DayOfWeek (the_data.real_day,
		the_data.real_month, the_data.real_year));
	outtext (temp_text.return_string ());
	outtext (" every ");
	setcolor (LIGHTRED);
	moveto (280,195);
	if (curr)
		moveto (280,450);
	outtext ("[ ");
	if (temp_1 == -1)
		outtext ("num");
	else
		convert (temp_1);
	outtext (" ]");
	setcolor (BLACK);
	outtext (" month(s).");
	}

void advanced::type6 (int temp_1, int curr)
	{
	settextjustify (LEFT_TEXT, CENTER_TEXT);
	setcolor (BLACK);
	moveto (50,230);
	if (curr)
		moveto (50,450);
	outtext ("Occurs on the first day of the month, every ");
	setcolor (LIGHTRED);
	outtext ("[ ");
	if (temp_1 == -1)
		outtext ("num");
	else
		convert (temp_1);
	outtext (" ]");
	setcolor (BLACK);
	outtext (" month(s).");
	}

void advanced::type7 (int temp_1, int curr)
	{
	settextjustify (LEFT_TEXT, CENTER_TEXT);
	setcolor (BLACK);
	moveto (50,265);
	if (curr)
		moveto (50,450);
	outtext ("Occurs on the last day of the month, every ");
	setcolor (LIGHTRED);
	outtext ("[ ");
	if (temp_1 == -1)
		outtext ("num");
	else
		convert (temp_1);
	outtext (" ]");
	setcolor (BLACK);
	outtext (" month(s).");
	}

void advanced::type8 (int temp_1, int curr)
	{
	settextjustify (LEFT_TEXT, CENTER_TEXT);
	setcolor (BLACK);
	moveto (50,300);
	if (curr)
		moveto (50,450);
	outtext ("Occurs on the last day of ");
	bstring mon_text = date_manip.MonthName (the_data.real_month);
	outtext (mon_text.return_string ());
	outtext (" every ");
	setcolor (LIGHTRED);
	moveto (384,300);
	if (curr)
		moveto (384,450);
	outtext ("[ ");
	if (temp_1 == -1)
		outtext ("num");
	else
		convert (temp_1);
	outtext (" ]");
	setcolor (BLACK);
	outtext (" years(s).");
	}

void advanced::type9 (int temp_1, int curr)
	{
	settextjustify (LEFT_TEXT, CENTER_TEXT);
	setcolor (BLACK);
	moveto (50,335);
	if (curr)
		moveto (50,450);
	outtext ("Occurs on day ");
	print_day ();
	outtext (" of every ");
	setcolor (LIGHTRED);
	moveto (256,335);
	if (curr)
		moveto (256,450);
	outtext ("[ ");
	if (temp_1 == -1)
		outtext ("num");
	else
		convert (temp_1);
	outtext (" ]");
	setcolor (BLACK);
	outtext (" month(s).");

	}

void advanced::type10 (int edit, int temp_1, int temp_2, int temp_3, int temp_4, int temp_5, int curr)
	{
	settextjustify (LEFT_TEXT, CENTER_TEXT);
	setcolor (BLACK);
	moveto (50,365);
	if (curr)
		moveto (50,450);
	outtext ("Occurs every ");
	setcolor (LIGHTRED);
	outtext ("[ ");
	if (temp_1 == -1)
		outtext ("num");
	else
		convert (temp_1,1);
	outtext (" ] ");
	setcolor (BLACK);
	bstring temp_text = date_manip.DayName (date_manip.DayOfWeek (the_data.real_day,
		the_data.real_month, the_data.real_year));
	outtext (temp_text.return_string ());
		outtext (" following the ");
	setcolor (LIGHTRED);
	moveto (406,365);
	if (curr)
		moveto (406,450);
	outtext ("[ ");
	if (temp_2 == -1)
		outtext ("num");
	else
		convert (temp_2,1);
	outtext (" ] ");
	moveto (472,365);
	if (curr)
		moveto (472,450);
	outtext ("[ ");
	if (temp_3 == -1)
		outtext ("day");
	else
		c_day (temp_3);
	outtext (" ] ");
	moveto (50,375+(edit*30));
	if (curr)
		moveto (50,460);
	setcolor (BLACK);
	outtext ("of ");
	setcolor (LIGHTRED);
	outtext ("[");
	if (temp_4 == -1)
		outtext ("month");
	else
		{
		outtext (" ");
		gifford	dm;

		bstring temp_var;
		temp_var = dm.MonthName(temp_4);
		bstring destination;
		destination = temp_var (0,3);
		outtext (destination.return_string());
		outtext (" ");
		}
	outtext ("]");
	setcolor (BLACK);
	outtext (" every ");
	setcolor (LIGHTRED);
	outtext ("[ ");
	if (temp_5 == -1)
		outtext ("num");
	else
		convert (temp_5);
	outtext (" ]");
	setcolor (BLACK);
	outtext (" years.");
	}

/* void advanced::type11 (int edit, int temp_1, int temp_2, int temp_3)
	{
	settextjustify (LEFT_TEXT, CENTER_TEXT);
	setcolor (BLACK);
	moveto (50,400);
	outtext ("Occurs every ");
	setcolor (LIGHTRED);
	outtext ("[ ");
	if (temp_1 == -1)
		outtext ("num");
	else
		convert (temp_1,1);
	outtext (" ] ");
	setcolor (BLACK);
	outtext (date_manip.DayName (date_manip.DayOfWeek (the_data.real_month,
		the_data.real_day, the_data.real_year)));
	outtext (" following the ");
	setcolor (LIGHTRED);
	outtext ("[ ");
	if (temp_2 == -1)
		outtext ("num");
	else
		convert (temp_2,1);
	outtext (" ] ");
	outtext ("[ ");
	if (temp_3 == -1)
		outtext ("day");
	else
		c_day (temp_3);
	outtext (" ] ");
	moveto (50,410+(edit*30));
	setcolor (BLACK);
	outtext ("of every ");
	setcolor (LIGHTRED);
	outtext ("[ num ] ");
	setcolor (BLACK);
	outtext ("month(s).");
	} */

void advanced::type12 (int curr)
	{
// type 12
	settextjustify (LEFT_TEXT, CENTER_TEXT);
	setcolor (BLACK);
	moveto (50,405);
	if (curr)
		moveto (50,450);
	outtext ("A one time event.");
	}


void advanced::type13 (int curr)
	{
	settextjustify (LEFT_TEXT, CENTER_TEXT);
	setcolor (BLACK);
	moveto (250,405);
	if (curr)
		moveto (50,450);
	outtext ("A historical event.");
	}

void advanced::c_day (int day)
	{
	vector<bstring>	these_days(7);
	these_days[0] = "Sun";
	these_days[1] = "Mon";
	these_days[2] = "Tue";
	these_days[3] = "Wed";
	these_days[4] = "Thu";
	these_days[5] = "Fri";
	these_days[6] = "Sat";

	outtext (these_days[day].return_string());
	}

void advanced::convert (int num, int suffix)
	{
	bstring result;

	if (suffix)
		{
		result += char (num+48);

		switch (num)
			{
			case 1:
				result += "st";
				break;
			case 2:
				result += "nd";
				break;
			case 3:
				result += "rd";
				break;
			default:
				result += "th";
				break;
			}
		}
	else
		{
		result = " ";
		result += char(num+48);
		result += " ";
		}

	outtext (result.return_string ());
	}


void advanced::print_day ()
	{
	bstring the_number;

	if (the_data.real_day > 9)
		{
		int t_m = the_data.real_day / 10;
		int o_m = the_data.real_day - (t_m * 10);
		the_number += char(t_m+48);
		the_number += char(o_m+48);
		outtext (the_number.return_string());
		}
	else
		{
		the_number += char(the_data.real_day+48);
		outtext (the_number.return_string());
		}
	}

void advanced::set ()
	{
	bstring number_string;
	number_string = " x ";

	for (int i = 0; i < 12; i++)
		{
		number_string[1] = char(i+65);
		buttons[i].init (5,(10+i*35),number_string.return_string(),TEXT);
		}
	buttons [12].init (205,395," M ",TEXT);
	buttons [13].init ((getmaxx()-75),(10), " Help ",TEXT);
	buttons [14].init ((getmaxx()-75),(40)," DONE ",TEXT);
	}

void advanced::get ()
	{
	int exit = -1;

	mouser 	read_mouse (buttons, 15, the_mouse, 14);
	read_mouse.show();

	while (exit == -1)
		{
		char keypress;
		int option = read_mouse.get (keypress);

		keypress = toupper (keypress);

		if (option == 13)
			{
			advanced_help ();
			display ();
			read_mouse.show();
			}

		if (option == 14 || (option == -1 && keypress == 27))
			exit = -2;

		if (option == -1 && (keypress >= 65 && keypress <= 77))
			{
			new_value (keypress - 65);
			display ();
			read_mouse.show();
			exit = -1;
			}

		if (option >= 0 && option < 13)
			{
			new_value (option);
			display ();
			read_mouse.show ();
			exit = -1;
			}
		}
	}

int advanced::new_value (int exit)
	{
	gifford dm;
	int int_1, int_2, int_3, int_4, int_5;

	if (exit > 10)
		exit++;

	gr_clear ();

	switch (exit)
		{
		case 0:
			type0 ();
			int_1 = num_buttons (427,10);
			if (int_1 > -1)
				{
				the_data.occur_type2 = int_1;
				the_data.occur_type3 = dm.DayOfWeek (
					the_data.real_day,
					the_data.real_month,
					the_data.real_year);
				the_data.occur_type4 = 0;
				the_data.occur_type5 = 0;
				the_data.occur_type6 = 0;
				}
			else
				exit = -1;
			break;
		case 1:
			the_data.occur_type2 = 0;
			the_data.occur_type3 = 0;
			the_data.occur_type4 = 0;
			the_data.occur_type5 = 0;
			the_data.occur_type6 = 0;
			break;
		case 2:
			type2 ();
			int_1 = num_buttons (149,80);
			if (int_1 > -1)
				{
				the_data.occur_type2 = int_1;
				the_data.occur_type3 = 0;
				the_data.occur_type4 = 0;
				the_data.occur_type5 = 0;
				the_data.occur_type6 = 0;
				}
			else
				exit = -1;
			break;
		case 3:
			type3 (int_1);
			int_2 = num_buttons (452,115);
			if (int_2 > -1)
				{
				the_data.occur_type2 = dm.timesoccured (the_data.real_day,
					the_data.real_month, the_data.real_year);
				the_data.occur_type3 = int_2;
				the_data.occur_type4 = dm.DayOfWeek (
					the_data.real_day,
					the_data.real_month,
					the_data.real_year);
				the_data.occur_type5 = 0;
				the_data.occur_type6 = 0;
				}
			else
				exit = -1;
			break;
		case 4:
			type4 ();
			int_1 = num_buttons (276,150);
			if (int_1 > -1)
				{
				the_data.occur_type2 = int_1;
				the_data.occur_type3 = 0;
				the_data.occur_type4 = 0;
				the_data.occur_type5 = 0;
				the_data.occur_type6 = 0;
				}
			else
				exit = -1;
			break;
		case 5:
			type5 ();
			int_1 = num_buttons (276,185);
			if (int_1 > -1)
				{
				the_data.occur_type2 = int_1;
				the_data.occur_type3 = dm.timesoccured (the_data.real_day,
					the_data.real_month, the_data.real_year);
				the_data.occur_type4 = dm.DayOfWeek (
					the_data.real_day,
					the_data.real_month,
					the_data.real_year);
				the_data.occur_type5 = 0;
				the_data.occur_type6 = 0;
				}
			else
				exit = -1;
			break;
		case 6:
			type6 ();
			int_1 = num_buttons (397,160);
			if (int_1 > -1)
				{
				the_data.occur_type2 = int_1;
				the_data.occur_type3 = 0;
				the_data.occur_type4 = 0;
				the_data.occur_type5 = 0;
				the_data.occur_type6 = 0;
				}
			else
				exit = -1;
			break;
		case 7:
			type7 ();
			int_1 = num_buttons (389,165);
			if (int_1 > -1)
				{
				the_data.occur_type2 = int_1;
				the_data.occur_type3 = 0;
				the_data.occur_type4 = 0;
				the_data.occur_type5 = 0;
				the_data.occur_type6 = 0;
				}
			else
				exit = -1;
			break;
		case 8:
			type8 ();
			int_1 = num_buttons (380,170);
			if (int_1 > -1)
				{
				the_data.occur_type2 = int_1;
				the_data.occur_type3 = 0;
				the_data.occur_type4 = 0;
				the_data.occur_type5 = 0;
				the_data.occur_type6 = 0;
				}
			else
				exit = -1;
			break;
		case 9:
			type9 ();
			int_1 = num_buttons (252,204);
			if (int_1 > -1)
				{
				the_data.occur_type2 = int_1;
				the_data.occur_type3 = 0;
				the_data.occur_type4 = 0;
				the_data.occur_type5 = 0;
				the_data.occur_type6 = 0;
				}
			else
				exit = -1;
			break;
		case 10:
			type10 (1);
			int_1 = num_buttons (148,115,9,4);
			if (int_1 < 0)
				{
				exit = -1;
				break;
				}
			gr_clear ();
			type10 (1,int_1);
			int_2 = num_buttons (404,115,9,4);
			if (int_2 < 0)
				{
				exit = -1;
				break;
				}
			gr_clear ();
			type10 (1,int_1, int_2);
			int_3 = num_buttons (470,175,7,2);
			if (int_3 < 0)
				{
				exit = -1;
				break;
				}
			gr_clear ();
			type10 (1,int_1, int_2, int_3);
			int_4 = num_buttons (70,65,12,3);
			if (int_4 < 0)
				{
				exit = -1;
				break;
				}
			gr_clear ();
			type10 (1,int_1, int_2, int_3, int_4);
			int_5 = num_buttons (180,155,9);
			if (int_5 < 0)
				{
				exit = -1;
				break;
				}
			else
				{
				// 2nd (mon) follow 3rd tue of feb every 2 years
				the_data.occur_type3 = int_1; // 2nd
				the_data.occur_type5 = int_2; // 3rd
				the_data.occur_type4 = int_3; // tue
				the_data.occur_type6 = int_4; // feb
				the_data.occur_type2 = int_5; // 2 years
				}

			break;
/*		case 11:
			type11 (1);
			int_1 = num_buttons (148,150,9,1);
			if (int_1 < 0)
				{
				exit = -1;
				break;
				}
			gr_clear ();
			type11 (1,int_1);
			int_2 = num_buttons (398,150,9,1);
			if (int_2 < 0)
				{
				exit = -1;
				break;
				}
			gr_clear ();
			type11 (1,int_1, int_2);
			int_3 = num_buttons (465,209,7,2);
			if (int_3 < 0)
				{
				exit = -1;
				break;
				}
			gr_clear ();
			type11 (1,int_1, int_2, int_3);
			int_4 = num_buttons (116,190,9);
			if (int_3 < 0)
				{
				exit = -1;
				break;
				}
			else
				{
				the_data.occur_type2 = int_1;
				the_data.occur_type3 = int_2;
				the_data.occur_type4 = int_3;
				the_data.occur_type5 = int_4;
				the_data.occur_type6 = 0;
				}
			break; */
		case 12:
			the_data.occur_type2 = 0;
			the_data.occur_type3 = 0;
			the_data.occur_type4 = 0;
			the_data.occur_type5 = 0;
			the_data.occur_type6 = 0;
			break;
		case 13:
			the_data.viewed = 4;
			the_data.occur_type2 = 0;
			the_data.occur_type3 = 0;
			the_data.occur_type4 = 0;
			the_data.occur_type5 = 0;
			the_data.occur_type6 = 0;
			break;
		}

	if (exit != -1)
		the_data.occur_type1 = exit;

	if (the_data.occur_type1 == 11)
		the_data.occur_type1 = 12;

	return exit;
	}


void advanced::gr_clear (int x1, int y1, int x2, int y2)
	{
	the_mouse.hide();
	setfillstyle (SOLID_FILL,LIGHTBLUE);
	bar (x1,y1,x2,y2);
	}

void advanced::advanced_help ()
	{
	bstring temp_filename = "IMPRO.HL3";
	bstring help_location = home + temp_filename;

	help the_help (the_mouse, help_location);

	the_help.show ();
	}

int advanced::num_buttons (int x, int y, int how_many, int suffix)
	{
	gifford	dm;

	vector<bstring>	these_days(7);
	these_days[0] = "Sun";
	these_days[1] = "Mon";
	these_days[2] = "Tue";
	these_days[3] = "Wed";
	these_days[4] = "Thu";
	these_days[5] = "Fri";
	these_days[6] = "Sat";

	int exit = 0;

	buttons [0].init ((getmaxx()-75),(getmaxy()-30)," DONE ",TEXT);

	for (int i = 1; i <= how_many; i++)
		{
		bstring destination;

		if (i == 1 && (suffix == 0 || suffix == 1))
			destination = " EVERY ";
		else
			{
			for (int j = 0; j < 3-(suffix>0); j++)
				destination += ' ';

			if (suffix == 0 || suffix == 1 || suffix == 4)
				destination += char(i+48);

			if (suffix == 3)
				{
				bstring temp_var;
				temp_var = dm.MonthName(i);
				destination += temp_var (0,3);
				}

			if (suffix == 2)
				destination += these_days[i-1];

			if (suffix == 1 || suffix == 4)
				{
				switch (i)
					{
					case 1:
						destination += "st";
						break;
					case 2:
						destination += "nd";
						break;
					case 3:
						destination += "rd";
						break;
					default:
						destination += "th";
						break;
					}
				}
			for (int k = 0; k < 3-(suffix > 0); k++)
				destination += ' ';
			}

		buttons[i].init (x,y+(30*(i-1)),(destination.return_string()),TEXT);
		}

	mouser 	read_mouse (buttons, how_many+1, the_mouse, 0);
	read_mouse.show();


	while (!exit)
		{
		char keypress;
		int option = read_mouse.get (keypress);

		keypress = tolower (keypress);


		if ((option == -1 && keypress == 27) || option == 0)
			exit = -1;
		if (option > 0)
			exit = option;
		if (option == -1 && (keypress-48) >= 1 && (keypress-48) <= how_many)
			exit = keypress-48;
		}
	if (suffix == 2)
		exit--;
	return exit;
	}