/********************************************************************
**  YEARCAL.C v0.17T  Copyright (c) 1987, 1988, 1989 by Paul M. Sittler.
**  All rights reserved.  The copyright owner hereby authorizes the
**  no-charge, noncommercial making and/or distribution of copies of
**  the entirety of this work unchanged and unincorporated in any
**  other work (except "LiBRary" or "ARChive" disk files for the sole
**  purpose of no-charge noncommercial distribution).  No other
**  reproduction or use is authorized without the express prior
**  written consent of the copyright owner.
**
**************************************************************/

/* ANSI header files included:  */
#include <stdio.h>	/* fclose, fopen, fp, fprintf, fputs, */
			/* gets, printf, rename, sprintf, stderr */
#include <ctype.h>	/* toupper */
#include <fcntl.h>	/* O_BINARY, O_RDWR */
#include <io.h>		/* close, lseek, open, read, write */
#include <stdlib.h>	/* exit */
#include <string.h>	/* memset, strcat, strcmp, strcpy, strlen */

/* Turbo-C Header files included:  */
#include <conio.h>	/* getch, putch */
#include <dos.h>	/* DOS-specific file from Borland */

#include "yearcal.def"

struct options Opt;	/* Defined in YEARCAL.DEF, Declared here */

extern int directvideo = 0;	/* Gag me with a spoon! */
				/* An "enhancement" of Turbo-c v1.5, v2.0 */
				/* 0 = use BIOS calls */
				/* 1 = write to video ram for PC-Compats */
				/* For MSDOS generic, this must now be zero.*/
				/* And it STILL doesn't work!! */
				/* The getch function generates wild */
				/* interrupts on a Z-100 */

/* Suppress some library functions to conserve space */
/* void _setargv () {}
 * void _setenvp () {}
 */

/* ---- array of border character sets ------ */
struct LineDraw bcs[] =
{ /*  nw,  ne,  se,  sw, sid, lin,  ni, Ascii Characters top, sides */
    {'-', '-', '-', '-', '|', '-', '-',
  /*  si,  wi,  ei,  ns,  ew, isi, cross */
     '-', '|', '|', '|', '-', '-', '-'},
  /*  nw,  ne,  se,  sw, sid, lin,  ni, 1-line top, sides, inside */
    {218, 191, 217, 192, 179, 196, 194,
  /*  si,  wi,  ei,  ns,  ew, isi, cross */
     193, 195, 180, 179, 196, 193, 197},
  /*  nw,  ne,  se,  sw, sid, lin,  ni, 2-line top, sides, 1-line inside */
    {201, 187, 188, 200, 186, 205, 209,
  /*  si,  wi,  ei,  ns,  ew, isi, cross */
     207, 199, 182, 179, 196, 193, 197},
  /*  nw,  ne,  se,  sw, sid, lin,  ni, 2-line top, sides, inside */
    {201, 187, 188, 200, 186, 205, 203,
  /*  si,  wi,  ei,  ns,  ew, isi, cross */
     202, 204, 185, 186, 205, 202, 206},
  /*  nw,  ne,  se,  sw, sid, lin,  ni, 1-line top, 2-line sides, 1-line mid */
    {214, 183, 189, 211, 186, 196, 210,
  /*  si,  wi,  ei,  ns,  ew, isi, cross */
     208, 199, 182, 186, 196, 193, 215},
  /*  nw,  ne,  se,  sw, sid, lin,  ni, 2-line top, 1-line sides, 1-line mid */
    {213, 184, 190, 212, 179, 205, 209,
  /*  si,  wi,  ei,  ns,  ew, isi, cross */
     207, 198, 181, 179, 205, 193, 216},
  /*  nw,  ne,  se,  sw, sid, lin,  ni, 1-line top, 2-line sides, 2-line mid */
    {214, 183, 189, 211, 186, 196, 210,
  /*  si,  wi,  ei,  ns,  ew, isi, cross */
     208, 204, 185, 186, 205, 202, 206},
  /*  nw,  ne,  se,  sw, sid, lin,  ni, 2-line top, 1-line sides, 2-line mid */
    {213, 184, 190, 212, 179, 205, 203,
  /*  si,  wi,  ei,  ns,  ew, isi, cross */
     202, 198, 181, 186, 205, 202, 206}
};


/* Put month's lengths into array of structures */
struct month mon[] =
    {
	{ 31, 0}, { 28, 0}, { 31, 0},
	{ 30, 0}, { 31, 0}, { 30, 0},
	{ 31, 0}, { 31, 0}, { 30, 0},
	{ 31, 0}, { 30, 0}, { 31, 0}
    };

int lingos = 33;	/* Available languages */



/* Put names of langages into array */
char *lingo[] =
    {
	"Afrikaans",		/*  0 */
	"Arabic",		/*  1 */
	"Cantonese",		/*  2 */
	"Czech",		/*  3 */
	"Danish",		/*  4 */
	"Dutch",		/*  5 */
	"English",		/*  6 */
	"Esperanto",		/*  7 */
	"Finnish",		/*  8 */
	"French",		/*  9 */
	"Gaelic",		/* 10 */
	"German",		/* 11 */
	"Greek",		/* 12 */
	"Hebrew",		/* 13 */
	"Hungarian",		/* 14 */
	"Indonesian",		/* 15 */
	"Irish",		/* 16 */
	"Italian",		/* 17 */
	"Japanese",		/* 18 */
	"Korean",		/* 19 */
	"Mandarin",		/* 20 */
	"Norwegian",		/* 21 */
	"Polish",		/* 22 */
	"Portugese",		/* 23 */
	"Romanian",		/* 24 */
	"Russian",		/* 25 */
	"Serbo-Croatian",	/* 26 */
	"Spanish",		/* 27 */
	"Swahili",		/* 28 */
	"Swedish",		/* 29 */
	"Texan",		/* 30 */
	"Turkish",		/* 31 */
	"Yiddish"		/* 32 */
    } ;



/* Put names of months into array */
char *mnam[][12] =
       {
/* Afrikaans	0 */  "JANUARI",    "FEBRUARI",    "MAART",     "APRIL",
		      "MEI",        "JUNI",        "JULI",      "AUGUSTUS",
		      "SEPTEMBER",  "OKTOBER",     "NOVEMBER",  "DECEMBER",
/* Arabic	1 */  "YANAYIR",    "FIBRAYER",    "MARIS",     "ABRIL",
		      "MAYO",       "YOUNYA",      "YOULYA",    "AGHOUSTOUSS",
		      "SEPTEMBAR",  "OKTOBAR",     "NOUVEMBAR", "DISEMBAR",
/* Cantonese	2 */  "YAT YUET",   "YEE YUET",    "SAAM YUET", "SAY YUET",
		      "NG YUET",    "LOOK YUET",   "CHAT YUET", "BAAT YUET",
		"GAU YUET",   "SUP YUET",    "SUP-YAT YUET","SUP-YEE YUET",
/* Czech	3 */  "LEDEN",      "UNOR",        "BREZEN",    "DUBEN",
		      "KVETEN",     "CERVEN",      "CERVENEC",  "SRPEN",
		      "ZARI",       "RIJEN",       "LISTOPAD",  "PROSINEC",
/* Danish	4 */  "JANUAR",     "FEBRUAR",     "MARTS",     "APRIL",
		      "MAJ",        "JUNI",        "JULI",      "AUGUST",
		      "SEPTEMBER",  "OKTOBER",     "NOVEMBER",  "DECEMBER",
/* Dutch	5 */  "JANUARI",    "FEBRUARI",    "MAART",     "APRIL",
		      "MEI",        "JUNI",        "JULI",      "AUGUSTUS",
		      "SEPTEMBER",  "OKTOBER",     "NOVEMBER",  "DECEMBER",
/* English	6 */  "JANUARY",    "FEBRUARY",    "MARCH",     "APRIL",
		      "MAY",        "JUNE",        "JULY",      "AUGUST",
		      "SEPTEMBER",  "OCTOBER",     "NOVEMBER",  "DECEMBER",
/* Esperanto	7 */  "JANUARO",    "FEBRUARO",    "MARTO",     "APRILO",
		      "MAJO",       "JUNIO",       "JULIO",     "AUGUSTO",
		      "SEPTEMBRO",  "OKTOBRO",     "NOVEMBRO",  "DECEMBRO",
/* Finnish	8 */  "TAMMIKUU",   "HELMIKUU",    "MAALISKUU", "HUHTIKUU",
		      "TOUKOKUU",   "KESAKUU",     "HEINAKUU",  "ELOKUU",
		      "SYYSKUU",    "LOKAKUU",     "MARRASKUU", "JOULUKUU",
/* French	9 */  "JANVIER",    "FEVRIER",     "MARS",      "AVRIL",
		      "MAI",        "JUIN",        "JUILLET",   "AOUT",
		      "SEPTEMBRE",  "OCTOBRE",     "NOVEMBRE",  "DECEMBRE",
/* Gaelic	10 */ "FAOILTEACH", "GEARRAN", 	   "MART",      "GIBLEAN",
		      "CEITEAN",    "T-OG-MHIOS",  "T-IUCHAR",  "LUNASDAL",
		      "T-SULTAINN", "DAMHAR",      "T-SAMHAINN","DUDLACHD",
/* German	11 */ "JANUAR",     "FEBRUAR",     "MAERZ",     "APRIL",
		      "MAI",        "JUNI",        "JULI",      "AUGUST",
		      "SEPTEMBER",  "OKTOBER",     "NOVEMBER",  "DEZEMBER",
/* Greek	12 */ "IANOUA'RIOS","FEVROUA'RIOS","MAR'TIOS",  "APRI'LIOS",
		      "MA'IOS",     "IOU'NIOS",    "IOU'LIOS",  "AV'GOUSTOS",
		      "SEPTEM'VRIOS","OKTO'VRIOS", "NOEM'VRIOS","DEKEM'VRIOS",
/* Hebrew	13 */ "YANUAR",     "FEBRUAR",     "MERTS",     "APRIL",
		      "MAY",        "YUNI",        "YULI",      "AVGUST",
		      "SEPTEMBER",  "OKTOBER",     "NOVEMBER",  "DETSEMBER",
/* Hungarian	14 */ "JANUAR",     "FEBRUAR",     "MARCIUS",   "APRILIS",
		      "MAJUS",      "JUNIUS",      "JULIUS",    "AUGUSZTUS",
		      "SZEPTEMBER", "OKTOBER",     "NOVEMBER",  "DECEMBER",
/* Indonesian	15 */ "DJANUARI",   "FEBRUARI",    "MARET",     "APRIL",
		      "MAI",        "DJUNI",       "DJUI",      "AUGUSTUS",
		      "SEPTEMBER",  "OKTOBER",     "NOPEMBER",  "DESEMBER",
/* Irish	16 */ "EANAIR",     "FEABHRA",     "MARTA",     "TABREAN",
		      "BHEALTAINE", "MEITHEAMH",   "IUIL",      "LUNASA",
	"MEAN FHOMHAIR","DEIREADH FOMHAIR","MI NA SAMHNA","MI NA NOLLAG",
/* Italian	17 */ "GENNAIO",    "FEBBRAIO",    "MARZO",     "APRILE",
		      "MAGGIO",     "GIUGNIO",     "LUGLIO",    "AGOSTO",
		      "SETTEMBRE",  "OTTOBRE",     "NOVEMBRE",  "DICEMBRE",
/* Japanese	18 */ "ICHIGATSU",  "NIGATSU",     "SANGATSU",  "SHIGATSU",
		      "GOGATSU",    "ROKUGATSU",   "SHICHIGATSU","HACHIGATSU",
		      "KUGATSU",    "JUGATSU",     "JUICHIGATSU","JUNIGATSU",
/* Korean	19 */ "IL-WOL",     "I-WOL",       "SAM-WOL",   "SA-WOL",
		      "O-WOL",      "YU-WOL",      "CH'IL-WOL", "P'AL-WOL",
		      "KU-WOL",     "SI-WOL",      "SIP IL-WOL","SIP I-WOL",
/* Latin	      "JANUARIUS",  "FEBRUARIUS",  "MARTIUS",   "APRILIS",
		      "MAIUS",      "JUNIUS",      "JULIUS",    "AUGUSTUS",
		      "SEPTEMBER",  "OCTOBER",     "NOVEMBER",  "DECEMBER", */
/* Mandarin	20 */  "YI YUE",    "ER YUE",      "SAN YUE",   "SI YUE",
		       "WU YUE",    "LIU YUE",     "QI YUE",    "BA YUE",
		       "JIU YUE",   "SHI YUE",     "SHI YI YUE","SI ER YUE",
/* Norwegian	21 */  "JANUAR",    "FEBRUAR",     "MARS",      "APRIL",
		       "MAI",       "JUNI",        "JULI",      "AUGUST",
		       "SEPTEMBER", "OKTOBER",     "NOVEMBER",  "DESEMBER",
/* Polish	22 */  "STYCZEN",   "LUTY",        "MARZEC",    "KWIECIEN",
		       "MAJ",       "CZERWIEC",    "LIPIEC",    "SIERPIEN",
		       "WRZESIEN",  "PAZDZIERNIK", "LISTOPAD",  "GRUDZIEN",
/* Portugese	23 */  "JANEIRO",   "FEVEREIRO",   "MARCO",     "ABRIL",
		       "MAIO",      "JUNHO",       "JULHO",     "AGOSTO",
		       "SETEMBRO",  "OUTUBRO",     "NOVEMBRO",  "DEZEMBRO",
/* Romanian     24 */  "IANUARIE",  "FEBRUARIE",   "MARTIE",    "APRILIE",
		       "MAI",       "IUNIE",       "IULIE",     "AUGUST",
		       "SEPTEMBRIE","OCTOMBRIE",   "NOIEMBRIE", "DECEMBRIE",
/* Russian	25 */  "YANVAR",    "FEVRAL",      "MART",      "APRYEL",
		       "MAY",       "YUN",         "YUL",       "AVGUST",
		       "SINTYABR",  "AKTYABR",     "NAYABR",    "DEKABR",
/* Serbo-Croatian 26 */"JANUAR",    "FEBRUAR",     "MART",      "APRIL",
		       "MAJ",       "JUN",         "JULI",      "AVGUST",
		       "SEPTEMBAR", "OKTOBAR",     "NOVEMBAR",  "DECEMBAR",
/* Spanish	27 */  "ENERO",     "FEBRERO",     "MARZO",     "ABRIL",
		       "MAYO",      "JUNIO",       "JULIO",     "AGOSTO",
		       "SEPTIEMBRE","OCTUBRE",     "NOVIEMBRE", "DICIEMBRE",
/* Swahili	28 */  "JANUARI",   "FEBRUARI",    "MACHI",     "APRILI",
		       "MEI",       "JUNI",        "JULAI",     "AGOSTI",
		       "SEPTEMBA",  "OKTOBA",      "NOVEMBA",   "DESEMBA",
/* Swedish	29 */  "JANUARI",   "FEBRUARI",    "MARS",      "APRIL",
		       "MAJ",       "JUNI",        "JULI",      "AUGUSTI",
		       "SEPTEMBER", "OKTOBER",     "NOVEMBER",  "DECEMBER",
/* Texan	30 */  "JANYEWARY", "FEBYEWARY",   "MAHCH",     "AYEPRIL",
		       "MEYE",      "CHEWN",       "CHEW-LIE",  "AWGUST",
		       "SEPTEMBUH", "AWKTOBUH",    "NOVEMBUH",  "DEESEMBUH",
/* Turkish	31 */  "OCAK",      "SUBAT",       "MART",      "NISAN",
		       "MAYIS",     "HAZIRAN",     "TEMMUZ",    "AGUSTOS",
		       "EYLUL",     "EKIM",        "KASIM",     "ARALIK",
/* Yiddish	32 */  "YANUAR",    "FEBRUAR",     "MERTS",     "APRIL",
		       "MAI",       "YUNI",        "YULI",      "OIGUST",
		       "SEPTEMBER", "OKTOBER",     "NOVEMBER",  "DETSEMBER"
      } ;



/* Put names of days into array */
char *wkday[][7] =
       {
/* Afrikaans	0 */	"SONDAG",	"MAANDAG",	"DINSDAG",
			"WOENSDAG",	"DONDERDAG",	"VRYDAG",
			"SATERDAG",
/* Arabic	1 */	"AL-AHAD",	"AL-ITSNAIN",	"AL-TSOULATSA",
			"AL-ARBAA",	"AL-CHAMIS",	"AL GOUMAA",
			"AL-SABT",
/* Cantonese	2 */	"LAI-BAAI",	"YAT",		"YEE",
			"SAAM",		"SAY",		"NG",
			"LOOK",
/* Czech	3 */	"NEDELE",	"PONDELI",	"UTERY",
			"STREDA",	"CTVRTEK",	"PATEK",
			"SOBOTA",
/* Danish	4 */	"SONDAG",	"MANDAG",	"TIRSDAG",
			"ONSDAG",	"TORSDAG",	"FREDAG",
			"LORDAG",
/* Dutch	5 */	"ZONDAG",	"MAANDAG",	"DINSDAG",
			"WOENSDAG",	"DONDERDAG",	"VRIJDAG",
			"ZATERDAG",
/* English	6 */	"SUNDAY",	"MONDAY",	"TUESDAY",
			"WEDNESDAY",	"THURSDAY",	"FRIDAY",
			"SATURDAY",
/* Esperanto	7 */	"DIMANCO",	"LUNDO",	"MARDO",
			"MERKREDO",	"JAUDO",	"VENDREDO",
			"SABATO",
/* Finnish	8 */	"SUNNUNTAI",	"MAANANTAI",	"TIISTAI",
			"KESKIVIIKKO",	"TORSTAI",	"PERJANTAI",
			"LAUANTAI",
/* French	9  */	"DIMANCHE",	"LUNDI",	"MARDI",
			"MERCREDI",	"JEUDI",	"VENDREDI",
			"SAMEDI",
/* Gaelic	10 */	"DOMHNAICH",	"LUAIN",	"MAIRT",
			"CIADAIN",	"ARDAOIN",	"HAOINE",
			"SATHURNA",
/* German	11 */	"SONNTAG",	"MONTAG",	"DIENSTAG",
			"MITTWOCH",	"DONNERSTAG",	"FREITAG",
			"SONNABEND",
/* Greek	12 */	"KYRIAKI",	"DEFTE'RA",	"TRI'TI",
			"TETA'RTI",	"PEM'PTI",	"PARASKEVI",
			"SA-VVATON",
/* Hebrew	13 */	"RISCHON",	"SCHENI",	"SCHELISCHI",
			"REVIIE",	"CHAMISCHI",	"SCHISCHI",
			"SCHABAT",
/* Hungarian	14 */	"VASARNAP",	"HETFO",	"KEDD",
			"SZERDA",	"CSUTORTOK",	"PENTEK",
			"SZOMBAT",
/* Indonesian	15 */	"AHAD",		"SENIN",	"SELASA",
			"REBO",		"KEMIS",	"DJUMAHAT",
			"SABTU",
/* Irish	16 */	"DOMHNACH",	"LUAN",		"MHAIRT",
			"CHEADOIN",	"DEARDAOIN",	"AOINE",
			"SATHARN",
/* Italian	17 */	"DOMENICA",	"LUNEDI",	"MARTEDI",
			"MERCOLEDI",	"GIOVEDI",	"VENERDI",
			"SABATO",
/* Japanese	18 */	"NICHIYOBI",	"GETSUYOBI",	"KAYOBI",
			"SUIYOBI",	"MOKUYOBI",	"KIN'YOBI",
			"DOYOBI",
/* Korean	19 */	"IL-YO-IL",	"WOL-YO-IL",	"HWA-YO-IL",
			"SU-YO-IL",	"MOK-YO-IL",	"KUM-YO-IL",
			"T'O-YO-IL",
/* Latin	  	"DOMINICUS",	"LUNES",	"MIUS",
			"",		"",		"",
			"", */
/* Mandarin     20 */	"TIAN XING QI",	"YI XING QI",	"ER XING QI",
			"SAN XING QI",	"SI XING QI",	"WU XING QI",
			"LU XING QI",
/* Norwegian	21 */	"SONDAG",	"MANDAG",	"TIRSDAG",
			"ONSDAG",	"TORSDAG",	"FREDAG",
			"LORDAG",
/* Polish	22 */	"NIEDZIELA",	"PONIEDZIALEK",	"WTOREK",
			"SRODA",	"CZWARTEK",	"PIATEK",
			"SOBOTA",
/* Portugese	23 */	"DOMINGO",	"SEGUNDA-FEIRA","TERCA-FEIRA",
			"QUARTA-FEIRA",	"QUINTA-FEIRA",	"SEXTA-FEIRA",
			"SABADO",
/* Romanian     24 */   "DUMINICA",     "LUNI",         "MARTI",
			"MIERCURI",     "JOI",          "VINERI",
			"SIMBATA",
/* Russian	25 */	"VOSKRESYENYE",	"PANIDYELNIK",	"FTORNIK",
			"SREDA",	"CHETVERK",	"PYATNITSA",
			"SUBOTA",
/* Serbo-Croatian 26 */	"NEDELJA",	"PONEDELJAK",	"UTORAK",
			"SREDA",	"CETVRTAK",	"PETAK",
			"SUBOTA",
/* Spanish	27 */	"DOMINGO",	"LUNES",	"MARTES",
			"MIERCOLES",	"JUEVES",	"VIERNES",
			"SABADO",
/* Swahili	28 */	"JUMAPILI",	"JUMATATU",	"JUMANNE",
			"JUMATANO",	"ALHAMISI",	"IJUMAA",
			"JUMAMOSI",
/* Swedish	29 */	"SONDAG",	"MANDAG",	"TISDAG",
			"ONSDAG",	"TORSDAG",	"FREDAG",
			"LORDAG",
/* Texan	30 */	"SUNNY",	"MONEY",	"TEWSDI",
			"WEDDSDI",	"THIRSTY",	"FRAWDDI",
			"SATTADI",
/* Turkish	31 */	"PAZAR",	"PAZARTESI",	"SALI",
			"CARSAMBA",	"PERSEMBE",	"CUMA",
			"CUMARTESI",
/* Yiddish	32 */	"SUNTOG",	"MONTOG",	"DIENSTTOG",
			"MITVOCH",	"DONNERSCHTOG",	"FREITOG",
			"SCHABBES"
      } ;



/* Hebrew - based on solar years and lunar months.
   shelema - 355 days - complete year, with Heshvan & Keslev having 30 days.
   sedur   - 354 days - normal year, Heshvan is defective (29 days).
   hasera  - 353 days - Heshvan & Kislev both defective (29 days).
   The 11 days by which the solar year (365 days) exceeds the lunar year
   (354 days) are accounted for by having a 13th month (Veadar of 30 days)
   on the 3rd, 6th, 8th, 11th, 14th, and 17th year of a 19 year cycle.

    "TISHRI", 30,	"HESHVAN", 29/30,	"KISLEV", 29/30,
    "TEBET", 29,	"SHEBAT", 30,		"ADAR", 30,	"VEADAR", 30
    "NISAN", 30,	"IYAR", 29,		"SIVIAN", 30,
    "TAMMUZ", 29,	"AB", 30,		"ELUL", 29
*/

int yr[3][12][6][7];			/* Array for 3 yrs, 4-D, */
					/* 3 years,      12 months/year, */
					/* 6 weeks/month, 7 days/week */

char *new_file  = "DATAFILE.$$$";
char *file      = "DATAFILE.CAL";
FILE *fp;



void main(int argc, char *argv[])
{
  int bd,				/* Beg day passed to functions */
      bm,       			/* Beg month passed to functions */
      by,				/* Beg year passed to functions */
      fy_bm,				/* Fiscal year beginning month */
      fy_bd,				/* Fiscal year beginning date */
      i,
      j,
      year;

  char c,
       outp;

  struct date today;			/* Template date defined in */
					/* <dos.h> from Borland */
  get_opts(argv[0]);
  signon();

    getdate(&today);			/* Get DOS's idea of date */
					/* DOS specific. . . */
    fy_bd = today.da_day;		/* Make it today */
    fy_bm = today.da_mon;		/* Make it this month */
    year  = today.da_year;		/* It was a very good year. . . */

  for ( ;; )
  {
    fprintf(stderr,
"\nSchedule period to be <A>nnual, <M>onthly, <W>eekly, or <D>aily (A/M/W/D)? %c\b",
			   Opt.sched_type ?
			   Opt.sched_type :
			   'A'              );
    for ( ;; )
    {
	c = toupper(getch());

	switch(c)
	{
	    case  'M'  : break;
	    case  'W'  : break;
	    case  'D'  : break;
	    case  'A'  : break;
	    case '\033': exit(0);
	    case '\r'  :
	    case '\n'  : c = (Opt.sched_type == FALSE) ?
						    'A':
					 Opt.sched_type;
	    default    : ;
	}

	if ( c == 'M' ||
	     c == 'W' ||
	     c == 'D' ||
	     c == 'A'  )
	{
	    Opt.sched_type = c;
	    putch(c);

	    if (Opt.sched_type == 'A')
		Opt.sched_type = FALSE;

	    break;
	}

	continue;
    }

    if (Opt.sched_type == 'D' ||	/* Schedule what sort of time? */
	Opt.sched_type == 'W'  )
    {
	fputs("\nUse 24-hour time format", stderr);
	Opt.mil = get_yn(Opt.mil ? 'y' :
				   'n'   );
    }

    fputs("\nType year desired for calendar (1582-4000): ", stderr);
    year = get_int(year, 4, 1582, 4000);

    fprintf(stderr, "\nHow many successive %ss? (0-99): ",
		Opt.sched_type == 'M' ? "month" :
		Opt.sched_type == 'W' ? "week"  :
		Opt.sched_type == 'D' ? "day"   :
					"year"   ) ;
    Opt.more_yrs = get_int(Opt.more_yrs, 2, 0, 99);

    if (!Opt.sched_type)
    {
	fputs("\nDo you want an Aggie Calendar", stderr);
	Opt.aggie = get_yn(Opt.aggie ?
				 'y' :
				 'n');
    }

    if (!Opt.aggie)
    {
	if (!Opt.sched_type)
	{
	    fputs("\nDo you want a 3-digit Julian Calendar", stderr);
	    Opt.julian = get_yn(Opt.julian ? 'y' :
					     'n'  );
	}

	if (! (Opt.julian | Opt.sched_type) )
	{
	    fputs("\nFiscal year calendar ", stderr);
	    Opt.fy = get_yn(Opt.fy ? 'y' :
				     'n'  );
	}

	if (Opt.fy | Opt.sched_type)
	{
	    fprintf(stderr, "\n%s beginning month (1-12): ",
		Opt.sched_type == 'M' ?  "Monthly calendar" :
		Opt.sched_type == 'W' ?  "Weekly schedule"  :
		Opt.sched_type == 'D' ?  "Daily schedule"   :
					 "Fiscal year"       );

	    /* make month J=0, F=1, . . . D=11 */
	    fy_bm = get_int(fy_bm, 2, 1, 12);

	    if (Opt.sched_type != 'M')
	    {
		fprintf(stderr, "\n%s beginning date  (1-31): ",
		    Opt.sched_type == 'W' ? "Weekly schedule" :
		    Opt.sched_type == 'D' ? "Daily schedule"  :
					    "Fiscal year"       );

		fy_bd = get_int(fy_bd, 2, 1, 31);
	    }
	    else
	    fy_bd = 1;			/* Make months start on first */
	}
    }   /* Endif (!Opt.aggie) */
    else 				/* Opt.aggie) */
	Opt.sched_type = Opt.julian = Opt.fy = FALSE;

    if (Opt.sched_type        &&
	Opt.sched_type != 'M'  )
    {
	fprintf(stderr, "\n%s schedule beginning hour  (0-23): ",
	    Opt.sched_type == 'W' ? "Weekly" :
				    "Daily"   );

	Opt.bh = get_int(Opt.bh, 2, 0, 23);

	fprintf(stderr, "\n%s schedule number of hours (1-24): ",
	    Opt.sched_type == 'W' ? "Weekly" :
				    "Daily"   );
	Opt.nh = get_int(Opt.nh, 2, 1, 24);
    }

    if (Opt.sched_type)
    {
	fputs(
    "\n\nYou may enter up to five custom title lines for the schedules."
    "\nThe first three titles entered will be printed on the top three lines."
    "\nThe last two titles will be printed below the date titles.", stderr);

	for (i = 0;
	     i < 8;
	     i++  )
	{
	    if (i == 3)
	    {
		fputs("\nTitles #4, #5, and #6 are used for dates.", stderr);
		i = 6;			/* So skip to Title #7 */
	    }
	    fprintf(stderr,
      "\nTitle #%d currently is (RETURN to keep it the same, SPACE to erase):",
		i + 1);
	    fprintf(stderr, "\nTitle #%d: %s",
				      i + 1,
					  Opt.title[i][0] ?
					  Opt.title[i]    :
					  "\t(No title currently defined)" );
	    fprintf(stderr, "\nTitle #%d: ", i + 1);
	    gets(Opt.title[4]);

	    if (Opt.title[4][0] != '\0')
		strcpy(Opt.title[i], Opt.title[4]);
	}
    }

    fputs("\nProgrammer's Calendar", stderr);
    i = get_yn(Opt.base ?
		    'y' :
		    'n');

    if (!i)				/* Decimal numbers used */
	Opt.base = FALSE;
    else				/* Hexadecimal or Octal numbers */
    {
	fprintf(stderr,
	"\n<H>exadecimal or <O>ctal numbering (H/O)? %c\b",
						     (Opt.base == FALSE) ?
						     'H'                 :
						     Opt.base            );

	for ( ;; )
	{
	    c = toupper(getch());

	    switch(c)
	    {
		case  'O': break;
		case  'H': break;
		case '\r':
		case '\n': c = (Opt.base == FALSE) ?
					       'H' :
					       Opt.base;
			   break;
		default  : c = '?';
	    }

	    if ( c == 'H' ||
		 c == 'O'  )
	    {
		putch(c);
		Opt.base = c;
		break;
	    }

	    continue;
	}
    }

    fputs("\nThe calendar(s) may be composed in several languages:\n\t",
	    stderr);

    for (i = 0;
	 i < lingos;
	 i++)
    {
	if (!(i % 3))
	    fputs("\n\t", stderr);

	fprintf(stderr, "<%2d> = %-15s",
			 i + 1, lingo[i]);
    }


    fprintf(stderr, "\nWhich language for this calendar? (1-%d): ",
							    lingos);
    Opt.lang = get_int(Opt.lang, 2, 1, lingos);

    if (Opt.sched_type)		/* IBM line drawing sets useful only */
				/*   in M/W/D schedules at this time */
    {
	fputs(
    "\n\nYou may optionally use IBM line-drawing characters for the borders.\n"

    "\n\t<0> = ASCII characters, which will work with most printers."
    "\n\t    The following use IBM extended graphic characters."
    "\n\t<1> = Single line top/bottom, sides, and inside."
    "\n\t<2> = Double line top/bottom, sides, and 1-line inside."
    "\n\t<3> = Double line top/bottom, sides, and inside."
    "\n\t<4> = Single line top/bottom, 2-line sides, and 1-line inside."
    "\n\t<5> = Double line top/bottom, 1-line sides and inside."
    "\n\t<6> = Single line top/bottom, 2-line sides and inside."
    "\n\t<7> = Double line top/bottom, 1-line sides, and 2-line inside."

    "\n\nType # of Line Drawing Character set to use (0-7): ", stderr);
	Opt.lds = get_int(Opt.lds, 1, 0, 7);
    }

    fputs("\n<V>iew, <P>rint, or write to <F>ile(s) (V/P/F)? V\b", stderr);

    for ( ;; )
    {
	c = toupper(getch());

	switch(c)
	{
	    case  'F'  : outp = 'F'; break;
	    case  'P'  : outp = 'P'; break;
	    case '\033': exit(0);
	    case '\r'  :
	    case '\n'  :
	    case  'V'  : outp = 'V'; break;
	    default    : outp = '?';
	}

	if (outp == 'F' ||
	    outp == 'V' ||
	    outp == 'P'  )
	{
	    putch(c);
	    break;
	}

	continue;
    }

    if (Opt.sched_type)		/* Page width/length useful only */
				/* in M/W/D schedules at this time */
    {
	if (outp == 'P' ||	/* We want hardcopy */
/*          outp == 'V' ||  	 * He wants to look at it */
	    outp == 'F'  )	/* He wants a file */
	{
	    fputs("\nType # of lines for each page (51-132): ",
		stderr);
	    Opt.pl = get_int(Opt.pl, 3, 51, 132);

	    fputs("\nType # of characters for each line (40-270): ",
		stderr);
	    Opt.pw = get_int(Opt.pw, 3, 40, 270);

	    fputs("\nType # of spaces for left margin indent (0-40): ",
		stderr);
	    Opt.indent = get_int(Opt.indent, 2, 0, 40);
	}
    }   /* endif Opt.Sched_type) */

    if (outp == 'P')		/* Hardcopy selected */
    {
	fprintf(stderr,
	"\nType # of copies desired of each %s (1-999): ",
		     (Opt.sched_type == 'M') ? "month" :
		     (Opt.sched_type == 'W') ? "week"  :
		     (Opt.sched_type == 'D') ? "day"   :
					       "year"  );
	Opt.copies = get_int(Opt.copies, 3, 1, 999);

	fputs("\nPause after each page", stderr);
	Opt.pause = get_yn(Opt.pause ?
				 'y' :
				 'n' );
    }

    setup_files(outp);

    by = year;
    bm = fy_bm - 1;
    bd = fy_bd;

    for (i = 0;
	 i < Opt.more_yrs + 1;
	 i++, Opt.sched_type == 'M' ? bm++   :
	      Opt.sched_type == 'W' ? bd += 7:
	      Opt.sched_type == 'D' ? bd++   :
				      by++    )
    {
	if (leap(by))			/* Tidy up month length array */
	    mon[1].length = 29; 	/* For this year by fixin' Feb. . . */
	else
	    mon[1].length = 28;

	if (bd > mon[bm].length)	/* Past this End Of Month */
	{
	    bd -= mon[bm].length;	/* So make it appropriate day. . . */
	    bm++;			/* Of following month. . . */
	}

       if (bm > 11)			/* Egad! We are past December. . . */
       {
	    bm = bm % 12;		/* Normalise it. . . */

	    if (bm == 0)		/* Now have January? J=0, F=1 D=11 */
		by++;			/* Ratchet the year. . . */
       }

	if (!Opt.julian)		/* Prepare the calendar arrays */
	    prep_cal(by);

	for ( j = 0;
	      j < Opt.copies;
	      j++)
	{
	    if (Opt.sched_type)
		sched_printer(by,             outp,      bm,
			      bd,             Opt.bh,    Opt.nh,
			      Opt.pl,         Opt.pw,    Opt.sched_type,
			      Opt.title,
			      Opt.base,       Opt.lang,  Opt.pause,
			      Opt.indent,     Opt.lds  );
	    else
	    if (Opt.julian)
		jul_printer(by,       outp,
			    Opt.base, Opt.lang, Opt.pause );
	    else
	    if (Opt.aggie)
		agg_printer(by,       outp,
			    Opt.base, Opt.lang, Opt.pause );
	    else
	    if (Opt.fy)
		cal_printer(by,       outp,     bm,
			    Opt.fy,   bd,
			    Opt.base, Opt.lang, Opt.pause );
	    else
		cal_printer(by,       outp,     0,
			    Opt.fy,   1,
			    Opt.base, Opt.lang, Opt.pause);
	}
    }

    fputs("\nAnother calendar", stderr);

    if (!get_yn('n'))
    {
	if (outp != 'F')
	    fclose(fp);

        fputs("\nRetain present options as defaults", stderr);

	if (get_yn('n'))
            put_opts(argv[0]);

	exit(0);
    }
  }
}



