{FILE_ID.DIZ}

{
DelNull is a public domain utility
which deletes all files in a given
filespec that are 0 bytes in size.
}

{DELNULL.HIS}

{
  v1.0  03.Jan.1996   Kurt Keller
        initial version
}

{DELNULL.DOC}

{
DelNull       v1.0


 DelNull deletes all the files in a given filespec, which are 0 bytes in
 length.
 Probably hardly anybody will ever be in need of something like this, but
 I was.

Usage


 DelNull takes one command line parameters:

     DelNull drive:\path\filespec

 drive:\path\filespec is the filespec in which to search for 0 byte files;
 wildcards are allowed.


Registration


 Usually I ask people to even register my freeware utilities, but I think that
 hardly anybody would ever use this utility, so I don't ask you to register
 DelNul.


Distribution & Payment


 DelNull is a put in the in the Public Domain. You are free to use it on as
 many machines as you like, to give it away and even to sell it. Source code
 in Turbo Pascal for DOS 7.0 is included.

 IF YOU CHANGE THE SOURCE CODE AND/OR PROGRAM, YOU MUST UPDATE THE HISTORY FILE
 (DELNULL.HIS) AND REMARK THE CHANGES MADE AND YOUR NAME!

Support


 If you need support for DelNull, you best learn some Pascal and have a look
 at the source code. There is no support from my side.

Disclaimer


 YOU USE THIS SOFTWARE ENTIRELY AT YOUR OWN RISK. THERE IS NO GUARANTEE
 WHATSOEVER THAT IT WILL WORK, WORK PROPERLY OR BE FIT FOR ANY SPECIFIC
 PURPOSES. NO RESPONSIBILITY FOR ANY DAMAGES OR LOSSES (ACTUAL OR HYPOTHETICAL)
 CAN BE TAKEN BY THE AUTHOR OR PINBOARD. IF YOU DO NOT AGREE WITH THIS
 PARAGRAPH, PLEASE REFRAIN FROM USING THE SOFTWARE.
}



{ ---------------------------------------------------------------------------- }
{ ͻ
{  Del Null                                                     {DELNULL.EXE}
{ ͼ
{  ͼ
{ ---------------------------------------------------------------------------- }

PROGRAM DelNull;

          {
            Deletes all the files in the passed filespec (including path) which
            have a filesize of 0 bytes.

          }

          {
            needs:

          unit        Files

          }

uses    Files;

const   {program info constants}

  _PROGRAM_       = 'DelNull';
  _PROGRAMSHORT_  = 'DelNull';
  _VERSION_       = '1.0';
  _COMPDATE_      = '03.01.1996';                       {compile date}
  _VERDATE_       = '03.01.1996';                       {version date}
  _COPYRIGHT_     = 'by PINBOARD 1996';
  _LICENSE_       = 'in the Public Domain';

const   {main}

  _PROCNAME_      = 'main';                             {procedure main}

var     {global}

  rc_fileinfo     : fileinfo;                           {defined in Files unit}
  s_scr1          : string;                             {scratch string}

{ ---------------------------------------------------------------------------- }
{ ---------------------------------------------------------------------------- }
{ ---------------------------------------------------------------------------- }
{             }
{   Include   }
{             }
{ ---------------------------------------------------------------------------- }

{common files}

{special files}

{ ---------------------------------------------------------------------------- }

{ ---------------------------------------------------------------------------- }
{ ͻ }
{  CommandLineSyntax  }
{ ͼ }
{ ---------------------------------------------------------------------------- }

PROCEDURE CommandLineSyntax;

          {
            shows the usage of the program and exits
          }

          {
            needs:

            const
                      _VERSION_
                      _VERDATE_
                      _COPYRIGHT_

          }

{ ---------------------------------------------------------------------------- }

BEGIN                                                 {show how to use it}

  WriteLn;
  WriteLn ('         ***********');
  WriteLn ('           DelNull');
  WriteLn ('         ***********');
  WriteLn ('          version ', _VERSION_ ,' - ', _VERDATE_);
  WriteLn ('          ', _COPYRIGHT_);
  WriteLn ('          ', _LICENSE_);
  WriteLn;
  Writeln ('Deletes all files in the given filespec that have a filesize of 0 bytes.');
  WriteLn;
  WriteLn ('usage:');
  WriteLn;
  WriteLn ('DelNull  d:\path\filespec');
  WriteLn ('               ');
  WriteLn ('             ');
  WriteLn ('                  > filespec of the files to delete');
  WriteLn ('             > path');
  WriteLn ('         > drive');
  WriteLn;
  WriteLn;

  Halt (1);                                             {exit with errorlevel 1}

END;


{ ---------------------------------------------------------------------------- }
{ ͻ }
{  Main  }
{ ͼ }
{ ---------------------------------------------------------------------------- }



BEGIN

  {exactly 1 command line parameter expected}
  if ParamCount <> 1 then CommandLineSyntax;

  {give help for -? and -h (/? and /h resp)}
  s_scr1 := ParamStr(1);
  s_scr1 := UpCase(s_scr1[2]);
  if ((s_scr1 = 'H') or (s_scr1 = '?')) then
    CommandLineSyntax;

  {check for first match}{|||--> archive attribute}
  if (FirstFile (ParamStr(1), $20, rc_FileInfo)) <> 0 then
    writeln ('No files with given filespec found.')
  else

  Begin {check and delete found files}
    repeat
      if rc_FileInfo.Size = 0 then

      Begin {delete file}
        if EraseFile (rc_FileInfo.Fullname) then
          writeln ('    ' + rc_FileInfo.Fullname + ' successfully deleted')
        else
          writeln ('*** ' + rc_FileInfo.Fullname + ' could not be deleted');
      End;  {delete file}

    until NextFile (rc_FileInfo) <> 0;
  End;  {check and delete found files}

  writeln;

END.
