comment ^

  MTMem - Memory to store mtdirs and mtprev[] for Move To (mt.com)
  Copyright Jason Hood 1996-8.
  Started:   5 May, 1996.
  Finished:  2 June.
  Modified: 29 October - updated to reflect changes in mt.cpp
	    10-11 February, 1997 - changed to AMIS, support for virtual machines
	     8 March - removed TOPMEM from INSTALL_TSR.
	    27 March - allow more than two previous directories by using a null-
		       separated list instead of fixed-length.
	    20 May, 1998 - added memory for the directory stack;
			   changed return values in address;
			   lowercased MTDIRS.DAT;
			   corrected specified path null-termination bug.
	    4 November - canonicalize the mtdirs path.


  Usage: mtmem [d:/path] [;path[;path;path...]]
  Where: d:/path    is the path to place the directory structure file.
		      Default is the same path as mtmem.com.
	 ;path...   is an initial list of previous directories. The first path
		      is the previous directory, second path is the before prev.
		      dir., etc., for a maximum of MaxPath*2 (132) characters.
		      Default is an empty string ("" is an invalid path.).

  Assumptions: all parameters are valid. Previous list is assumed to be smaller
	       than MaxPath*2 (since command line length is 127 characters,
	       shouldn't be a problem).

  Acknowledgements: Ralf Brown's interrupt list and AMIS;
		    DOSCLIP by Douglas Boling for instance data setup.

  You are free to use this code, or a portion thereof, as long as an appropriate
  acknowledgement is made.

  Questions, suggestions and comments to jadoxa@hotmail.com.

^

VERSION_NUM	equ	212h

MaxPath 	equ	80		; These values are from dir.h
MaxDir		equ	66

byt		equ	<byte ptr>
wrd		equ	<word ptr>
ofs		equ	<offset>
jmps		equ	<jmp short>


__TINY__	equ	0		; Define tiny model for AMIS

		INCLUDE AMIS.MAC

		@Startup 3,00


TSRcode@

StartupInfo     =       $
 sisVersion	dw	3		; Switcher structure ID
 sisNextDev	dd	0		; Ptr to prev startup structure
 sisVirtDevFile dd	0		; Ptr to name of opt dev drvr
 sisReferenceData dd	0		; Data for Win dev drivr
 sisInstData	dd	0		; Ptr to instance mem list

DataBlockPtr	dd	0		; Ptr to instance data
DataBlockSize	dw	0		; Size of instance data
		dd	0		; Ptr to next block = 0 to
		dw	0		;   terminate list

; Instance data
DataBlock	=	$

mtdirs		db	MaxPath       dup (0)
prev		db	2*MaxDir + 1  dup (0)
dirstack	db	2*MaxDir + 1  dup (0)

DataBlockEnd	=	$

INSTDATASIZE	equ	ofs DataBlockEnd - ofs DataBlock


; Multiplex service function - return the addresses for mt.com:
;   DX:AX	mtdirs
;   DX:BX	null-separated list of previous directories,
;		terminated by a null:
;
;   "c:\previous",0,"c:\before\previous",0,"c:\another\previous",0,0
;
;   DX:CX	directory stack, also null-separated.

address:
	mov	dx, cs
	mov	ax, ofs mtdirs
	mov	bx, ofs prev
	mov	cx, ofs dirstack
	iret


	HOOKED_INTS 2fh

	ALTMPX	'Adoxa', 'MTMem', VERSION_NUM,, address


; Initialise instance data
	ISP_HEADER 2fh

	cmp	ax, 1605h		; Windows launch
	je	instance
	cmp	ax, 4b05h		; Switcher instance data
	je	instance
	jmp	ORIG_INT2Fh
instance:
	pushf
	call	ORIG_INT2Fh
	mov	wrd sisNextDev, bx
	mov	wrd sisNextDev+2, es
	push	cs			; ES:BX point to switcher struc
	pop	es
	mov	bx, ofs StartupInfo

	iret

TSRcodeEnd@

;-----------------------------------------------------------------------

_TEXT	SEGMENT 'CODE'
	ASSUME	cs:_TEXT, ds:_INIT, es:TGROUP, ss:NOTHING

F_PATH	equ	01b
F_INST	equ	10b

flags	db	0			; Bit 0 - path was initialised
					;     1 - already installed
mtfile	db	'mtdirs.dat'            ; Filename to append to mtdirs

	@Startup2 PSP

	IF_INSTALLED get_segment
	jmps	parse

get_segment:
	mov	al, 10h
	int	2dh
	mov	es, dx
	or	flags, F_INST

parse:	mov	si, 81h 		; Command line
	xor	ah, ah			; Terminating null

param:	lodsb
	cmp	al, 0dh
	je      done
	cmp     al, ' '                 ; Ignore spaces
	je      param
	cmp	al, 9			;  and tabs
	je	param

	cmp	al, ';'                 ; The list of previous directories?
	je	isprev
	mov	di, ofs mtdirs		; Offset for directory structure path
	or	flags, F_PATH		; Indicate a path was specified
	jmps	copy

isprev: lodsb
	mov	di, ofs prev

copy:   cmp     al, ' '                 ; End of this parameter
	je	null
	cmp	al, 9
	je	null
	cmp     al, 0dh
	je	null
	cmp	al, ';'                 ; Previous directory separator
	jne	slash
	mov	al, ah			; Use a null instead
	jmps	store
slash:	cmp	al, '/'                 ; Replace slashes with backslashes
	jne	nslash			;  for comparison purposes
	mov     al, '\'
	jmps	store
nslash: cmp     al, 'a'                 ; Convert lower to uppercase for the
	jb	store			;  same reason and to select the drive
	cmp     al, 'z'
	ja      store
	and     al, 5fh
store:  stosb
	lodsb
	jmps	copy

null:	mov	byt es:[di], ah 	; Place the terminating null
	cmp	di, ofs prev		; If copying the path
	jae	null2			;  point BX to its end
	mov	bx, di
	jmps	more
null2:	inc	di			; The null to terminate the list
	mov	byt es:[di], ah
more:	cmp	al, 0dh 		; More parameters?
	jne	param

done:	test	flags, F_PATH		; Was a path entered?
	jnz	append			; Yes, so don't search for one

	mov	bx, es			; Save where I'm copying in BX
	mov	ax, ds:[2ch]		; Get the environment segment
	mov	dx, ax			;  and save it in DX
	mov	es, ax
	ASSUME	es:NOTHING
	sub	di, di
	xor     al, al
	mov     cx, 0ffffh
envend: repne   scasb                   ; End of environment variable
	cmp	byt es:[di], al 	; End of environment?
	jne     envend
	inc     di                      ; Point past the word stored after
	inc	di			;  the environment variables to get
	inc	di			;  the path of mtmem.com
	mov	si, ofs mtdirs		; Swap source and destination
	xchg	si, di			;  for the copy
	mov     ds, dx
	mov	es, bx
	ASSUME	ds:NOTHING, es:TGROUP
mvpath: lodsb
	or      al, al                  ; Terminating null?
	jz	append
	stosb
	cmp     al, '\'
	jne     mvpath
	mov     bx, di                  ; BX will point to "MTMEM.COM"
	jmps	mvpath

append: mov	di, bx			; The end of the path
	cmp     byt es:[di-1], '/'      ; Is there a trailing slash
	je      app
	cmp	byt es:[di-1], '\'      ;  or backslash?
	je      app
	mov	byt es:[di], '\'        ; No, so add one
	inc     di
app:	push	cs
	pop	ds
	ASSUME	ds:_TEXT
	mov	si, ofs mtfile		; The filename to append
	movsw                           ; It's ten characters
	movsw				;  which means five words
	movsw
	movsw
	movsw
	mov	byt es:[di], 0		; Terminating null

	mov	ah, 60h 		; "TRUENAME"
	mov	si, ofs mtdirs
	mov	di, si
	push	es
	pop	ds
	ASSUME	ds:TGROUP
	int	21h

	test	flags, F_INST
	jz	install
	mov	ax, 4c00h
	int	21h

install:
	INSTALL_TSR , BEST, , installed

installed:
	; Initialise the switcher instance structure
	mov	ds, ax
	ASSUME	ds:TGROUP

	mov	wrd DataBlockPtr+2, ax
	mov	wrd DataBlockPtr, ofs DataBlock
	mov	wrd DataBlockSize, INSTDATASIZE

	mov	wrd sisInstData+2, ax
	mov	ax, ofs DataBlockPtr
	mov	wrd sisInstData, ax

	ret

_TEXT	ENDS

	end	INIT
