
/*\
                                                                    
     FDTR 3.0  -   Mdulo de test de velocidad de disquetes.        
                                                                    
                (C) 1994-1995  Ciriaco Garca de Celis              
                                                                    
\*/

#include <conio.h>
#include <alloc.h>
#include <dos.h>
#include "2m-info.h"


#define MAXS     46       /* como mximo, 46 sectores de 512 bytes */
#define BMAX  (MAXS*512L)
#define RD        2
#define WR        3

#define CX       12       /* color para pantalla de "memoria insuficiente" */
#define CFX       0       /* color de fondo para "memoria insuficiente" */
#define CP       15       /* color principal */
#define CFP       0       /* color de fondo principal */
#define C3D      14       /* color para el marco 3D */
#define C3M      10       /* color para la banda del marco 3D */
#define CFC       3       /* color de fondo central */
#define CB        4       /* color para botones de unidades */
#define CTB      15       /* color para tinta de botones de unidades */
#define CT       15       /* color para tinta del test */
#define CFT       1       /* color de fondo para el test */


extern   int  Tecla (void);
extern   int  TipoDrive (int);
extern   int  Hay2M3 (void);
extern   int  sp;
extern   void CursorOff (void);
extern   void BrilloOn (void);
extern   void ventana (int, int, int, int, int, int, int);
extern   void v3dg (int, int, int, int, int, int, int, int, int);
extern   void v3df (int, int, int, int, int, int, int, int);
extern   void boton (int, int, int, int, int, int, char *);
extern   void interrupt NuevaInt24 (void);
extern   char *dec2str (unsigned);
extern   char *dec3str (unsigned);
extern   char *dec5str (unsigned);
extern   char *dec2strq (unsigned);
extern   char *dec3strq (unsigned);
extern   char *dec5strq (unsigned);
extern   unsigned long tiempo (void);


char     *Memoria (char **);
void     PruebaBios (int, unsigned char *, int),
         PruebaDos (int, unsigned char *, int);
int      Es2mgui (int),
         biosdsk (int, int, int, int, int, int, unsigned char *),
         EvaluaBiosIO (unsigned, char *, unsigned,
                       unsigned, unsigned, unsigned, unsigned),
         EvaluaDosIO (unsigned, char *, unsigned, unsigned,
                      unsigned, unsigned),
         ObtenerInfo (unsigned, struct dfree *,
                      unsigned *, unsigned *, unsigned *, unsigned *);


void fdtr (int autotest, int drive)
{
  char unidad[4],
       base,
       btxt[]=" A: ",
       *bloque, *buffer, disco;
  void interrupt (*ViejaInt24) (void);
  int  i, opc;


  if ((bloque=Memoria (&buffer))!=NULL) {
    if (TipoDrive(0)!=-1) {
        unidad[0]=TipoDrive(0);  /* !=0 si existe */
        unidad[1]=TipoDrive(1);  /* !=0 si existe */
        }
      else {
        unidad[0]=1;
        if (peekb(0x40, 0x10) >> 6) unidad[1]=1; else unidad[1]=0;
        }

    unidad[2]=unidad[3]=0;  /* supuestas no unidades 2MGUI */
    disco=2;
    for (i=2; i<26; i++)
      if (Es2mgui(i)) {
        if (disco==2) base=i;  /* letra inicial unidades 2MGUI */
        unidad [disco++] = 1;
        }

    textbackground (CFP); textcolor (CP); clrscr();
    v3dg (1, 1, 80, 25, 1, 4, C3D, CFP, C3M);
    textbackground (CFP); textcolor (CP);
    gotoxy (16,7);
    if (sp)
        cputs("CALCULO DE LA VELOCIDAD DE TRANSFERENCIA ABSOLUTA");
      else
        cputs("   ABSOLUTE FLOPPY DISK DATA TRANSFER RATE CALC");
    window (18, 9, 62, 19); textbackground (CFC); clrscr();
    v3df (2, 1, 43, 11, 1, 1, CFC+8, CFC);
    textcolor (CP);
    gotoxy (6,4);
    if (sp) cputs("Pulsa la letra de la unidad elegida");
      else cputs("Press drive-key to choose one drive");
    for (i=0; i<4; i++) {
      if (i<2) btxt[1]=i+'A'; else btxt[1]=i+'A'+base-2;
      if (unidad[i]) boton (i*8+8, 6, CB,CTB,CP,CFC, btxt);
      }
    boton (8, 8, CB,CTB,CP,CFC, sp?"INTRO":"ENTER");
    if (sp) cputs(" Salir"); else cputs(" Exit");
    window (1,1,80,25);

    ViejaInt24=getvect(0x24);
    setvect (0x24, NuevaInt24);      /* evitar error crtico */
    for (;;) {
      CursorOff();
      if (!autotest) opc = Tecla(); else opc=drive+'A';
      if ((opc==27) || (opc==13) || (opc==0x2D00)) break;
      disco = (opc | ' ') - 'a';
      if (((disco>=0) && (disco<2) && (unidad[disco])) ||
         ((disco-base>=0) && (disco-base<2) && (unidad[disco-base]))) {
        ventana (ABRIR, 16, 9, 65, 19, CT, CFT);
        gotoxy (14,1); if (sp) cputs("UNIDAD "); else cputs("DRIVE ");
        putch(disco+'A'); putch(':');
        if (disco<2)
            PruebaBios (disco, buffer, autotest);
          else
            PruebaDos (disco, buffer, autotest);
        ventana (CERRAR, 16, 9, 65, 19, 0, 0);
        }
      if (autotest) break;
    }
    setvect (0x24, ViejaInt24);
    farfree (bloque);
  }
}


char *Memoria (char **buffer)
{
  unsigned long dir;
  char     *bloque, *bf;

  *buffer=bloque=farmalloc(BMAX << 1);
  bf=farmalloc(4096L);

  if ((*buffer==NULL) || (bf==NULL)) {
    if (*buffer!=NULL) farfree (*buffer);
    textbackground (CFX); textcolor (CX); clrscr();
    gotoxy (26,12);
    if (sp)
        cputs ("Memoria insuficiente para FDTR");
      else
        cputs ("Insufficient memory for FDTR");
    CursorOff();
    delay (2000);
    return (NULL);
    }

  farfree (bf);  /* liberar bloque "de seguridad" */

  dir = ((unsigned long) FP_SEG(*buffer) <<4) + FP_OFF(*buffer);
  if ( (dir>>16) != ( (dir+BMAX) >> 16) )
     *buffer+=BMAX;    /* evitar buffer entre dos pginas de DMA */

  return (bloque);
}


void PruebaBios (int unidad, unsigned char *buffer, int autotest)
{
  struct   dfree dsk;
  unsigned sectores, cabezales, cilindros, ts, acabo;

  if (sp) cputs(" Nivel BIOS"); else cputs(" BIOS access");

  acabo = ObtenerInfo (unidad, &dsk, &sectores, &cabezales, &cilindros, &ts);
  if (acabo) {
    gotoxy (3,3); if (sp) cputs("LECTURA: "); else cputs("READ: ");
    acabo = EvaluaBiosIO (RD, buffer, unidad, cilindros, sectores, cabezales, ts);
    if (acabo) {
      gotoxy (3,6); if (sp) cputs("ESCRITURA: "); else cputs("WRITE: ");
      if (dsk.df_avail < dsk.df_total) {
          gotoxy (5,7);
          if (sp)
              cputs("Disquete no vaco -> sin test de escritura");
            else
              cputs("Diskette not empty -> write test skipped");
          }
        else
          EvaluaBiosIO (WR, buffer, unidad, cilindros, sectores, cabezales, ts);
      }
    }

  gotoxy (18,9);
  if (!autotest || !acabo) {
      if (sp) cputs("Pulsa una tecla"); else cputs(" Press any key");
      CursorOff();
      Tecla();
      }
    else {
      CursorOff();
      delay(2000);
      }
}


void PruebaDos (int unidad, unsigned char *buffer, int autotest)
{
  struct   dfree dsk;
  unsigned sectores, cabezales, cilindros, totsect, ts, acabo;

  if (sp) cputs("  Nivel DOS"); else cputs("  DOS access");

  acabo = ObtenerInfo (unidad, &dsk, &sectores, &cabezales, &cilindros, &ts);
  if (acabo) {
    totsect = cilindros*cabezales*sectores;
    gotoxy (3,3); if (sp) cputs("LECTURA: "); else cputs("READ: ");
    acabo = EvaluaDosIO (RD, buffer, unidad, sectores, totsect, ts);
    if (acabo) {
      gotoxy (3,6); if (sp) cputs("ESCRITURA: "); else cputs("WRITE: ");
      if (dsk.df_avail < dsk.df_total) {
          gotoxy (5,7);
          if (sp)
              cputs("Disquete no vaco -> sin test de escritura");
            else
              cputs("Diskette not empty -> write test skipped");
          }
        else
          EvaluaDosIO (WR, buffer, unidad, sectores, totsect, ts);
      }
    }

  gotoxy (18,9);
  if (!autotest || !acabo) {
      if (sp) cputs("Pulsa una tecla"); else cputs(" Press any key");
      CursorOff();
      Tecla();
      }
    else {
      CursorOff();
      delay(2000);
      }
}


int Es2mgui (int unidad)
{
  unsigned char  drv[128];
  union    REGS  r;
  struct   SREGS s;
  int      loes = 0;

  if (unidad > 1) {
    r.x.ax = 0x440D; r.x.bx = unidad+1; r.x.cx = 0x860;
    s.ds   = r.x.si = FP_SEG (drv);
    r.x.dx = r.x.di = FP_OFF (drv); drv[0]=0;
    intdosx (&r, &r, &s);
    if ((!(r.x.flags & 1)) && (
         (drv[6]=='2'+'M') || (drv[6]=='2'+'M'+1)
         )
       ) loes = 1;  /* es 2MGUI */
    }

  return (loes);
}


int ObtenerInfo (unidad, dsk, sectores, cabezales, cilindros, tsector)
unsigned unidad, *sectores, *cabezales, *cilindros, *tsector;
struct dfree *dsk;
{
  int  error=0;
  Boot arranque;

  getdfree (unidad+1, dsk);

  if (dsk->df_sclus==65535) {
    error++;
    gotoxy (11,5);
    if (sp)
        cputs("Error de acceso a la unidad");
      else
        cputs("   Error on drive access");
    }
  else if ((long) dsk->df_total*dsk->df_sclus>65535L) {
    error++;
    gotoxy (6,5);
    if (sp)
        cputs("Disquetes de ms de 32M no soportados");
      else
        cputs("Diskettes above 32M can not be tested");
    }

  if (!error)
    if (absread (unidad, 1, 0L, &arranque)) {
      error++;
      gotoxy (13,5);
      cputs("      Fatal ????");
    }

  if (!error) {
    *tsector=arranque.BytesSect;
    *sectores=arranque.SectPista; *cabezales=arranque.Caras;
    if ((*sectores==0) || (*cabezales==0)) {
      error++;
      gotoxy (10,5);
      if (sp)
          cputs("Sector de arranque defectuoso");
        else
          cputs("Diskette boot record damaged");
      }
    }

  if (!error) {
    *cilindros=arranque.NumSect/(*sectores)/(*cabezales);
    if (*sectores>MAXS) {
      error++;
      gotoxy (4,5);
      if (sp)
          cputs("No soportados ms de ");
        else
          cputs("Not supported more than ");
      cputs (dec2strq(MAXS));
      if (sp) cputs(" sectores/pista!"); else cputs(" sectors/track!");
      }
    }

  return (error==0);
}


int biosdsk (cmd, drive, head, track, sector, nsects, buffer)
int cmd, drive, head, track, sector, nsects;
unsigned char *buffer;
{
  union REGS r; struct SREGS s;

  r.h.ah=cmd; r.h.dl=drive; r.h.dh=head; r.h.ch=track; r.h.cl=sector;
  r.h.al=nsects; s.es=FP_SEG(buffer); r.x.bx=FP_OFF(buffer);

  int86x (0x13, &r, &r, &s);
  return (r.h.ah);
}


int EvaluaBiosIO (operacion, buffer, unidad, cilindros, nsect, cabezales, ts)
unsigned operacion, unidad, cilindros, nsect, cabezales, ts;
char *buffer;
{
  int      cilindro, cabezal, fin_io=0, res, xx, yy;
  unsigned long tini, tfin;
  float    bseg;

  if (sp)
      cprintf("(buffer de %4.1f Kb)\n", nsect*ts/1024.);
    else
      cprintf("(%4.1f Kb buffer)\n", nsect*ts/1024.);

  xx=5; yy=wherey();

  outportb (0x43, 0x36);  /* asegurar que cnt0 usa byte bajo-alto */
  outportb (0x40, 0); outportb (0x40, 0);

  res=0;
  for (cilindro=0; cilindro<cilindros; cilindro++)
    for (cabezal=0; cabezal<cabezales; cabezal++) {
    if ((cilindro==1) && (!cabezal)) tini=tiempo();
    if (kbhit()) if (getch()==27) {
      gotoxy (xx, yy); clreol();
      if (sp) cputs("Abortado por el usuario!");
        else cputs("Aborted by user!");
      goto aborta_io;
      }
    if (res) {
      gotoxy (xx, yy); clreol();
      if (sp)
          cputs("Fallo en el acceso a disco!");
        else
          cputs("Failure on disk access!");
      goto aborta_io;
      }
    gotoxy (xx, yy);
    if (sp) cputs("Cilindro "); else cputs("Cylinder ");
    cputs (dec2strq(cilindro));
    if (sp) cputs(" - Cara "); else cputs(" - Side ");
    cputs (dec2strq(cabezal));
    res=biosdsk (((operacion==WR) && (!cilindro)) ? RD: operacion,
                   unidad, cabezal, cilindro, 1, nsect, buffer);
    }
  tfin=tiempo(); fin_io=1;

  bseg=(512L*nsect*(cilindros-1)*cabezales)/((tfin-tini)/1193180.0);
  gotoxy (1, yy);
  if (sp)
      cprintf("  %7.2f seg =%6.2f Kb/seg [%7.0f bits/seg]\n",
             (tfin-tini)/1193180.0, bseg/1024.0, bseg*8);
    else
      cprintf("  %7.2f sec =%6.2f Kb/sec [%7.0f bits/sec]\n",
             (tfin-tini)/1193180.0, bseg/1024.0, bseg*8);

  aborta_io:
  return (fin_io);
}


int EvaluaDosIO (operacion, buffer, unidad, nsect, sectores, tsector)
unsigned operacion, unidad, nsect, sectores, tsector;
char *buffer;
{
  unsigned monto, sects, ssis, sini, ns, stest, fin_io=0, res, xx, yy;
  unsigned long tini, tfin;
  float    bseg;

  if (nsect==1) {                   /* disco 2MGUI */
      if (operacion==WR)
          monto=65535L/tsector;
        else
          monto = BMAX / tsector;   /* sectores caben en el buffer */
      sects=stest=sectores*80L/82;  /* no usar primeros 2 cilindros */
      }
    else {                          /* disco estndar */
      monto=nsect;
      sects = stest = sectores - nsect * 4;
      }

  if (sp)
      cprintf("(buffer de %4.1f Kb)\n", 1.0*monto*tsector/1024);
    else
      cprintf("(%4.1f Kb buffer)\n", 1.0*monto*tsector/1024);

  xx=5; yy=wherey();

  outportb (0x43, 0x36);  /* asegurar que cnt0 usa byte bajo-alto */
  outportb (0x40, 0); outportb (0x40, 0);

  ssis = sectores - sects;
  sini=res=0;
  while (sects) {
    if (ssis) {
      if (BMAX/tsector < ssis) ns = BMAX/tsector; else ns=ssis;
      }
    else if (monto<sects) ns=monto; else ns=sects;
    if (kbhit()) if (getch()==27) {
      gotoxy (xx, yy); clreol();
      if (sp) cputs("Abortado por el usuario!");
        else cputs("Aborted by user!");
      goto aborta_io;
      }
    if (res) {
      gotoxy (xx, yy); clreol();
      if (sp)
          cputs("Fallo en el acceso a disco!");
        else
          cputs("Failure on disk access!");
      goto aborta_io;
      }
    gotoxy (xx, yy);
    if (sp) cputs("Sectores "); else cputs("Sectors ");
    cputs (dec5strq(sini));
    if (sp) cputs(" a "); else cputs(" to ");
    cputs (dec5strq(sini+ns-1));
    if ((operacion==RD) || (ssis))
        res = absread  (unidad, ns, sini, buffer);
      else
        res = abswrite (unidad, ns, sini, buffer);
     sini += ns;
     if (ssis) { ssis -= ns; tini=tiempo();} else sects -= ns;
     }
  tfin=tiempo(); fin_io=1;

  bseg=(1L*tsector*stest)/((tfin-tini)/1193180.0);
  gotoxy (1, yy);
  if (sp)
      cprintf("  %7.2f seg =%6.2f Kb/seg [%7.0f bits/seg]\n",
             (tfin-tini)/1193180.0, bseg/1024.0, bseg*8);
    else
      cprintf("  %7.2f sec =%6.2f Kb/sec [%7.0f bits/sec]\n",
             (tfin-tini)/1193180.0, bseg/1024.0, bseg*8);

  aborta_io:
  return (fin_io);
}
