/*============================================================================
 *	D2D/98	- disc to disc copy for IBM-PC/AT compatible machines
 *	EMS support package
 *
 *	Borland-C++ 2.00
 *	Version $Revision: 1.2.1.1 $
 *
 *	Copyright (c) 1987 - 1991, 1998 by
 *		Ulrich Windl
 *		Alte Regensburger Strae 11a
 *		D-93149 Nittenau
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *============================================================================
 *$Id: ems.c'v 1.2.1.1 1998/12/24 22:25:06 UhW Exp $
 *$Log: ems.c'v $
 * Revision 1.2.1.1  1998/12/24  22:25:06  UhW
 * This is the GPL version for the 10th anniversary of D2D.
 *
 * Revision 1.2  1991/11/06  17:17:32  UhW
 * Prepared for use with RCS (co -kv required)
 *
 */
#include	<stdio.h>
#include	<mem.h>
#include	<dos.h>

#include	"ems.h"

#ifdef	DEBUG
extern	int	dbuglevl;
# define	BUG(l)	if ( (l) <= dbuglevl )
#endif

static	char	SCCS_ID[] = "@(#)" __FILE__ " $Revision: 1.2.1.1 $\t" __DATE__ "\t" __TIME__;
static	char	*RCS_ID = "$" "Id: $Id: ems.c'v 1.2.1.1 1998/12/24 22:25:06 UhW Exp $" " $";

/*======== EMS Support ===== EMS Support ===== EMS Support =============*/

static	const char	EMSname[]	= "EMMXXXX0";

/*
 * EMSsetup - return 0 if EMS is available
 */
int	EMSsetup(void)
{
	const char far	*entry;
	union REGS	r;

	entry = *( (char far * far *) MK_FP(0, 4 * 0x67) );
	if ( entry == NULL )
		return(-1);
	entry = (char far *) MK_FP(FP_SEG(entry), 0x0a);
	if ( memcmp(entry, EMSname, sizeof(EMSname) - 1) != 0 )
		return(-1);
	r.x.ax = 0x4000;		/* #1: Get Status */
	int86(0x67, &r, &r);
	if ( r.h.ah != 0 )
		return(-1);
	return(0);
}

/*
 * EMSversion - get the EMM version number
 */
unsigned	EMSversion(unsigned *version)
{
	union REGS	r;

	r.x.ax = 0x4600;	/* #7: Get EMM Version */
	int86(0x67, &r, &r);
	*version = r.h.al;
	return(r.h.ah);
}

/*
 * EMSpageframe - get the segment address of the page frame
 */
unsigned	EMSpageframe(unsigned *pageseg)
{
	union REGS	r;

	r.x.ax = 0x4100;	/* #2: Get Page Frame Address */
	int86(0x67, &r, &r);
	*pageseg = r.x.bx;	/* segment address of the page frame */
#ifdef	DEBUG
	BUG(1)	if ( r.h.ah != 0 )
	{
		fprintf(stderr, "EMS#41: %#02x\n", r.h.ah);
	}
#endif
	return(r.h.ah);
}

/*
 * EMSpagecount - get unallocated page count
 */
unsigned	EMSpagecount(unsigned *available, unsigned *total)
{
	union REGS	r;

	r.x.ax = 0x4200;	/* #3: Get Unallocated Page Count */
	int86(0x67, &r, &r);
	*available = r.x.bx;	/* number of available pages */
	*total = r.x.dx;	/* total number of pages */
#ifdef	DEBUG
	BUG(1)	if ( r.h.ah != 0 )
	{
		fprintf(stderr, "EMS#42: %#02x\n", r.h.ah);
	}
#endif
	return(r.h.ah);
}

/*
 * EMSalloc - allocate pages
 */
unsigned	EMSalloc(unsigned n, unsigned *handle)
{
	union REGS	r;

	r.x.ax = 0x4300;	/* #4: Allocate Pages */
	r.x.bx = n;		/* number of pages to allocate */
	int86(0x67, &r, &r);
	*handle = r.x.dx;	/* handle */
#ifdef	DEBUG
	BUG(1)	if ( r.h.ah != 0 )
	{
		fprintf(stderr, "EMS#43(%u): %#02x\n", n, r.h.ah);
	}
#endif
	return(r.h.ah);
}

/*
 * EMSmap - map page into address space
 */
unsigned	EMSmap(unsigned physp, unsigned logp, unsigned handle)
{
	union REGS	r;

	r.x.ax = physp;		/* physical page into which the logical
				 * page is to be mapped (0-3)
				 */
	r.h.ah = 0x44;		/* #5: Map Handle Page */
	r.x.bx = logp;		/* logical page to be mapped */
	r.x.dx = handle;	/* handle returned from function #4 */
	int86(0x67, &r, &r);
#ifdef	DEBUG
	BUG(1)	if ( r.h.ah != 0 )
	{
		fprintf(stderr, "EMS#44(%u, %u): %#02x\n",
			physp, logp, r.h.ah);
	}
#endif
	return(r.h.ah);
}

/*
 * EMSfree - free pages associated with handle
 */
unsigned	EMSfree(unsigned handle)
{
	union REGS	r;

	r.x.ax = 0x4500;	/* #6: Deallocate Pages */
	r.x.dx = handle;	/* handle returned from function #4 */
	int86(0x67, &r, &r);
#ifdef	DEBUG
	BUG(1)	if ( r.h.ah != 0 )
	{
		fprintf(stderr, "EMS#45: %#02x\n", r.h.ah);
	}
#endif
	return(r.h.ah);
}

/*
 * EMSsetname - set name of handle
 */
unsigned	EMSsetname(unsigned handle, const char *name)
{
	struct REGPACK	r;

	r.r_ax = 0x5301;	/* #20/1: Set Handle Name */
	r.r_dx = handle;
	r.r_si = FP_OFF((void far *) name);
	r.r_ds = FP_SEG((void far *) name);
	intr(0x67, &r);
#ifdef	DEBUG
	BUG(1)	if ( (r.r_ax >> 8) != 0 )
	{
		fprintf(stderr, "EMS#53(%s): %#02x\n", name, r.r_ax >> 8);
	}
#endif
	return(r.r_ax >> 8);	/* return AH */
}

/*======================================================================*/
