/*============================================================================
 *	D2D/98	- disc to disc copy for IBM-PC/AT compatible machines
 *	Header file contains EMS prototypes
 *
 *	Copyright (c) 1987 - 1991, 1998 by
 *		Ulrich Windl
 *		Alte Regensburger Strae 11a
 *		D-93149 Nittenau
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *============================================================================
 *$Id: ems.h'v 1.2.1.1 1998/12/24 22:28:52 UhW Exp $
 *$Log: ems.h'v $
 * Revision 1.2.1.1  1998/12/24  22:28:52  UhW
 * This is the GPL version for the 10th anniversary of D2D.
 *
 * Revision 1.2  1991/11/06  17:01:18  UhW
 * Prepared for use with RCS
 *
 */

/*======== EMS Support ===== EMS Support ===== EMS Support =============*/

/*
 * EMSsetup - return 0 if EMS is available
 */
int	EMSsetup(void);

/*
 * EMSversion - get the EMM version number
 */
unsigned	EMSversion(unsigned *version);

/*
 * EMSpageframe - get the segment address of the page frame
 */
unsigned	EMSpageframe(unsigned *pageseg);

/*
 * EMSpagecount - get unallocated page count
 */
unsigned	EMSpagecount(unsigned *available, unsigned *total);

/*
 * EMSalloc - allocate pages
 */
unsigned	EMSalloc(unsigned n, unsigned *handle);

/*
 * EMSmap - map page into address space
 */
unsigned	EMSmap(unsigned physp, unsigned logp, unsigned handle);

/*
 * EMSfree - free pages associated with handle
 */
unsigned	EMSfree(unsigned handle);

/*
 * EMSsetname - set name of handle
 */
unsigned	EMSsetname(unsigned handle, const char *name);

/*======================================================================*/
