// getpartd.cpp


// read and initialize the partition data
void gpdinit(uchar disk)
	{
	int i;
	uint result;
	uchar far *bufptr;
	int partoffset;
	current_drive = disk;
	partoffset = 0x01be;

	// can't use read_sec(...) here because read_sec(...) depends on
	// data read from the boot area and it hasn't been read yet so the
	// data structures are not correct.
	mydisk.drive = disk;
	mydisk.head = 0;
	mydisk.track = 0;
	mydisk.sector = 1;
	mydisk.nsectors = 1;
	mydisk.buffer = sector_buffer;
	result = _bios_disk( _DISK_READ, &mydisk );

	if( (result & 0xff00) != 0)
		{
		cprintf("\n\rCouldn't read partition sector");
		getch();
		exit(0);
		}
	// the data is in secbuf, 512 bytes.
	// transfer the data of interest to the partition structure part_table[4]
	bufptr = (uchar far *)&hdp;
	for( i = 0 ; i < sizeof(hdp) ; i++ )
		bufptr[i] = sector_buffer[i+partoffset];

	// check for the magic number
	if(hdp.magicnumber != 0xaa55 )
		{
		cprintf("\n\rInvalid Partition table - Magic Number not present");
		getch();
		exit(0);
		}
	// set the active partition
	current_partition = 0xff;
	for( i = 0 ; i < 4 ; i++ )
		{
		if( hdp.hdpart[i].boot_indicator == 0x80 )
			{
			if( current_partition == 0xff )
				current_partition = i;
			else
				{
				cprintf("\n\rInvalid Partition data - more than one active");
				getch();
				exit(0);
				}
			}
		}
	if( current_partition == 0xff )
		{
		cprintf("\n\rNo bootable partition found");
		getch();
		exit(0);
		}
	// transfer the partition data to a structure
	apart.boot_indicator = hdp.hdpart[current_partition].boot_indicator;
	apart.start_head = hdp.hdpart[current_partition].start_head;
	apart.startcylandsector = hdp.hdpart[current_partition].startcylandsector;
	apart.part_type = hdp.hdpart[current_partition].part_type;
	apart.lasthd_partition = hdp.hdpart[current_partition].lasthd_partition;
	apart.endingcylsector = hdp.hdpart[current_partition].endingcylsector;
	apart.sectoroffsettopartition = hdp.hdpart[current_partition].sectoroffsettopartition;
	apart.sectorsinpartition = hdp.hdpart[current_partition].sectorsinpartition;
	}



