/*  mread.c     -- read a file from a Minix file system */
/*  Copyright 1988,1991 Steven W. Harrold - All rights reserved. */
/*  $Header: MREAD.C_V 1.5 91/03/22 07:53:37 SWH Exp $ */

#include    <stdio.h>
#include    <ctype.h>
#include    <stdlib.h>
#include    <string.h>
#include    "mfs.h"
#include    "dev.h"

DEVINIT
READ_BLOCK
GET_INODE
MINIX_TO_DOS


/*==================================================================*/
main (argc, argv)
int     argc ;
char    *argv[] ;
{
    int     drive ;
    char    drid = 'A' ;
    char    *dp = DRIVES ;

    byte    buf[BLOCK_SIZE] ;
    int     blkno ;
    struct super_block  sblk ;

    struct inode    *iarea, *ip ;
    int     inode_blkno ;
    int     inode_blkct ;
    int     inode_count ;

    struct directory    *darea ;
    struct devdata      *ddata ;

    int     i, j, k, n ;
    char    *path[MAX_PATH/2+1] ;
    BOOL    text = FALSE ;
    FILE    *outfd ;
    char    *tp ;
    char    minixfn[MAX_PATH+NAME_SIZE+2] ;


    printf ("**** Copies a file from a Minix system to MS-DOS ****\n") ;
    printf ("\n") ;

/*  Does he want help?
 */
    if ((argc >= 2) && (argv[1][0] == '-') && (argv[1][1] == '?'))
    {
printf ("Copyright 1988,1991 Steven W. Harrold - All rights reserved\n") ;
        printf ("Version %s\n", VERSION) ;
        printf ("Usage:   %s  [-a] [drid:]minixfn dosfn\n", argv[0]) ;
        printf ("'-a' translates LF to CRLF, binary otherwise\n") ;
        printf ("'drid' is a letter from the set [a-z], default: 'a'\n") ;
        printf ("'minixfn' is a fully qualified Minix filename\n") ;
        printf ("'dosfn' is standard DOS filename\n") ;
        exit (0) ;
    }

/*  Get the option flag
 */
    if ((argc >= 2) && (argv[1][0] == '-') && (argv[1][1] == 'a'))
    {
        text = TRUE ;
        argc-- ;
        argv++ ;
    }
    else
        text = FALSE ;

/*  Fetch the Minix drive identifier
 */
    if (argc != 3)
    {
        fprintf (stderr, "Must supply both Minix and DOS filenames\n") ;
        exit (2) ;
    }

    if (argv[1][1] == ':')
    {
        drid = toupper(argv[1][0]) ;
        if ((drid < 'A') || (drid > 'Z'))
            drid = 'A' ;
        argv[1] += 2 ;
    }
    drive = strchr (dp, drid) - dp ;
    ddata = devinit (drive, 0) ;
    if (!ddata)
    {
        printf ("Cannot initialize device 0x%02X, Dstatus=%d\n",
                drive, Dstatus) ;
        exit (2) ;
    }

/*  Break Minix filename into path components
 */
    if (argv[1][0] != '/')
    {
        fprintf (stderr,
                "You must supply a fully qualified Minix filename\n") ;
        exit (2) ;
    }
    strcpy (minixfn, argv[1]) ;

    tp = strtok (&argv[1][1], "/") ;
    i = 0 ;
    while (tp)
    {
        path[i++] = tp ;
        tp = strtok (NULL, "/") ;
    }
    path[i] = NULL ;

/*  The super block
 */
    blkno = SUPER_BLOCK ;
    read_block (buf, blkno, ddata) ;
    memcpy (&sblk, buf, sizeof(sblk)) ;

    if ((sblk.s_magic != SUPER_MAGIC)   ||
        (sblk.s_ninodes < 1)            ||
        (sblk.s_nzones < 1)             ||
        (sblk.s_imap_blocks < 1)        ||
        (sblk.s_zmap_blocks < 1)        )
    {
        fprintf (stderr, "+++++++++++++++++++++++++++++++++++++++\n") ;
        fprintf (stderr, "+++ THIS IS NOT A PROPER MINIX DISK +++\n") ;
        fprintf (stderr, "+++++++++++++++++++++++++++++++++++++++\n") ;
        exit (2) ;
    }

/*  The i-node blocks
 */
    inode_blkno = SUPER_BLOCK + sblk.s_imap_blocks +
                                sblk.s_zmap_blocks + 1 ;
    inode_blkct = sblk.s_ninodes * sizeof(struct inode) + (BLOCK_SIZE-1) ;
    inode_blkct /= BLOCK_SIZE ;
    inode_count = inode_blkct * sizeof(struct inode) ;

    iarea = calloc (inode_count+1, sizeof(struct inode)) ;
    if (!iarea)
        exit(3) ;

    ip = iarea + 1 ;
    blkno = inode_blkno ;
    j = BLOCK_SIZE / sizeof(struct inode) ;

    for (i=1; i<=inode_blkct; i++, ip += j, blkno++)
        read_block (ip, blkno, ddata) ;

/*  Now, the inode search through the directories
 */
    ip = iarea + ROOT_INODE ;                   /* start with root */
    ip = get_inode(ddata, iarea, ip, path) ;    /* recursively scan */

    if (!ip)
    {
        fprintf (stderr, "Cannot locate Minix file '%s'\n", minixfn) ;
        exit (1) ;
    }

    if (!(ip->i_mode & I_REGULAR))
    {
        fprintf (stderr, "Minix file '%s' is not a regular file\n",
                         minixfn) ;
        exit(1) ;
    }

/*  Finally, copy the file to DOS-land
 */
    if ((outfd=fopen(argv[2], "wb")) == NULL)
    {
        fprintf (stderr, "Cannot open DOS file '%s' due to\n", argv[2]) ;
        perror (NULL) ;
        exit (1) ;
    }

    minix_to_dos(text, ip, ddata, outfd) ;
    fclose (outfd) ;

/*  Clean up
 */
    free (iarea) ;

} /* main() */


/*---eof---*/
