 ' Findit13 is v1.3a of a findfile function for QB v4.5 which
 ' emulates a DIR$ function similar to the DIR$ function of BC7.

 DECLARE FUNCTION DIR$ (FileSpec$, Bits)

 ' get include files.
 REM $INCLUDE: 'dta.bi'
 REM $INCLUDE: 'qb.bi'

 ' common error trap variable
 COMMON SHARED Disk.Ready AS INTEGER

 ' prompt for filespec.
 COLOR 15
 PRINT "Enter filespec:";
 LINE INPUT f$

 ' start filefind.
 x$ = DIR$(f$, b)
 Count = 0
 DO
    ' compare result.
    IF x$ = "" THEN
       EXIT DO
    END IF

    ' count files
    Count = Count + 1
    IF Count > 23 THEN
       Count = 0
       COLOR 13
       PRINT "-more-";
       WHILE INKEY$ = ""
       WEND
       PRINT
    END IF

    ' display file.
    COLOR 15
    PRINT x$;

    ' check for read-only file
    IF (b AND &H1) = &H1 THEN
       COLOR 14
       PRINT " Read-only";
    END IF

    ' check for hidden file
    IF (b AND &H2) = &H2 THEN
       COLOR 14
       PRINT " Hidden";
    END IF

    ' check for system file
    IF (b AND &H4) = &H4 THEN
       COLOR 14
       PRINT " System";
    END IF

    ' check for directory file
    IF (b AND &H10) = &H10 THEN
       COLOR 10
       PRINT " Directory";
    END IF

    ' check for archive file
    IF (b AND &H20) = &H20 THEN
       COLOR 14
       PRINT " Archive";
    END IF
    PRINT

    ' continue filefind.
    x$ = DIR$("", b)
 LOOP
 COLOR 7
 END

' simple error routine
ModuleError:
 ' path not found
 IF ERR = 76 THEN
    Disk.Ready = 76
    RESUME NEXT
 END IF
 ' disk not ready
 IF ERR = 71 THEN
    Disk.Ready = 71
    RESUME NEXT
 END IF
 ' device I/O error
 IF ERR = 57 THEN
    Disk.Ready = 57
    RESUME NEXT
 END IF
 END

FUNCTION DIR$ (FileSpec$, Bits) STATIC
 ' define simple error routine
 ON ERROR GOTO ModuleError

 ' first call to function with a filespec starts filelist match,
 ' second and following calls to function with Null string return remaining
 ' filelist matches until DIR$ returns a Null value. Returns the bit
 ' attribute of the file. Function is Static to preserve variables
 ' between calls. DTA structure is used to store the search parameters.
 ' Also checks validity of drive letter. Also checks if disk not ready.

 DIM InregsX AS RegTypeX
 DIM OutregsX AS RegTypeX
 DIM DTAfile AS DTAtype
 DIM ASCIIZ AS STRING * 64
 DIM ASCIIZ2 AS STRING * 64
 DIM Current.DTA.SEG AS INTEGER
 DIM Current.DTA.OFF AS INTEGER

 IF FileSpec$ = "" THEN
    GOSUB FindNext
 ELSE
    GOSUB CheckDrive
    ASCIIZ = UCASE$(FileSpec$) + CHR$(0)
    GOSUB FindFirst
 END IF
 DIR$ = Filename$
 EXIT FUNCTION

' initate findfile.
FindFirst:
 ' store current dta
 InregsX.AX = &H2F00
 CALL InterruptX(&H21, InregsX, OutregsX)
 Current.DTA.SEG = OutregsX.ES
 Current.DTA.OFF = OutregsX.BX

 ' store function dta
 InregsX.AX = &H1A00
 InregsX.DS = VARSEG(DTAfile)
 InregsX.DX = VARPTR(DTAfile)
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' findfirst
 InregsX.AX = &H4E00
 InregsX.CX = &H37
 InregsX.DS = VARSEG(ASCIIZ)
 InregsX.DX = VARPTR(ASCIIZ)
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' check carry flag error
 IF (OutregsX.flags AND &H1) = &H0 THEN
    ' store filename attribute bits
    Bits = ASC(DTAfile.Filebits)
    ' strip filename from ASCIIZ
    Filename$ = DTAfile.ASCIIZfilename
    Filename$ = LEFT$(Filename$, INSTR(Filename$, CHR$(0)) - 1)
 ELSE
    Bits = 0
    Filename$ = ""
 END IF

 ' restore current dta
 InregsX.AX = &H1A00
 InregsX.DS = Current.DTA.SEG
 InregsX.DX = Current.DTA.OFF
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN

' continue filespec match.
FindNext:
 ' store current dta
 InregsX.AX = &H2F00
 CALL InterruptX(&H21, InregsX, OutregsX)
 Current.DTA.SEG = OutregsX.ES
 Current.DTA.OFF = OutregsX.BX

 ' store function dta
 InregsX.AX = &H1A00
 InregsX.DS = VARSEG(DTAfile)
 InregsX.DX = VARPTR(DTAfile)
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' find next filename
 InregsX.AX = &H4F00
 CALL InterruptX(&H21, InregsX, OutregsX)

 ' check carry flag error
 IF (OutregsX.flags AND &H1) = &H0 THEN
    ' store filename attribute bits
    Bits = ASC(DTAfile.Filebits)
    ' strip filename from ASCIIZ
    Filename$ = DTAfile.ASCIIZfilename
    Filename$ = LEFT$(Filename$, INSTR(Filename$, CHR$(0)) - 1)
 ELSE
    Bits = 0
    Filename$ = ""
 END IF

 ' restore current dta
 InregsX.AX = &H1A00
 InregsX.DS = Current.DTA.SEG
 InregsX.DX = Current.DTA.OFF
 CALL InterruptX(&H21, InregsX, OutregsX)
 RETURN

' check drive.
CheckDrive:
 Disk.Ready = 0
 IF MID$(Filespec$, 2, 1) = ":" THEN
    GOSUB StoreDrive
    Z$ = LEFT$(Filespec$, 1) + ":\"
    CHDIR Z$
    IF Disk.Ready THEN
       DIR$ = ""
       EXIT FUNCTION
    END IF
    CHDIR DefaultDir$
 END IF
 RETURN

' store current drive/directory.
StoreDrive:
 InregsX.AX = &H1900
 CALL InterruptX(&H21, InregsX, OutregsX)
 Drive.Number = OutregsX.AX AND &HFF
 InregsX.AX = &H4700
 InregsX.DX = Drive.Number + 1
 InregsX.DS = VARSEG(ASCIIZ2)
 InregsX.SI = VARPTR(ASCIIZ2)
 CALL InterruptX(&H21, InregsX, OutregsX)
 DefaultDir$ = LEFT$(ASCIIZ2, INSTR(ASCIIZ2, CHR$(0)) - 1)
 IF LEFT$(DefaultDir$, 1) <> "\" THEN
    DefaultDir$ = "\" + DefaultDir$
 END IF
 RETURN
END FUNCTION

