/* Copyright (C) Stephen Chung, 1991-1992.  All rights reserved. */

#include <windows.h>
#include "toolbar.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mem.h>
#include <dos.h>
#include <io.h>
#include <time.h>


#define CTL3D           /* 3D Dialog Boxes */

/* Macros */

#define KANJI           unsigned short int

#define MAGIC           0x42022667L

#define JWPFILEVERSION  "B2"

#define NRSUMMARIES     5
#define NRHEADERS       3

#define MAXLINELEN      512                 /* General length of a line */
#define MAXFILENAMELEN  120                 /* General length of filenames */
#define BUFSIZE         1024                /* General buffer for things */
#define TEXTBLOCKSIZE   256                 /* One unit of text */
#define UNDOTEXTSIZE    16                  /* One unit of undo text */
#define MAXFILES        10                  /* Maximum number of files opened */
#define MAXGLOSSARY     500                 /* Maximum number of glossaries */
#define PROGNAME        "JWP"               /* Name of the program */
#define NAMELEN         40                  /* General length for names */
#define BLOCKSIZE       10240L              /* Optimal memory page size */
#define C64K            (60L * 1024L)       /* 64K Blocks */
#define CPOSPAGESIZE    BLOCKSIZE           /* Page size for the CPOS array */

#define BADKANJI        0x2223              /* Black square */

#define ISASCII(x)      ((HIBYTE(x) & 0x7f) == 0)
#define ISKANJI(x)      ((HIBYTE(x) & 0x7f) != 0)
#define KANJIAT(x,y)    ISKANJI(CHAROF(x,y))
#define KANJIPOS(x)     KANJIAT(x,POSOF(x))

#define BASEFONT        (global.basefont)
#define PRINTFONT       (global.printfont)
#define SYSFONT         (global.sysfont)

#define LINEGAP(x)      ((x)->spacing / 2)
#define CHARGAP(x)      ((x)->leading / 2)

#define BlockAlloc(x)   SegHeapAlloc(x)
#define BlockRealloc(x, n) SegHeapRealloc(x, n)
#define FreeBlock(x)    SegHeapFree(x)

#define StructAlloc(x)  ((x far *) SegHeapAlloc(sizeof(x)))
#define FreeStruct(x)   SegHeapFree(x)

#define MemAlloc(x)     MyLocalAlloc(x)
#define FreeMem(x)      LocalFree(x)

#define PARAOF(x)       ((x).para)
#define LINEOF(x)       ((x).line)
#define POSOF(x)        ((x).pos)
#define UNITOF(x,y)     (PARAOF(x)->text[LINEOF(x)->position + y])
#define CHAROF(x,y)     UNITOF(x,y).kanji
#define FORMATOF(x,y)   UNITOF(x,y).format
#define POS2ABS(x)      (LINEOF(x)->position + POSOF(x))

#define TOPPARA(x)      PARAOF((x)->top)
#define TOPLINE(x)      LINEOF((x)->top)
#define CURPARA(x)      PARAOF((x)->current)
#define CURLINE(x)      LINEOF((x)->current)
#define CURCHAR(x)      POSOF((x)->current)

#define CURX(f)         ((f)->cursor.x)
#define CURY(f)         ((f)->cursor.y)
#define PSEUDOX(f)      ((f)->pseudo.x)
#define PSEUDOY(f)      ((f)->pseudo.y)

#define SELNOW(x)       ((x)->sel.now)
#define SEL1(x)         ((x)->sel.pos1)
#define SEL2(x)         ((x)->sel.pos2)
#define SELPARA1(x)     PARAOF(SEL1(x))
#define SELPARA2(x)     PARAOF(SEL2(x))
#define SELPOS1(x)      POSOF((x)->sel.pos1)
#define SELPOS2(x)      POSOF((x)->sel.pos2)
#define SELCHAR1(x)     (SELPARA1(x)->text[SELPOS1(x)])
#define SELCHAR2(x)     (SELPARA2(x)->text[SELPOS2(x)])
#define SELTYPE(x)      ((x)->sel.type)

#define RULER(x)        ((x)->ruler)
#define BASEWIDTH(x)    ((x)->basefont->width + (x)->leading)

#define RULERHEIGHT     (2 * AVGHEIGHT)
#define BORDERSPACE     (global.borderspace)
#define AVGWIDTH        (global.textmetric.tmAveCharWidth)
#define AVGHEIGHT       (global.textmetric.tmHeight + global.textmetric.tmExternalLeading)

#define STATUSHEIGHT    (AVGHEIGHT * 1.3)

#define TBBORDER		6
#define TBICONHEIGHT    24
#define TBICONWIDTH     24
#define TBHEIGHT        (TBICONHEIGHT + 2 * BORDERSPACE)

#define POS2PIXEL(x)    (BORDERSPACE + (x) * BASEWIDTH(f) - f->startx)
#define LEFTMARGIN(x)   ((LINEOF(x)->prev == NULL) ? PARAOF(x)->firstindent : PARAOF(x)->leftindent)
#define NEXTLINE(x)     Skip(&(x), 1)
#define PREVLINE(x)     Skip(&(x), -1)



/* Type definitions */

#define OP_MOVESEL          0x0001          /* Options for ReformatParagraph */
#define OP_UPDATE           0x0002
#define OP_MOVETOEND        0x0004
#define OP_REFORMAT         0x0008
#define OP_SAMELEN          0x0010
#define OP_MINIMAL          0x0020
#define OP_WITHFORMAT       0x0040
#define OP_CHOOSEKANJI      0x0080

#define FN_NORMAL           0x0001          /* Normal file */
#define FN_CLIPBOARD        0x0002          /* Clipboard */
#define FN_CONTROL          0x0004          /* A Japanese edit control */
#define FN_NOSWITCHING      0x0008          /* No mode switching at all times */
#define FN_EITHER           0x0010          /* Either ASCII or Japanese */
#define FN_NOKANJI          0x0020          /* No Kanji allowed */
#define FN_NOEDIT			0x0040			/* No editing allowed */
#define FN_NOSCROLLBARS		0x0080			/* Do not display scrollbars */


typedef enum { SEL_CONVERSION, SEL_SELECTION } SELTYPE;

typedef enum { M_KANA, M_ASCII } INPUTMODE;

typedef enum {
    UN_INSERT, UN_DELETE, UN_INDENT, UN_SPLITLINE, UN_JOINLINE
} EDITACTION;

typedef enum {
    J_LEFT, J_RIGHT, J_CENTER, J_JUSTIFY
} JUSTIFICATION;

typedef enum {
    U_INSERT, U_DELETE, U_REPLACE, U_PARAFORMAT
} UNDOACTIONS;

typedef enum {
    M_INCHES =  0,
    M_CM =      1,
    M_MM =      2,
    M_POINTS =  3,
    M_PIXELS =  4
} MEASUREMENT;

typedef struct {
    char *name;
    char *symbol;
    int decimal;
    double conversion;
} MEASUREINFO;

typedef enum {
    FF_UNKNOWN =  0,
    FF_NORMAL =   1,
    FF_TEMPLATE = 2,
    FF_EUC =      3,
    FF_SJIS =     4,
    FF_NEWJIS =   5,
    FF_OLDJIS =   6,
    FF_NEC =      7
} FILEFORMAT;


typedef struct UndoBufStruct {
    int para1, start;
    int para2, stop;
    time_t time;
	UNDOACTIONS action;
    KANJI far *data;
    struct UndoBufStruct far *next, far *prev;
} UNDOBUF;


typedef struct {                    /* The header for JWP's native format */
    unsigned long int magic;        /* Magic identifier */
    char version[6];                /* Version number */
    unsigned int paragraphs;        /* Number of paragraphs */
    float margins[4];               /* Left/Right/Top/Bottom margins, in inches */

    int landscape:1;                /* Landscape printing */
    int summary:1;                  /* File summary exists */
    int headers:1;                  /* Has header / footer */
    int lrheader:1;                 /* Separate Left/Right pages in header/footer? */
    int nofirstpage:1;              /* Don't print header/footer on first page? */
    unsigned int undo;              /* Number of undo levels */
    char extra[97];                 /* Make it up to 128 bytes */
} FILEHEADER;


typedef struct {
    unsigned int textsize;          /* Number of characters in this paragraph */
    unsigned int firstindent;       /* Indentations */
    unsigned int leftindent;
    unsigned int rightindent;
} OLDFILEPARAHEADER100;


typedef struct {
    unsigned int textsize;          /* Number of characters in this paragraph */
    unsigned int spacemulti;        /* Spacing, x 100 */
    unsigned char firstindent;      /* Indentations */
    unsigned char leftindent;
    unsigned char rightindent;
    unsigned char extra[9];         /* Pad it to 16 byte */
} FILEPARAHEADER;


typedef struct {
    KANJI facename[NAMELEN/2];      /* Font family name */
    int width, height;              /* Width and height in pixels */
    int charsize;                   /* Number of bytes that make up a character */
    int verticals;                  /* The number of extra "vertical" characters */
    long int offset;                /* Byte offset to the beginning of bitmaps */
    BOOL holes;                     /* Packed JIS coding or 93x93 with holes */
    int leading, spacing;           /* Horizontal / Vertical gaps */
    char extra[6];                  /* Make it up to 64 bytes */
} FONTHEADER;


typedef struct {                    /* A kanji font that has been loaded */
    KANJI *facename;                /* Name of the font family */
    char *filename;                 /* Filename of the font */
    OFSTRUCT of;                    /* File open structure */
    int width, height;              /* Width and height in pixels */
    int leading, spacing;           /* Horizontal / Vertical gaps */
    int bmsize;                     /* Number of bytes per character */
    int verticals;                  /* Number of extra "vertical" characters */
    int offset;                     /* Byte offset to the beginning of bitmaps in the font file */
    BOOL holes;                     /* Packed JIS coding or 93x93 with holes */
} KANJIFONT;


typedef struct {                    /* An ASCII font */
    char *facename;                 /* Name of font family */
    double size;                    /* Font height (in points) */
    TEXTMETRIC textmetric;          /* Font text metrics */
    HFONT hfont;                    /* Font handle */
} ASCIIFONT;


typedef union {                     /* Special format of a character */
    int width;                      
} CHARFORMAT;


typedef struct {                    /* One character */
    KANJI kanji;                    /* The kanji */
    //CHARFORMAT far *format;       /* Format */
} UNIT;


typedef struct oneline {            /* A linked list of lines */
    int position;                   /* The first UNIT of the line */
	int height;                     /* Height of the line, in pixels */
	int width;                      /* Width of the line, in pixels */
    int length;                     /* Number of characters */
    struct oneline far *next;       /* Links */
	struct oneline far *prev;
} ONELINE;


typedef struct paragraph {          /* A linked list of paragraphs */
    int         leftindent;         /* Margin indents, in characters */
	int         rightindent;
	int         firstindent;
    int         spacing;            /* Line spacing */
    int         spacemulti;         /* Multiple for line spacing, x 100 */
    ONELINE     far *lines;         /* Beginning of the lines list */
    ONELINE     far *lastline;      /* Line breaks */
    UNIT        far *text;          /* The actual text */
    unsigned int textsize;          /* Allocated space for text */
	struct paragraph far *next;     /* Links */
	struct paragraph far *prev;
} PARAGRAPH;


typedef struct {
    HWND hwnd;                          /* Window handle */
    int upperrow, lowerrow, middlerow;  /* Position (in pixels) of the bar */
    int bigticks, smallticks, pointer;  /* Sizes (in pixels) */
    int startx, left, right, first;     /* Margin positions (in characters) */
    int leftpos, rightpos, firstpos;    /* Margin positions (in pizels) */
} FILERULER;


typedef struct {                    /* For selections, the "line" field      */
    PARAGRAPH far *para;            /* is ignored.  The "pos" field contains */
    ONELINE far *line;              /* the offset from the beginning of the  */
    int pos;                        /* paragraph */
} POSITION;


typedef struct {
    POSITION pos1, pos2;            /* Block start and end positions */
    BOOL now;                       /* In the middle of a conversion? */
    SELTYPE type;                   /* Type of block: conversion or selection */
} SELECTION;


typedef struct {
    double margins[4];              /* Top/Bottom/Left/Right margins */
    BOOL landscape;                 /* Landscape printing */
} PAGESETUP;


typedef struct FileOptionsStruct {
    int type;                       /* 0 = Normal File; 1 = Dialog Edit */
    char filename[MAXFILENAMELEN];  /* Name of the file being edited */
	FILEFORMAT fileformat;          /* Input file-format */
    long int nr_bytes;              /* Length of the file */
    HWND parent;                    /* Window handle of the frame window */
    HWND hwnd;                      /* Window handle */
    HDC hdc;                        /* Is there an hdc active for this window? */
    FILERULER ruler;                /* The ruler */
    SELECTION sel;                  /* Selected block */
    PAGESETUP pagesetup;            /* Page setup parameters */
    UNDOBUF far *undo;              /* The undo buffer */
    UNDOBUF far *undotail;
    int undolevels;                 /* Number of undo's for this file */
    UNDOBUF far *redo;              /* The redo chain */
    UNDOBUF far *redotail;
    KANJI far *summary[NRSUMMARIES];/* Summary info: Title, Subject, Author, Keywords, Comments */
    KANJI far *header[4][NRHEADERS];/* Header/Footer: Left/Right Page: Left, Center, Right */
    BOOL lrheader;                  /* Separate Left/Right pages in header/footer? */
    BOOL nofirstpage;               /* No header/footer on first page? */
    KANJIFONT *basefont;            /* The base font for this window */
    int width, height;              /* Width and height (in pixels) of the window */
    int leading;                    /* Number of pixels between kanji's */
    int spacing;                    /* Number of pixels between lines */
    int nr_lines;                   /* Total number of lines in the file */
    PARAGRAPH far *paragraph;       /* Pointer to the first paragraph of the file */
    PARAGRAPH far *eof;             /* Pointer to the last paragraph of the file */
	POSITION current;               /* Current cursor position */
    POSITION top;                   /* Line on the top of the screen */
    int startx;                     /* The starting left position (in pixels) */
    int linelen;                    /* Total length of a line, in characters */
    int vscroll, hscroll;           /* Scroll-bar positions */
    POINT pseudo;                   /* Pseudo position of cursor */
    POINT cursor;                   /* Current cursor pixel position */
    BOOL caret;                     /* Caret visible? */
    BOOL relaxmargin;               /* Relax right margin? */
    BOOL changed;                   /* File changed? */

	struct FileOptionsStruct *next; /* Link */
} FILEOPTIONS;


typedef struct {
	FILEOPTIONS *active;            /* Pointer to the active file */
    INPUTMODE mode;                 /* Either M_KANA or M_ASCII */
    TEXTMETRIC textmetric;          /* Text metrics of the system font */
    int convsel;                    /* The item in the kanji list being selected */
    int borderspace;                /* Default amount of border (in pixels) */

    KANJIFONT *sysfont;             /* The system Kanji font */
    KANJIFONT *basefont;            /* The base Kanji font */
    KANJIFONT *printfont;           /* The base print font */
    int nr_fonts;                   /* Number of installed kanji fonts */

    int leading;                    /* Number of pixels between kanji's */
    int spacing;                    /* Number of pixels between lines */

    char *printer;                  /* Name of the printer */
    POINT resolution;               /* The dpi of the printer */
    POINT printable;                /* The printable area of the printer */
    double dispscale;               /* The ratio of screen : printer */
    double printscale;              /* The scale factor of printing font */
    double paper[2];                /* Paper size, in inches */
    MEASUREMENT measure;            /* Measurement units */
    PAGESETUP pagesetup;            /* Page setup */

    char *jwppath;                  /* Pathname of the JWP directory */
    char *help;                     /* Pathname of the JWP help file */
    char *convdict;                 /* Filename of the conversion dictionary */
    char *convidx;                  /* Filename of the conversion dictionary index */
    char *userdict;                 /* Filename of the user conversion dictionary */
    char *convcache;                /* Filename of the conversion cache */
    char *jdict;                    /* Filename of the Japanese-English dictionary */
    char *jdictidx;                 /* Filename of the J-E dictionary index */
    char *kinfo;                    /* Filename of the Kanji info file */
    char *kinfoidx;                 /* Filename of the Kanji info index */
    char *glossary;                 /* Filename of the global glossary */

	FARPROC convdlg;                /* Modeless dialog boxes */
    FARPROC gloslistdlg;

    POINT far *cpos;                /* Screen positions for the current paragraph */
    PARAGRAPH far *cpospara;        /* Current paragraph being tracked */
    int cposcount;                  /* Number of characters in the current paragraph */
    unsigned int cpossize;          /* Number of characters allocated in array */

    HWND hwnd;                      /* Main window handle */
	HWND tbhwnd;                    /* Toolbar window handle */
    HWND fonthwnd;                  /* Font list window handle */
    HWND clienthwnd;                /* Frame window handle */
    HWND glisthwnd;                 /* Glossary list handle */
	HWND convhwnd;                  /* Kanji list window handle */
    HWND statushwnd;                /* Status bar window handle */

                                    /* The following are options... */

    RECT glistsize;                 /* Size and position of the glossary list */
    RECT convbar;                   /* Size and position of the conversion bar */
    FILEFORMAT clipboard;           /* Clipboard format */
    int undolevels;                 /* Number of undo levels */
    int saveundolevels;             /* Number of undo levels to save */
    int listposition;               /* 0 = floating, 1 = top, 2 = bottom */
    int glistbehaviour;             /* 0 = remains, 1 = disappears */
    JUSTIFICATION longjust;         /* Justification for long text */
    JUSTIFICATION shortjust;        /* Justification for long text */

    BOOL relaxmargin;               /* Relax the right margin on small hiragana's? */
	BOOL dynamicconvert;            /* Automatically convert when hopeless? */
    BOOL dynamicglossary;           /* Check glossary dynamically? */
    BOOL glistvisible;              /* Is the glossary list visible? */
    BOOL showspecial;               /* Show special symbols */
    BOOL showruler;                 /* Show the ruler in file windows */
    BOOL showstatus;                /* Show the status bar */
    BOOL showribbon;                /* Show the toolbar */
    BOOL draftview;                 /* Show the draft view */
    BOOL ctl3d;                     /* 3D dialog boxes */
    BOOL nnconvert;                 /* Convert nn into n' n */
} GLOBALOPTIONS;



/* Global variables */

extern GLOBALOPTIONS global;
extern FILEOPTIONS *fileoptions;
extern FILEOPTIONS *curfile;
extern KANJIFONT *InstalledFonts;
extern KANJIFONT *DefKanjiFont;
extern KANJIFONT *DefPrintFont;
extern ASCIIFONT DefAsciiFont;
extern HANDLE hInstance;
extern KANJI kanji_list[];
extern BYTE LastConvKey[];
extern HMENU hmenu;
extern FILEFORMAT FileFormats[];
extern char *FileFormatNames[];
extern char *FileExtensions[];
extern BOOL OptionsChanged;
extern BOOL Dialogs3D;
extern MEASUREINFO Measurements[];


/* Global functions */

extern int  GetKanjiBitmap (KANJIFONT *, int, BYTE far * *);
extern void DisplayKanjiBitmap (HDC, int, int, int, int, int, DWORD, BYTE far *);
extern int OpenFont(char *, KANJIFONT *);
extern FILEOPTIONS *NewFile (int, BOOL);
extern void ShowFileWindow (char *, FILEOPTIONS *);
extern void ErrorMessage (HWND, char *, ...);
extern int  Confirmation (HWND, char *, ...);
extern BOOL RetryMessage (char *, ...);
extern int  InitFonts (void);
extern void DisplayRuler (FILEOPTIONS *, BOOL);
extern int  Skip (POSITION *, int);
extern DWORD GetDimension (FILEOPTIONS *, POSITION, int);
extern int  FontCharWidth (int, int);
extern int  CalcLength (FILEOPTIONS *, POSITION *);
extern void SetReformatProc (BOOL (*f_pf)(FILEOPTIONS *, PARAGRAPH far *, int));
extern void ReformatParagraph (FILEOPTIONS *, POSITION, PARAGRAPH far *, int);
extern void FindScrollPos (FILEOPTIONS *);
extern void SetHorzScroll (FILEOPTIONS *);
extern BOOL CharInput (FILEOPTIONS *, WORD);
extern void MoveIntoWindow (FILEOPTIONS *);
extern BOOL FindCaret (FILEOPTIONS *, BOOL);
extern void DoCaret (FILEOPTIONS *, int, int, BOOL);
extern int  Jis2Index (KANJI, BOOL);
extern BOOL IsSmallKana (KANJI);
extern void EnableNullPointers (BOOL);
extern void far *SegHeapAlloc (unsigned int);
extern void SegHeapFree (void far *);
extern void far *SegHeapRealloc (void far *, unsigned int);
extern unsigned int SegHeapGetSize (void far *);
extern void FreeAllMemory (void);
extern void *MyLocalAlloc (unsigned int);
extern int  InitConversion (void);
extern int  kanjilen (KANJI far *);
extern int  unitlen (UNIT far *);
extern int  kanjicmp (KANJI far *, KANJI far *);
extern int  kanjincmp (KANJI far *, KANJI far *, int);
extern int  bytecmp (BYTE far *, BYTE far *);
extern int  bytencmp (BYTE far *, BYTE far *, int);
extern KANJI far *kanjicpy (KANJI far *, KANJI far *);
extern KANJI far *kanjicat (KANJI far *, KANJI far *);
extern char *ReverseKana (KANJI);
extern void StatusMessage (char *);
extern void InsertString (FILEOPTIONS *, POSITION, KANJI far *, int);
extern void DeleteString (FILEOPTIONS *, POSITION, int, int);
extern void ReplaceString (FILEOPTIONS *, POSITION, int, KANJI far *, int);
extern void FlipHighlight (FILEOPTIONS *);
extern BOOL MergeKanjiLists (KANJI *, KANJI *);
extern int  FindConversion (KANJI *, KANJI *);
extern void ReallocateText (POSITION, unsigned int);
extern void PutIntoConvCache (BYTE far *, KANJI far *);
extern int ConvCacheLookup (BYTE far *, KANJI far *);
extern void FontCacheStatistics (int *, long int *, long int *, long int *);
extern void ConvCacheStatistics (long int *, long int *, long int *);
extern void CountMemoryUsage (long int *, long int *, long int *);
extern BOOL DoFileOpen (char *);
extern BOOL DoFileSaveAs (BOOL);
extern void SetupIO (int (* in)(void), void (* out)(int));
extern FILEFORMAT DetectCodeType(void);
extern void FileImport (FILEFORMAT);
extern void FileExport (FILEFORMAT);
extern void NewParagraph (FILEOPTIONS *, POSITION *, unsigned int n);
extern int AllignKanjiBitmap (BYTE far *, BYTE far *, int, int);
extern void CloseFile (FILEOPTIONS *);
extern void DrawBoundingBox (HWND, HDC, int);
extern LONG JlistProc (HWND, WORD, WORD, LONG, BOOL, KANJI far * (* Convert)(int, LONG, KANJI *));
extern void CenterDialogBox (HWND);
extern WORD DecodeKeyStroke (WORD, WORD, BOOL, BOOL);
extern BOOL ReadProgramSizeOptions (int *, int *, int *, int *);
extern void ReadOptionsFile (void);
extern void WriteOptionsFile (BOOL);
extern void ReadGlossary (char *);
extern void WriteGlossary (char *);
extern void ProcessMenuTexts (void);
extern int SearchGlossary (KANJI far *);
extern KANJI far *GetGlossary (int);
extern void FillCPos (FILEOPTIONS *, PARAGRAPH far *, int, int);
extern BOOL InSelection (FILEOPTIONS *, POSITION);
extern void WriteConversionCache (char *);
extern void WriteUserConversions (char *);
extern void ReadConversionCache (char *);
extern HANDLE GetCBData (int);
extern void ClearCBData (void);
extern void CopyToClipboard (FILEOPTIONS *);
extern LONG ProcessClipboardMessage (HWND, WORD, WORD, LONG);
extern void InsertFromClipboard (FILEOPTIONS *);
extern void BlockDelete (FILEOPTIONS *, POSITION, POSITION);
extern void BlockReplace (FILEOPTIONS *, POSITION, POSITION, KANJI far *);
extern void RecordAction (EDITACTION, ...);
extern KANJI TranslateJAscii (KANJI, BOOL);
extern void TurnOffSelection (FILEOPTIONS *);
extern void RedrawFile (FILEOPTIONS *, HDC, int, int, RECT far *, BOOL);
extern void ToggleInputMode (void);
extern void TakeCareOfThings (FILEOPTIONS *, BOOL);
extern void DoSearch (void);
extern void DoReplace (void);
extern void ConvertNow (FILEOPTIONS *, BOOL);
extern void SetKanjiInfoChar (KANJI);
extern void RecordAnchor (FILEOPTIONS *, POSITION, POINT);
extern void ChangeAnchor (int, int);
extern int RelativePosition (POSITION, POSITION, BOOL);
extern void DropAnchor (FILEOPTIONS *, POSITION, POINT, int);
extern void ExtendSelection (HWND, FILEOPTIONS *);
extern void Triangles (FILEOPTIONS *);
extern void ReformatFile (FILEOPTIONS *);
extern void EnableFontCache (BOOL);
extern void AbsoluteToPosition (POSITION, POSITION *);
extern void ResetClipboard (void);
extern void SwitchMenu (int);
extern char *DupString (char *);
extern BOOL SetupPrinter (BOOL);
extern void InitPrinting (void);
extern HDC GetPrinterDC(BOOL, char *);
extern MEASUREMENT FindMeasurement (char *, MEASUREMENT);
extern int CalcLineLength (FILEOPTIONS *);
extern void StartPrinting (FILEOPTIONS *, int, int);
extern void PrintFile (FILEOPTIONS *);
extern int FontDisplayError (int, int);
extern void ChangePrinterOrFonts (void);
extern HFONT SelectAsciiFont (HDC hdc, char *facename, double ps, TEXTMETRIC *tmout);
extern HFONT FindMatchingScreenFont (HFONT, double, TEXTMETRIC *);
extern void PutQuickFile (char *);
extern void UpdateQuickFiles (void);
extern char *GetQuickFile (int);
extern FILEOPTIONS *CreateUsingTemplate(char far *, int);
extern BOOL ClipboardFull (void);
extern int YesNo(HWND, char *, ...);
extern void UndoAddTyping (FILEOPTIONS *, POSITION, int, BOOL);
extern void UndoAddInsert (FILEOPTIONS *, POSITION, POSITION);
extern void UndoJoinLine (FILEOPTIONS *, POSITION);
extern void UndoAddErase (FILEOPTIONS *, POSITION, int);
extern void UndoAddDelete (FILEOPTIONS *, POSITION, POSITION);
extern void UndoOneStep (FILEOPTIONS *);
