{ Routines to do fancy editing, like Mirror and Fill }

procedure mirror;

    const  msg1 : prompt = ('cursor on','mirror axis?','  (Y/N)','','');
           msg2 : prompt = ('keep','Top?  Bottom?','Right?  Left?','','');
    var    inchar, keep, H_or_V : char;
           offset, i, j, size : integer;

    begin
        inchar := getchar (msg1);  (* cursor check *)
        if not((inchar='y') or (inchar='Y')) then
                (* didn't set up properly. ABORT! *)
        begin
            ClrWin (2);
            window (2, 'Aborting mirror');
        end
        else
        begin

            keep := getchar (msg2);  (* orientation of mirror *)

            offset:=0;  (* 1 only for even symmetry, not implemented *)

            case keep of  (* MAIN WORKING CODE *)

            'L','l':   (* keep the left part *)
                begin
                    if x < line-x then  size := x
                                  else  size := line-x;
                    for j:=0 to page do
                        for i:= 0 to size do
                        begin
                            screen [x+offset+i, j] := screen [x-i, j];
                            dab (x+offset+i, j, screen [x+offset+i, j]);
                        end;
                end;

            'R','r':   (* keep the right part *)
                begin
                    if x < line-x then  size := x
                                  else  size := line-x;
                    for j:=0 to page do
                        for i:= 0 to size do
                        begin
                            screen [x-i, j] := screen [x+offset+i, j];
                            dab (x-i, j, screen [x-i,j]);
                        end;
                end;


            'T','t':   (* keep the top part *)
                begin
                    if y < page-y then  size := y
                                  else  size := page-y;
                    for i:=0 to line do
                        for j:= 0 to size do
                        begin
                            screen [i, y+offset+j] := screen [i, y-j];
                            dab (i, y+offset+j, screen [i, y+offset+j]);
                        end;
                end;

            'B','b':   (* keep the bottom part *)
                begin
                    if y < page-y then  size := y
                                  else  size := page-y;
                    for i:=0 to line do
                        for j:= 0 to size do
                        begin
                            screen [i, y-j] := screen [i, y+offset+j];
                            dab (i, y-j, screen [i, y-j]);
                        end;
                end;

            else
                begin
                    ClrWin (2);
                    window (2, 'Illegal option.');
                    window (2, 'Mirror aborted.');
                end;
            end;
        end;
    end;


function check (x,y, n : integer) : boolean;
  {  this function is used by "fill" to test whether a cell is a candidate
     for the next step.  N identifies whether the test is for:
     0 - don't test for cell contents, just <x,y> in bounds.
     1 - test for exact match.
     2 - test for all but exact match.
     3 - test for screen > brush.
     4 - test for screen < brush.
  }
    begin
      check := FALSE;
      if (x >= 0) and (x < line) and (y >= 0) and (y < page) then
          case n of
          0:  check := TRUE;
          1:  if screen [x,y] = brush then check := TRUE;
          2:  if not (screen [x,y] = brush) then check := TRUE;
          3:  if screen [x,y] > brush then check := TRUE;
          4:  if screen [x,y] < brush then check := TRUE;
          end;
    end;


procedure fill (x,y : integer);
  { fills an area including the point <x,y>, up to a boundary of cells
      >= brush if FillFlag = 3
      <= brush if FillFlag = 4
  }
    begin
        screen [x,y] := brush;
        dab (x,y, brush);   (* this way, we watch it work *)
                            (* For speed, drop this line, & RestorScr *)
        if check (x+1,y, FillFlag)  then  fill (x+1,y);
        if check (x,y+1, FillFlag)  then  fill (x,y+1);
        if check (x-1,y, FillFlag)  then  fill (x-1,y);
        if check (x,y-1, FillFlag)  then  fill (x,y-1);
