{  This is a set of file-handling utilities,
  designed for PAINT, but perhaps with wider applicability  }

function getname ( oldname : filename; code : integer ) : filename;
  {  Queries for a file name, announcing "oldname" as default.
     If code > 0, file must already exist.
     Returns the file name. }

    var    newname : filename;
           inchar : char;
           fprom : prompt;
           filemsg : string [20];
           fname : text;
    begin
        inchar:=' ';
        newname:=oldname;
        repeat
            ClrWin (2);
            window (2,'Current File Name');
            window (2,newname);
            window (2,'NAME OF FILE?');
            GoToXY (RIGHT-WinWidth, linecount [2]);
            ReadLn (newname);
            if newname='' then  newname:=oldname;
            Assign (fname, newname);

            {$I-}  reset (fname)  {$I+} ;
            if  IOresult=0 then
            begin
                filemsg := 'File exists. OK?';
                close (fname);
            end
            else begin
                if code=0 then filemsg:= 'New file. OK?'
                else           filemsg:= 'No such file.'
            end;

            inchar := ' ';
                ClrWin (2);
                window (2,newname);
                window (2,filemsg);
            if not (filemsg='No such file.') then
            begin
                window (2,'(Y/N)');
                GoToXY (RIGHT-WinWidth+6, linecount [2]-1);
                read (kbd, inchar);
            end
            else Delay (3000);

        until (inchar='y') or (inchar='Y');

        ClrWin (2);
        getname := newname;
    end;

procedure load (var oldname : filename; var screen : PagArr; xlate : palette);
    const  abortmsg : prompt = ('NO SUCH FILE','ABORTING LOAD','','','');
    var    i,j, last : integer;
           pline : string [132];
           pfile : text;
           newname : filename;
    begin
        ClrWin (2);
        window (2,'Current File Name');
        window (2,oldname);
        window (2,'NAME OF FILE?');
        GoToXY (RIGHT-WinWidth, linecount [2]);
        ReadLn (newname);
        if newname='' then  newname:=oldname;

        assign (pfile, newname);
        {$I-}  reset (pfile)  {$I+} ;
        if  not (IOresult=0) then   (* no such file *)
            flash (abortmsg)
        else begin       (* load line-by-line from pfile *)
            (* start by clearing old screen *)
            for j:=0 to page do  for i:=0 to line do  screen [i,j] := 1;

            i:=0;      (* line counter *)
            while not EOF (pfile) do
            begin
                readln (pfile, pline);
                last := length (pline) -1;

                (* construct a line of the screen *)
                for j:=0 to last do
                    screen [j,i] := pos (pline [j+1], xlate);
                              (* use "xlate" to get numeric brush values *)
                if last < line-1 then    (* fill rest of line with blanks *)
                    for j:=last+1 to line-1 do   screen [j,i] := 1;

               i := i + 1;
            end;

            close (pfile);
            oldname := newname;
        end;
    end;


procedure save (fname : filename; screen : PagArr; xlate : palette);
    var    i,j, last : integer;
           pline : string [132];
           pfile : text;
           reassure : prompt;
    begin
        if fname='CON:' then
            begin   Alfa; ClrScr;   end;
        assign (pfile, fname);
        rewrite (pfile);
        for i:=0 to page-1 do    (* for each line in turn *)
        begin
            (* find last non-blank on line *)
            last := line-1;
            while (screen [last,i] < 2) and (last >= 0) do
                last := last - 1;

            (* construct a print line *)
            pline := '';
            if last >=0 then
              for j:=0 to last do
                pline := concat (pline, xlate [screen [j,i]]);

            if (fname='CON:') and (line=80)
                then   write   (pfile, pline)   (* CR takes the 81st col *)
                else   writeln (pfile, pline);
        end;
        close (pfile);
        if fname='CON:' then repeat until KeyPressed
            else if not (fname='LST:') then
            begin
                reassure [1] := fname;
                reassure [2] := 'FILE SAVED.';
                reassure [3] := ''; reassure [4] := ''; reassure [5] := '';
                flash (reassure);
            end;
    end;
