/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.gui.HighlightJButton;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallListener;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.Unpacker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLWriter;

public class InstallerFrame
extends JFrame {
    public LocaleDatabase langpack;
    private InstallData installdata;
    public IconsDatabase icons;
    private GridBagLayout layout;
    private GridBagConstraints gbConstraints;
    private JPanel panelsContainer;
    private JPanel contentPane;
    private HighlightJButton prevButton;
    private HighlightJButton nextButton;
    private HighlightJButton quitButton;
    private JLabel madewithLabel;

    private void runAutomation() throws Exception {
        System.out.println("[ Running automated installation ... ]");
        int n = this.installdata.panels.size();
        int n2 = 0;
        while (n2 < n) {
            IzPanel izPanel = (IzPanel)this.installdata.panels.get(n2);
            String string = (String)this.installdata.panelsOrder.get(n2);
            XMLElement xMLElement = this.installdata.xmlData.getFirstChildNamed(string);
            izPanel.runAutomated(xMLElement);
            ++n2;
        }
        System.out.println("[ Automated installation done ]");
    }

    private void loadPanels() throws Exception {
        ArrayList arrayList = this.installdata.panelsOrder;
        int n = arrayList.size();
        Class[] classArray = new Class[]{Class.forName("com.izforge.izpack.installer.InstallerFrame"), Class.forName("com.izforge.izpack.installer.InstallData")};
        Object[] objectArray = new Object[]{this, this.installdata};
        int n2 = 0;
        while (n2 < n) {
            String string = (String)arrayList.get(n2);
            Class<?> clazz = Class.forName("com.izforge.izpack.panels." + string);
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            Object obj = constructor.newInstance(objectArray);
            IzPanel izPanel = (IzPanel)obj;
            this.installdata.panels.add(izPanel);
            XMLElement xMLElement = new XMLElement(string);
            this.installdata.xmlData.addChild(xMLElement);
            ++n2;
        }
    }

    private void loadIcons() throws Exception {
        this.icons = new IconsDatabase();
        InputStream inputStream = this.getClass().getResourceAsStream("/com/izforge/izpack/installer/icons.xml");
        StdXMLParser stdXMLParser = new StdXMLParser();
        stdXMLParser.setBuilder(new StdXMLBuilder());
        stdXMLParser.setReader(new StdXMLReader(inputStream));
        stdXMLParser.setValidator(new NonValidator());
        XMLElement xMLElement = (XMLElement)stdXMLParser.parse();
        Vector vector = xMLElement.getChildren();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            XMLElement xMLElement2 = (XMLElement)vector.get(n2);
            URL uRL = this.getClass().getResource(xMLElement2.getAttribute("res"));
            ImageIcon imageIcon = new ImageIcon(uRL);
            this.icons.put(xMLElement2.getAttribute("id"), imageIcon);
            ++n2;
        }
    }

    private void buildGUI() {
        ((Frame)this).setIconImage(this.icons.getImageIcon("JFrameIcon").getImage());
        JPanel jPanel = (JPanel)this.getGlassPane();
        InstallerFrame installerFrame = this;
        if (installerFrame == null) {
            throw null;
        }
        jPanel.addMouseListener(new MouseAdapter(installerFrame){
            private final /* synthetic */ InstallerFrame this$0;
            {
                this.this$0 = installerFrame;
                this.constructor$0(installerFrame);
            }

            private final void constructor$0(InstallerFrame installerFrame) {
            }
        });
        InstallerFrame installerFrame2 = this;
        if (installerFrame2 == null) {
            throw null;
        }
        jPanel.addMouseMotionListener(new MouseMotionAdapter(installerFrame2){
            private final /* synthetic */ InstallerFrame this$0;
            {
                this.this$0 = installerFrame;
                this.constructor$0(installerFrame);
            }

            private final void constructor$0(InstallerFrame installerFrame) {
            }
        });
        InstallerFrame installerFrame3 = this;
        if (installerFrame3 == null) {
            throw null;
        }
        jPanel.addKeyListener(new KeyAdapter(installerFrame3){
            private final /* synthetic */ InstallerFrame this$0;
            {
                this.this$0 = installerFrame;
                this.constructor$0(installerFrame);
            }

            private final void constructor$0(InstallerFrame installerFrame) {
            }
        });
        this.contentPane = (JPanel)this.getContentPane();
        this.layout = new GridBagLayout();
        this.contentPane.setLayout(this.layout);
        this.gbConstraints = new GridBagConstraints();
        this.gbConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelsContainer = new JPanel();
        this.panelsContainer.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
        this.panelsContainer.setLayout(new GridLayout(1, 1));
        this.buildConstraints(this.gbConstraints, 0, 0, 4, 1, 1.0, 1.0);
        this.gbConstraints.anchor = 10;
        this.gbConstraints.fill = 1;
        this.layout.addLayoutComponent(this.panelsContainer, this.gbConstraints);
        this.contentPane.add(this.panelsContainer);
        this.installdata.curPanelNumber = 0;
        IzPanel izPanel = (IzPanel)this.installdata.panels.get(0);
        this.panelsContainer.add(izPanel);
        InstallerFrame installerFrame4 = this;
        if (installerFrame4 == null) {
            throw null;
        }
        NavigationHandler navigationHandler = installerFrame4.new NavigationHandler();
        this.prevButton = new HighlightJButton(this.langpack.getString("installer.prev"), this.icons.getImageIcon("stepback"), this.installdata.buttonsHColor);
        this.buildConstraints(this.gbConstraints, 0, 1, 1, 1, 0.25, 0.0);
        this.gbConstraints.anchor = 16;
        this.gbConstraints.fill = 2;
        this.layout.addLayoutComponent(this.prevButton, this.gbConstraints);
        this.contentPane.add(this.prevButton);
        this.prevButton.addActionListener(navigationHandler);
        this.madewithLabel = new JLabel(this.langpack.getString("installer.madewith"));
        this.buildConstraints(this.gbConstraints, 1, 1, 1, 1, 0.25, 0.0);
        this.gbConstraints.anchor = 15;
        this.gbConstraints.fill = 0;
        this.layout.addLayoutComponent(this.madewithLabel, this.gbConstraints);
        this.contentPane.add(this.madewithLabel);
        this.nextButton = new HighlightJButton(this.langpack.getString("installer.next"), this.icons.getImageIcon("stepforward"), this.installdata.buttonsHColor);
        this.buildConstraints(this.gbConstraints, 2, 1, 1, 1, 0.25, 0.0);
        this.gbConstraints.fill = 2;
        this.layout.addLayoutComponent(this.nextButton, this.gbConstraints);
        this.contentPane.add(this.nextButton);
        this.nextButton.addActionListener(navigationHandler);
        this.quitButton = new HighlightJButton(this.langpack.getString("installer.quit"), this.icons.getImageIcon("stop"), this.installdata.buttonsHColor);
        this.buildConstraints(this.gbConstraints, 3, 1, 1, 1, 0.25, 0.0);
        this.gbConstraints.anchor = 14;
        this.layout.addLayoutComponent(this.quitButton, this.gbConstraints);
        this.contentPane.add(this.quitButton);
        this.quitButton.addActionListener(navigationHandler);
    }

    private void showFrame() {
        this.pack();
        ((Component)this).setSize(this.installdata.guiPrefs.width, this.installdata.guiPrefs.height);
        this.setResizable(this.installdata.guiPrefs.resizable);
        this.centerFrame(this);
        ((Component)this).setVisible(true);
    }

    private void switchPanel(int n) {
        this.panelsContainer.setVisible(false);
        IzPanel izPanel = (IzPanel)this.installdata.panels.get(this.installdata.curPanelNumber);
        IzPanel izPanel2 = (IzPanel)this.installdata.panels.get(n);
        izPanel2.makeXMLData(this.installdata.xmlData.getChildAtIndex(n));
        this.panelsContainer.remove(izPanel2);
        this.panelsContainer.add(izPanel);
        if (this.installdata.curPanelNumber == 0) {
            this.lockPrevButton();
            this.unlockNextButton();
        } else if (this.installdata.curPanelNumber == this.installdata.panels.size() - 1) {
            this.lockNextButton();
        } else {
            this.unlockPrevButton();
            this.unlockNextButton();
        }
        izPanel.panelActivate();
        this.panelsContainer.setVisible(true);
    }

    public InputStream getResource(String string) throws Exception {
        return this.getClass().getResourceAsStream("/res/" + string);
    }

    public void centerFrame(Window window) {
        Dimension dimension = window.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)window).setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2 - 10);
    }

    public Dimension getPanelsContainerSize() {
        return this.panelsContainer.getSize();
    }

    public void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    public void exit() {
        if (this.installdata.canClose) {
            System.exit(0);
        } else {
            int n = JOptionPane.showConfirmDialog(this, this.langpack.getString("installer.quit.message"), this.langpack.getString("installer.quit.title"), 0);
            if (n == 0) {
                System.exit(0);
            }
        }
    }

    public void install(InstallListener installListener) {
        Unpacker unpacker = new Unpacker(this.installdata, installListener);
        unpacker.start();
    }

    public void writeXMLTree(XMLElement xMLElement, OutputStream outputStream) throws Exception {
        XMLWriter xMLWriter = new XMLWriter(outputStream);
        xMLWriter.write(xMLElement);
    }

    public void blockGUI() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().setVisible(true);
        this.getGlassPane().setEnabled(true);
    }

    public void releaseGUI() {
        this.getGlassPane().setEnabled(false);
        this.getGlassPane().setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void lockPrevButton() {
        this.prevButton.setEnabled(false);
    }

    public void lockNextButton() {
        this.nextButton.setEnabled(false);
    }

    public void unlockPrevButton() {
        this.prevButton.setEnabled(true);
    }

    public void unlockNextButton() {
        this.nextButton.setEnabled(true);
    }

    public void skipPanel() {
        if (this.installdata.curPanelNumber < this.installdata.panels.size() - 1) {
            ++this.installdata.curPanelNumber;
            this.switchPanel(this.installdata.curPanelNumber - 1);
        }
    }

    public InstallerFrame(String string, LocaleDatabase localeDatabase, InstallData installData) throws Exception {
        super(string);
        this.langpack = localeDatabase;
        this.installdata = installData;
        InstallerFrame installerFrame = this;
        if (installerFrame == null) {
            throw null;
        }
        this.addWindowListener(installerFrame.new WindowHandler());
        this.loadIcons();
        this.loadPanels();
        this.buildGUI();
        this.showFrame();
        this.switchPanel(0);
    }

    public InstallerFrame(LocaleDatabase localeDatabase, InstallData installData) throws Exception {
        super("IzPack - automated installation");
        this.langpack = localeDatabase;
        this.installdata = installData;
        this.loadIcons();
        this.loadPanels();
        this.buildGUI();
        this.switchPanel(0);
        this.runAutomation();
        System.exit(0);
    }

    class NavigationHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == InstallerFrame.this.prevButton) {
                if (((InstallerFrame)InstallerFrame.this).installdata.curPanelNumber > 0) {
                    --((InstallerFrame)InstallerFrame.this).installdata.curPanelNumber;
                    InstallerFrame.this.switchPanel(((InstallerFrame)InstallerFrame.this).installdata.curPanelNumber + 1);
                }
            } else if (object == InstallerFrame.this.nextButton) {
                if (((InstallerFrame)InstallerFrame.this).installdata.curPanelNumber < ((InstallerFrame)InstallerFrame.this).installdata.panels.size() - 1 && ((IzPanel)((InstallerFrame)InstallerFrame.this).installdata.panels.get(((InstallerFrame)InstallerFrame.this).installdata.curPanelNumber)).isValidated()) {
                    ++((InstallerFrame)InstallerFrame.this).installdata.curPanelNumber;
                    InstallerFrame.this.switchPanel(((InstallerFrame)InstallerFrame.this).installdata.curPanelNumber - 1);
                }
            } else if (object == InstallerFrame.this.quitButton) {
                InstallerFrame.this.exit();
            }
        }

        NavigationHandler() {
        }
    }

    class WindowHandler
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            if (!((InstallerFrame)InstallerFrame.this).installdata.canClose) {
                JOptionPane.showMessageDialog(null, InstallerFrame.this.langpack.getString("installer.quit.message"), InstallerFrame.this.langpack.getString("installer.warning"), 0);
            }
            System.exit(0);
        }

        WindowHandler() {
        }
    }
}

