/*
	window.h - declarations for window package
	
*/

#ifndef _WINDOW
#define _WINDOW

typedef enum {NORMAL, CROSS, BOX, LINE, BORDER} CURSOR;
extern CURSOR DragShape;

typedef enum 		/* data required: */
	{
	INVALID,
	REDRAW, CLEAR, HIDE, 
	RESIZE, 		/* width, height */
	MOVETO, 		/* x, y position (top left corner) */
	MOVE, 			/* x, y position of mouse */
	CLICK, 			/* x, y position of mouse */
	CLICKR,			/* x, y position of mouse */
	START_DRAGGING,	/* x, y position of mouse */
	DRAG, 			/* x, y position of mouse */
	RELEASE, 		/* x, y position of mouse */
	HIGHLIGHT, NORMALIZE
	} MESSAGE;

			/* these are created by CreateWindow */
typedef struct window_st
	{
	char *text;			/* label at top of window */
	void (*accept)();	/* points to message handler */
	int x, y;			/* top left corner of window */
	int w, h;			/* width & height of window */
	int window_style;
	int border_style;
	int	norm, high;		/* text attributes */
	int vis;			/* nonzero if the window is visible */
	} WINDOW;

			/* these are created by CreateVMenu and CreateHMenu */
typedef struct menu_st
	{
	char *text;			/* label at top of window */
	void (*accept)();	/* points to new message handler */
	int x, y;			/* top left corner of window */
	int w, h;			/* width & height of window */
	int window_style;
	int border_style;
	int	norm, high;		/* text attributes */
	int vis;			/* nonzero if the menu is visible */

		/* above fields are like WINDOW */
	void (*w_accept)();		/* points to window message handler */
	int menu_style;			/* 0 for vertical, 1 for horizontal */
	int sel;				/* the currently selected button (else -1) */
	int shown;				/* the highlighted button (else -1) */
	int cButtons;			/* # buttons to follow */
	struct button_st *pab;	/* the menu button(s) */
	} MENU;

			/* these are allocated by the programmer */
typedef struct button_st
	{
				/* first four fields are filled in by the programmer */
	char *text;				/* displayed in button area */
	char *trigger;			/* type this to trigger the button */
	char *val;				/* what the button generates */
	void (*accept)();		/* points to message handler */
	struct menu_st *pm;		/* pointer to child menu */

				/* remaining fields are filled in by
					CreateVMenu and CreateHMenu */
	int	norm, high;			/* text attributes */
	int x, y;				/* top left corner of button area */
	int w, h;				/* width & height of button in pixels */
	} BUTTON;

/*
WINDOW *CreateWindow();
MENU *CreateVMenu();
MENU *CreateHMenu();

void MsgWindow();
void MsgMenu();
void MsgButton();

void far MouseHandler();
*/

#ifndef MODEL
#ifdef __LARGE__
#define MODEL far
#else
#define MODEL
#endif
#endif /* MODEL */

         MODEL ClearBox( int x1, int y1, int x2, int y2 );
         MODEL flip_box( int x0, int y0, int x1, int y1 );
         MODEL flip_cross( int x, int y );
         MODEL box( int x0, int y0, int x1, int y1 );
    void far   MouseHandler( int trigger, int status, int hor, int ver );
         MODEL ShowMouse( );
         MODEL HideMouse( );
#ifndef __TURBOC__
int      MODEL IsMouse( );
#endif
         MODEL ShowMouseCursor( );
         MODEL HideMouseCursor( );
         MODEL MenuResponse( MENU *pm );
void     MODEL MsgButton( MESSAGE msg, int *data, BUTTON *pb );
		 MODEL inside( int x, int y, int x1, int y1, int w, int h );
void     MODEL MsgMenu( MESSAGE msg, int *data, MENU *pm );
MENU    *MODEL CreateHMenu( BUTTON *pb, int x, int y, int extra );
MENU    *MODEL CreateVMenu( char *text, BUTTON *pb, int x, int y, int extra );
         MODEL deliver( );
         MODEL deposit( MESSAGE msg, int data[], WINDOW *pw );
		 MODEL WinGetString( char *query, char *s, int appending, int x, int y, WINDOW *pw );
         MODEL WinShowString( char *s, int x, int y, WINDOW *pw );
         MODEL WinOverlaps( WINDOW *pw1, WINDOW *pw2 );
         MODEL WinCovers( WINDOW *pw1, WINDOW *pw2 );
void     MODEL MsgWindow( MESSAGE msg, int *data, WINDOW *pw );
WINDOW * MODEL CreateWindow( char *text, int x, int y, int extra );
         MODEL getse( char *s, int appending, int x, int y, int w, int norm, int high );
         MODEL ungets( char *s );
         MODEL terminate( );
         MODEL init_menus( );
MENU *   MODEL CreateSubMenu( char ch, BUTTON *child_strings, MENU *pm );
         MODEL GetEvent( );

#endif /* _WINDOW */
