{ Bezier Curve/4 Control Points }

uses SVGA256,Txt;

const A:array[1..6,1..2] of integer=(
	(30,60),(80,140),(130,140),(180,60),(230,60),(280,140));
var B:array[1..1000,1..2] of integer;

{  Lines  }
procedure Lines(Color:integer);
var I,N:integer;
begin
  N:=6;
  for I:=1 to N-1 do Line(A[I,1],A[I,2],A[I+1,1],A[I+1,2],Color);
end;
{  Bezier  }
procedure Bezier(N,Z:integer);
var I,J:integer;
    T1,T2,T3,A1,A2,A3,A4:real;
begin
  for I:=1 to N-3 do for J:=1 to Z+1 do begin
    T1:=(J-1)/Z;
    T2:=T1*T1;
    T3:=T1*T2;
    A1:=-T3+3*T2-3*T1+1;
    A2:=3*T3-6*T2+3*T1;
    A3:=-3*T3+3*T2;
    A4:=T3;
    B[(Z+1)*I+J-Z-1,1]:=Round(A1*A[I,1]+A2*A[I+1,1]+A3*A[I+2,1]+A4*A[I+3,1]);
    B[(Z+1)*I+J-Z-1,2]:=Round(A1*A[I,2]+A2*A[I+1,2]+A3*A[I+2,2]+A4*A[I+3,2]);
  end;
end;
{  Draw  }
procedure Draw(N,Z,Color:integer);
var I,J:integer;
begin
  for I:=1 to N-3 do for J:=1 to Z do
    Line(B[(Z+1)*I+J-Z-1,1],B[(Z+1)*I+J-Z-1,2],
    B[(Z+1)*I+J-Z,1],B[(Z+1)*I+J-Z,2],Color+J-1);
end;

begin
  SetMode(1);
  Lines(15);
  Bezier(6,10); Draw(6,10,36);
  Readln;
  SetMode(0);
end.
