
#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include <bios.h>
#include <memory.h>
#include <assert.h>

#include "cthugha.h"
#include "charset.h"
#include "zorilkey.h"
#include "audio.h"
#include "translat.h"
#include "options.h"

#include "patch.h"
#include "initscrn.h"

#include "uncrunch.h"

#include "opts.h"

extern int numflames,numwaves, numdisplays;
extern unsigned char far *screenaddr;

void show_flame(int i)
{
	int x,y;
	char temp[80];

	if (i<0 || i>26)
		return;

	if (i>=13) {
		x=41;
		y=4+i-13;
	} else {
		x=2;
		y=4+i;
	}

	gotoxy(x,y);
	printf("%c",65+i);

	sprintf(temp,"%-20s",flamearray[i].name);
	put_string(x+5,y,temp);

	if (flamearray[i].flag_when) {
		put_string(x+27,y," On    ");
	} else {
		put_string(x+27,y,"    Off");
	}
}

char toggle_when(char current)
{
	return ((current)?WHEN_NEVER:WHEN_ALWAYS);
}

void show_screen(void)
{

	uncrunch(OPTS,screenaddr,sizeof(OPTS));
}

void flame_option(void)
{
	int i;
	int ch;

	show_screen();

	gotoxy(30,1);
	printf("Flame Options Screen");

	for (i=0; i<numflames; i++) {
		show_flame(i);
	}

	while ((ch=_getch())!= 0x1B) {
		ch=toupper(ch);
		if (ch>='A' && ch<='A'+numflames-1) {
			flamearray[ch-'A'].flag_when = toggle_when(flamearray[ch-'A'].flag_when);
			show_flame(ch-'A');
		}
	}


}

extern int sound_type;
extern int curflame,usewave;
extern int use_fft;

int check_flame_ok(int num)
{
	int ok;
	int start_flame;

	while (num<0)
		num += numflames;

	num = (num)%numflames;

	start_flame=(num)%numflames;

	ok=0;
	while (!ok) {
		ok=1;
		if (!(flamearray[num].flag_when))
			ok=0;

		if (!ok) {
			num=(num+1)%numflames;
			if (num==start_flame) {
				ok=1;
			}
		}
	}

	return num;

}

int check_wave_ok(int num)
{
	int ok;
	int start_wave;

	while (num<0)
		num += numwaves;

	num = (num)%numwaves;

	start_wave=(num)%numwaves;

	ok=0;
	while (!ok) {
		ok=1;
		if (!(wavearray[num].flag_when))
			ok=0;

		if (!ok) {
			num=(num+1)%numwaves;
			if (num==start_wave) {
				ok=1;
			}
		}
	}

	return num;

}

void show_wave(int i)
{
	int x,y;
	char temp[80];

	if (i<0 || i>26)
		return;

	if (i>=13) {
		x=41;
		y=4+i-13;
	} else {
		x=2;
		y=4+i;
	}

	gotoxy(x,y);
	printf("%c",65+i);

	sprintf(temp,"%-20s",wavearray[i].name);
	put_string(x+5,y,temp);

	if (wavearray[i].flag_when) {
		put_string(x+27,y," On    ");
	} else {
		put_string(x+27,y,"    Off");
	}
}

void wave_option(void)
{
	int i;
	int ch;

	show_screen();

	gotoxy(30,1);
	printf("Wave Options Screen");

	for (i=0; i<numwaves; i++) {
		show_wave(i);
	}

	while ((ch=_getch())!= 0x1B) {
		ch=toupper(ch);
		if (ch>='A' && ch<='A'+numwaves-1) {
			wavearray[ch-'A'].flag_when = toggle_when(wavearray[ch-'A'].flag_when);
			show_wave(ch-'A');
		}
	}


}




int check_disp_ok(int num)
{
	int ok;
	int start_disp;

	while (num<0)
		num += numdisplays;

	num = (num)%numdisplays;

	start_disp=(num)%numdisplays;

	ok=0;
	while (!ok) {
		ok=1;
		if (!(disparray[num].flag_when))
			ok=0;

		if (!ok) {
			num=(num+1)%numdisplays;
			if (num==start_disp) {
				ok=1;
			}
		}
	}

	return num;

}


void show_disp(int i)
{
	int x,y;
	char temp[80];

	if (i<0 || i>26)
		return;

	if (i>=13) {
		x=41;
		y=4+i-13;
	} else {
		x=2;
		y=4+i;
	}

	gotoxy(x,y);
	printf("%c",65+i);

	sprintf(temp,"%-20s",disparray[i].name);
	put_string(x+5,y,temp);

	if (disparray[i].flag_when) {
		put_string(x+27,y," On    ");
	} else {
		put_string(x+27,y,"    Off");
	}
}

void disp_option(void)
{
	int i;
	int ch;

	show_screen();

	gotoxy(27,1);
	printf("Display mode Options Screen");


	for (i=0; i<numdisplays; i++) {
		show_disp(i);
	}

	while ((ch=_getch())!= 0x1B) {
		ch=toupper(ch);
		if (ch>='A' && ch<='A'+numdisplays-1) {
			disparray[ch-'A'].flag_when = toggle_when(disparray[ch-'A'].flag_when);
			show_disp(ch-'A');
		}
	}


}
