-----------------------------------------------------------------
VOUCH  version  1.1.  Copyright (c) 1993, 1994  Awais M. Hussain.
-----------------------------------------------------------------
<sfio.c>

Special (non-generic) file IO routines.

Routines in this module use many external variables from <vch.c>.

=================================================================
1.
void write_rFile( char *fn,  long *nb, char *pswd ) ;

The r_signature LN (LrSign,rSign) and the exponent LN (LkSec,kSec)
are appended to file <fn>. ( rSign = g^kSec mod p mod q ).  The basic
record for this file is a long-integer. The first record is the
lengths of LNs stored in this file. The second record is the number
of (kSec,rSign) pairs stored.  The next records contain the LNs kSec
and rSign.  Before storage (LkSec,kSec) is encrypted with the
password ("pswd").  The (LkSec,kSec) need to be kept secret [1]. Note
that LrSign=LkSec=Lqq.  Since the encryption routine cryptLN()
increments the length of an odd-length LN, the length of LNs stored in
this file is made Lqq+1 if Lqq is odd. 

I: fn : filename.
O: nb : total number of LN pairs in the file.
I: pswd : password string.


2.
void read_rFile( char *fn, char *pswd ) ;

Reads the bottom ( (LkSec,kSec), (LrSign,rSign) ) pair from file <fn>.
The LN (LkSec,kSec) is decrypted after reading. The size of the file
is adjusted after the reading. If this was the only pair, the file is
deleted.

I: fn : filename.
I: pswd : password string.


3.
void re_enc_rFile( char *fn, char *opswd, char *pswd ) ;

Following a password change from opswd to pswd, the file <fn> is
re-encrypted with the new password.

I: opswd : old password string.
I: pswd : new password string.
I: fn : filename.

4.
void write_prvKey( char *fn, char *pswd ) ;

The private-key (LxSec,xSec) is written to file <fn> after being
encrypted with the password "pswd."  The first record in file <fn> is a
long-integer containg LxSec. Next records contain the long-integers
of xSec. It is of utmost importance to keep the private key secret.
For maximum security, a full 32-character password should be
specified. Consult <usrGuide.vch> for additional security precautions.

I: fn : filename.
I: pswd : password string.

5.
void read_prvKey( char *fn, char *pswd ) ;

Reads in the private-key LN (LxSec,xSec) from file <fn>. After
reading, the LN is decrypted. 

I: fn : filename.
I: pswd : password string.


==================================================================

[1] T. ElGamal, ``A public-key cryptosystem and a signature scheme
     based on discrete logarithms,'' 
     IEEE Transactions on Information Theory, 
     IT-31, pp. 469-472, July 1985. 
