/**<vfio.c>***************************************************
*                       V O U C H                           *
*   VOUCH 1.1  Copyright (c) 1993, 1994  Awais M Hussain    *
*                   All rights reserved                     *
*************************************************************/
/* Consult <vfio.man> for documentation. 
*/
#include "vch.h"
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <fcntl.h>
#include <dir.h>
#include <io.h>
#include <string.h>

#define SIZE 4096

/* write a LongNumber <Lxx,xx> to file <fname> 
   if crf then create_file else append_file    */
int writeLN( unsigned crf, const char *fname, lenLN Lxx, ptrLN xx ) ;

/* read the <ind>-th LongNumber in <Lxx,xx> from file <fname> */
int readLN( unsigned ind, const char *fname, lenLN  *Lxx, ptrLN xx ) ;

/* truncate file after the ind-th line */
int trunc( unsigned ind, const char * fn ) ;

/* write comment */
int writeS( unsigned crf, const char *fname, char *cmnt ) ;

/*  fn2 = fn1 with new extension (nExt) */
void fExt( const char *fn1, const char *nExt, char *fn2 ) ;

/* cp=1 : make a copy of file <fn1> and name it <fn2> */
/* cp=0 : append file <fn1> to <fn2> */
int copyFile( const char *fn1, const char *fn2, int cp ) ;


int copyFile( const char *fn1, const char *fn2, int cp )
{
  FILE *f1, *f2 ;
  char *buff ;
  int nr, nw ;

  if ( (f1 = fopen( fn1, "rb" )) == (FILE*) NULL ) return(errno) ;
  if (cp) {
    if ( (f2 = fopen( fn2, "wb" )) == (FILE*) NULL ) { 
      nr = errno ; fclose(f1) ; return(nr) ; }
  } else
    if ( (f2 = fopen( fn2, "ab" )) == (FILE*) NULL ) { 
      nr = errno ;  fclose(f1) ; return(nr) ; }
  buff = (char*) malloc(SIZE) ;
  nr = SIZE ;
  while (nr==SIZE) {
    nr = fread( buff, 1, SIZE, f1 ) ;
    if (nr>0) {
       nw = fwrite( buff, 1, nr, f2 ) ;
       if (nr!=nw) {
         free(buff) ;
	 fclose(f1) ; fclose(f2) ;
	 return( 31 ) ; }
    }
  }
  free( buff ) ;
  fclose(f1) ; fclose(f2) ;
  return( 0 ) ;
}/* copyFile */

int writeLN( unsigned crf, const char *fname, lenLN Lxx, ptrLN xx )
{
	FILE  *fx ;
	char  *buff, ct ;
	int i, j, i8 ;

	if (crf) fx = fopen( fname, "w" ) ;
	else
          fx = fopen( fname, "a") ;
   	if (fx == (FILE*) NULL) return(errno) ;
	buff = (char*) malloc(2048) ;
	for (i=0; i<Lxx; ++i) {
		sprintf( &buff[8*i], "%08lX", *(xx+i) ) ;
		i8 = 8*i ;
		for (j=0; j<4; ++j) {
		       ct = buff[i8+j] ;
		       buff[i8+j] = buff[i8+7-j] ;
		       buff[i8+7-j] = ct ;
	        }
	 }
	 buff[8*Lxx] = '\n' ;
	 buff[8*Lxx+1]= '\0' ;
	 if ( fputs( buff, fx ) == EOF ) { free(buff) ; return(31) ; }
	 fclose(fx) ;  free(buff) ;
	 return(0) ;
}/* writeLN */


int readLN( unsigned ind, const char *fname, lenLN  *Lxx, ptrLN xx )
{
 FILE  *fx ;
 char  *buff, ct ;
 int i, j, i8, lstr ;

 if ( (fx = fopen( fname, "r" )) == (FILE*) NULL ) return(errno) ;
 buff = (char*) malloc(2048) ;
 for (i=0; i<ind; ++i)
   if ( fgets( buff, 2048, fx ) == (char *) NULL ) {
     free(buff) ; fclose(fx) ; return(40) ;
   }
 fclose( fx ) ;
 lstr = (strlen(buff)-1) ;
 for (i=0; i<lstr; ++i) {
   ct = buff[i] ;
   if ( !( ((ct>='0') && (ct<='9')) ||
	   ((ct>='a') && (ct<='f')) ||
	   ((ct>='A') && (ct<='F')) ) )
      { free(buff) ; return(41) ; }
 }
 if (lstr>8**Lxx) { free(buff) ; return(50) ; }
 *Lxx = lstr/8 ;
 for (i=0; i<*Lxx; ++i) {
   i8 = 8*i ;
   for (j=0; j<4; ++j) {
     ct = buff[i8+j] ;
     buff[i8+j] = buff[i8+7-j] ;
     buff[i8+7-j] = ct ;
   }
 sscanf( &buff[8*i], "%08lX", xx+i ) ;
 }
 free(buff) ;
 if (*Lxx<1) return(41) ;
 while ( (*(xx+*Lxx-1)==0) && (*Lxx>1) )  (*Lxx)-- ;
 return(0) ;
}/* readLN */

int writeS( unsigned crf, const char *fname, char *cmnt )
{
  FILE  *fx ;
  int sl ;

  if (crf) fx = fopen( fname, "w" ) ;
    else fx = fopen( fname, "a") ;
  if (fx == (FILE*) NULL) return(errno) ;
  sl = strlen( cmnt ) ;
  cmnt[sl] = '\n' ; cmnt[sl+1] = '\0' ;
  if ( fputs( cmnt, fx ) == EOF ) return(31) ;
  fclose(fx) ; return(0) ;
}/* writeS */

void fExt( const char *fn1, const char *nExt, char *fn2 )
{
  char drv[4], dir[76], name[14], ext[5] ;

  fnsplit( fn1, drv, dir, name, ext ) ;
  fnmerge( fn2, drv, dir, name, nExt ) ;
}/* fExt */


int trunc( unsigned ind, const char * fn )
{
  long len = 0 ;
  char *buff ;
  int i, fo ;
  FILE *ff ;

  if ( ( ff = fopen( fn, "r" ) ) == NULL ) return(errno) ;
  buff = (char*) malloc(2048) ;
  for (i=0; i<ind; ++i ) {
    if ( fgets( buff, 2048, ff ) == (char *) NULL ) {
      free(buff) ; fclose(ff) ; return(40) ;
    }
    len += strlen(buff) + 1 ;
  }
  free(buff) ;
  fclose(ff) ;
  fo = open( fn, O_RDWR ) ;
  chsize( fo, len ) ;
  close(fo) ;
  return(0) ;
}/*trunc*/

