;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  SPEEDKEY.ASM         -       Speeds up PC-AT (only) keyboard repeat rate  ;
;                       -       Last modified: 12/05/87,  R. Trevithick      ;
;                       -       Accepts one parameter to set speed,          ;
;                               lower number == faster speed.                ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

spdseg  segment
        assume  cs:spdseg, ds:spdseg
        org     0100h
start:
        mov     bl, byte ptr ds:[80h]
        cmp     bl, 0                           ; any parameters ?
        je      skip                            ; no, set fastest
        mov     bl, byte ptr ds:[82h]           ; get one character
        sub     bl, 30h                         ; convert to integer
skip:   mov     al, 0f3h                        ; send preamble
        out     0060h, al
        mov     cx, 0fffh
delay:  loop    delay
        xchg    al, bl
        out     0060h, al                       ; send speed value
exit:   ret
spdseg  ends
        end     start
