{$A+,B-,D+,E-,F-,I-,L-,N-,O-,R+,S+,V-}
{$M 4096,0,0}

program faxbatch;

{
  A utility to mail files to a fax gateway by Peter Summers
  <peter@cardiology.medrmh.unimelb.edu.au>

  Uses code from a variety of sources.

  Free distributable.
}

uses dos,novell;

const   months   : array[1..12] of string = ('Jan','Feb','Mar','Apr','May',
                     'Jun','Jul','Aug','Sep','Oct','Nov','Dec');
        days     : array[0..6] of string = ('Sun','Mon','Tue','Wed','Thu',
                     'Fri','Sat');

const   delflag : boolean = false;   {true if we delete the file aftewards}
        mail    : boolean = false;   {true if mail headers should be added}
        faxacc  : string[16] = '';   {account of destination mail directory}
        faxdir  : string[64] = '';   {destination directory for faxes}
        extn    : string[4] = '';    {extension for new file}
        infilename : string[64] = ''; {name of data file}
        number  : string[64] = '';   {fax number}
        sender  : string[64] = '';   {sender of message}

var     outfilename : string[64];    {output data file name}
        batfilename : string[64];    {control batch file name}
        name        : string[8];     {used when creating output file names}
        version     : string[16];    {NOS version}
        infile      : file;          {input data file}
        outfile     : file;          {output data file name}
        batfile     : text;          {output file name}
        station     : integer;       {my netware station number}
        faxid       : string;        {hex id of fax account}
        retcode     : integer;       {returns status from Netware unit}
        numread     : word;          {number of bytes read from data file}
        block       : array[0..2047] of char;   {used for copying data}
        argument    : string[64];    {used for extracting arguments}
        mailheader  : string;        {mail header information}
        year        : word;
        month       : word;
        day         : word;
        hour        : word;
        minute      : word;
        second      : word;
        sec100      : word;
        dow         : word;
        i           : integer;


procedure raiserror(exitcode:word; message:string);

begin
  writeln(message);
  halt(exitcode);
end;


function nextarg:string;     {retrieves the next argument from command line}

const   param : integer = 1;         {used for parsing command line}
var     arg   : string;
        i     : byte;

begin
  if param>paramcount then
    nextarg:=''
  else
    begin
      arg := paramstr(param);
      for i := 1 to length(arg) do arg[i] := upcase(arg[i]);
      param := param + 1;
      nextarg := arg;
    end;
end;


function extension(filename:string):string; {returns the extension of a file}

var     namelen : integer;

begin
  namelen := length(filename);
  if (namelen>5) and (filename[namelen-3]='.') and (filename[namelen-1]<>'\')
    then extension := copy(filename,namelen-3,4)
  else if (namelen>4) and (filename[namelen-2]='.')
    then extension := copy(filename,namelen-2,3)
  else if (namelen>3) and (filename[namelen-1]='.')
    then extension := copy(filename,namelen-1,2)
  else extension := '.';
end;


function zstr(numb:integer):string;

var   temp     : string;

begin
  str(numb,temp);
  if numb<10 then zstr:='0'+temp else zstr:=temp;
end;


begin { program faxbatch }

  writeln('FAXBATCH: sets a FAX to be send out by a FAX server - 12 July 1995.');
  writeln('  by Peter Summers <peter@cardiology.medrmh.unimelb.edu.au>');
  writeln;

{provide help and exit if required}
  if paramstr(1) = '/?' then
    begin
      writeln('SYNTAX: FAXBATCH [<file> [<number>]] [/DEL] [/FAX <user>] [/DIR <faxdir>]');
      writeln('                         [/MAIL] [/EXT <extension>] [/SNDR <sender>]');
      halt(1);
    end;

{scan the command line}
  argument := nextarg;
  while argument<>'' do
    begin
      if argument = '/DEL' then
        delflag := true
      else if argument = '/ACC' then
        faxacc := nextarg
      else if argument = '/DIR' then
        faxdir := nextarg+'\'
      else if argument = '/EXT' then
        extn := '.'+nextarg
      else if argument = '/SNDR' then
        sender := nextarg
      else if argument = '/MAIL' then
        mail := true
      else if argument[1]='/' then
        raiserror(11,argument+' is not a valid switch.')
      else if infilename='' then
        infilename := argument
      else
        number := number + argument + ' ';
      argument := nextarg;
    end;

{check environment for directory if required}
  if (faxdir='') and (faxacc='') then faxdir := getenv('fbdir');

{get NOS specific stuff}
  get_server_version(version);
  if version<>'' {that is, Netware is running} then
    begin
      if faxdir='' then
        begin
          if faxacc='' then faxacc := getenv('fbacc');
          if faxacc='' then faxacc := 'FAX';
          gethexid(faxacc,faxid,retcode);
          if retcode<>0 then raiserror(3,'Can''t get id for user '+faxacc+'.');
          faxdir:='SYS:MAIL\'+faxid+'\';
        end;
      if sender='' then
        begin
          getstation(station,retcode);
          getuser(station,sender,retcode);
          getserverinfo;
          sender:=serverinfo.name+'/'+sender;
        end;
    end
  else {if Netware isn't running then} if faxdir='' then
    raiserror(1,'You MUST be logged in to a Novell server or specify a directory.');

{check environment for sender if required}
  if sender='' then sender := getenv('fbsndr');
  if sender='' then sender := getenv('pmuser');

{append '\' to fax directory if required}
  if faxdir[length(faxdir)] <> '\' then faxdir:= faxdir + '\';

{get the input file name if required}
  if infilename='' then
    begin
        write('File name ... ');
        readln(infilename);
    end;
  if infilename='' then raiserror(10,'No file name given, fax not sent.');

{get the fax number if required}
  if number='' then
    begin
      write('FAX Number .. ');
      readln(number);
    end;

{open the input file (so that we know we can)}
  assign(infile,infilename);
  filemode:=0;
  reset(infile,1);
  if IOResult<>0 then raiserror(2,'Can''t open file '+infilename+'.');

{create mail header if required}
  if mail then
    begin
      getdate(year,month,day,dow);
      gettime(hour,minute,second,sec100);
      mailheader:='From:     '+sender+^M+^J+'To:       '+number+^M+^J
        +'Date:     '+days[dow]+', '+zstr(day)+' '+months[month]+' '
        +zstr(year)+' '+zstr(hour)+':'+zstr(minute)+':'+zstr(second)
        +^M+^J+^M+^J;
    end;

{strip non-digits from phone number}
  i:=1;
  while i <= length(number) do
    if not (number[i] in ['0'..'9','*','#']) then
      delete(number,i,1)
    else
      i:=i+1;
  if number='' then raiserror(4,'No number given, fax not sent.');

{create output file names}
  randomize;
  name:='';
  for i:=1 to 8 do
    name:=name+chr(ord('A')+random(26));
  if extn='' then extn := extension(infilename);
  if extn = '.BAT' then extn := '.BA&';
  outfilename:=faxdir+name+extn;
  batfilename:=faxdir+name+'.BAT';

{open the data file for output}
  assign(outfile,outfilename);
  rewrite(outfile,1);
  if IOresult<>0 then raiserror(5,'Can''t open file '+outfilename);

{write mail headers if required}
  if mail then blockwrite(outfile,mailheader[1],length(mailheader));

{copy data from input to output file}
  while not eof(infile) do
    begin
      blockread(infile,block[0],sizeof(block),numread);
      if (IOresult<>0) and not eof(infile) then
        raiserror(6,'Can''t read from file '+infilename);
      blockwrite(outfile,block[0],numread);
      if IOresult<>0 then raiserror(7,'Can''t write to file '+outfilename);
    end;
  close(infile);
  close(outfile);

{create the batch file}
  assign(batfile,batfilename);
  rewrite(batfile);
  if IOresult<>0 then raiserror(8,'Can''t open file '+outfilename);
  delete(extn,1,1);
  writeln(batfile,'sendafax '+name+' '+extn+' '+number+' '+sender);
  if IOresult<>0 then raiserror(9,'Can''t open file '+batfilename);
  close(batfile);

{delete data file if required}
  if delflag then erase(infile);

end.
