/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       FUTIL.H
**     SYSTEM   NAME:       
**     ORIGINAL AUTHOR(S):  Wim van Campen
**     VERSION  NUMBER:     1.0
**     CREATION DATE:       1990/10/1
**
** DESCRIPTION: Contains headers for command file read functions.
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   FUTIL.H  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/FUTIL/VCS/FUTIL.H_V  $
**              
**                 Rev 1.0   20 Nov 1990 15:14:40   etstjan
**              Initial revision.
*************************************************************************/

/* return codes */
#define   FNOPEN     -1                    /*   file not open           */
#define   SNFOUND    -2                    /*   section not found       */
#define   FNOREAD    -3                    /*   nothing left to read    */
#define   FENDSEC    -4                    /*   passed end of section   */
#define   FILERR     -5                    /*   general file error      */
#define   VNFOUND    -6                    /*   variable not found      */

/* Case specifiers */
#define   UPC        0                     /* return upper case only    */
#define   MIX        1                     /* return mixed case         */

/* global variables */
extern char  ConfigFile[255];              /* configuration file name   */

/* prototypes */
int     FFindSection(FILE *ComFile, char *SectionStr);
int     FGetNext(FILE *ComFile, char *AnswerStr, int AnswLen, int Case);
int     FGetVar(FILE *ComFile, char *VarString, char *Result, 
                int ResultLen, int Case);
char    *StrUpper(char *Destin, char *Source);
char    *StrLower(char *Destin, char *Source);
