/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       dp.c
**     SYSTEM   NAME:       PACKET DISPATCHER
**     ORIGINAL AUTHOR(S):  Ling Thio
**     VERSION  NUMBER:     v1.00
**     CREATION DATE:       1989/11/30
**
** DESCRIPTION: Main packet dispatcher functions
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.1  $
** WORKFILE:    $Workfile:   DP.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/NPD/DP/VCS/DP.C_V  $
**              
**                 Rev 1.1   01 Feb 1991 14:20:32   etstjan
**              
**                 Rev 1.0   26 Oct 1990 12:27:34   etstjan
**              Initial revision.
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/CPROG/BEHOLDER/NPD/DP/VCS/DP.C_V   1.1   01 Feb 1991 14:20:32   etstjan  $";
#endif
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>                          /* for kbhit() */
#include <pkt.h>
#include <error.h>
#include <futil.h>
#include "dpinc.h"

DPBUF *pDpActiveBuf;
static int DpStatus = 0;
static int DpQuitLoop = 0;

/*************************************************************************
** NAME:        DpInit                                  [API]
** SYNOPSIS:    int DpInit(void)
** DESCRIPTION: Initializes the dispatcher.
**                Allocates the DP buffers (using DpInitActive)
**                Inits all DP appications in 'DpAppsActive[]'
**                Inits all DP filters in 'DpFiltAvailable[]'
**                Scans MSDOS user interrupts 0x60-0x80
**                  for PDS device driver to fill device list
**                  Inits all found PDS device drivers
** RETURNS:     0:              Successful call
**              DPERR_TOOMANY:  Too many devices
**              DPERR_NOMEM:    Insufficient memory
** SEE ALSO:    DpEnd
*************************************************************************/
int DpInit(void)
{
    int ret;
    FILE *Cfg;
    char Variable[6];

    ERR_DEB(ERR_NPD, 4, "DpInit started");      /* Initialize buffers */
    if ((Cfg = fopen (ConfigFile,"r")) == NULL)
    {
        ERR_ERR (ERR_NPD, ERR_CRITICAL, "Cannot open configfile\n");
        return(-1);
    }
    if (FFindSection (Cfg, "DISPATCHER") >= 0)
    {
        if (FGetVar (Cfg, "SIZESMALL", Variable, 5, UPC) >= 0)
            DpInitTable.SmallSize=atoi(Variable);
        else
            ERR_ERR (ERR_NPD, ERR_WARNING, "Cannot find SizeSmall");
        if (FGetVar (Cfg, "COUNTSMALL", Variable, 5, UPC) >= 0)
            DpInitTable.nSmall=atoi(Variable);
        else
            ERR_ERR (ERR_NPD, ERR_WARNING, "Cannot find CountSmall");
        if (FGetVar (Cfg, "SIZELARGE", Variable, 5, UPC) >= 0)
            DpInitTable.LargeSize=atoi(Variable);
        else
            ERR_ERR (ERR_NPD, ERR_WARNING, "Cannot find SizeLarge");
        if (FGetVar (Cfg, "COUNTLARGE", Variable, 5, UPC) >= 0)
            DpInitTable.nLarge=atoi(Variable);
        else
            ERR_ERR (ERR_NPD, ERR_WARNING, "Cannot find CountLarge");
    }
    else
    {
        ERR_ERR (ERR_NPD, ERR_WARNING, "Cannot find section DISPATCHER");
    }
    fclose (Cfg);
    if ( (ret=DpBufInit( DpInitTable.nSmall, DpInitTable.SmallSize,
                         DpInitTable.nLarge, DpInitTable.LargeSize))
       || (ret=DpDevInit())                     /* then Devices */
       || (ret=DpTypeFiltInit())                /* then TypeFilters */
       || (ret=DpAppsInit())                    /* then Applications */
       || (ret=DpFiltInit()) )                  /* then Filters */
        DpDevEnd();                             /* Errors, so close up */
    else                                        /* Else all went fine */
        DpStatus |= DPE_INIT;           
    ERR_DEB(ERR_NPD, 4, "DpInit exit: <%d>",ret);
    return ret;
}


/*************************************************************************
** NAME:        DpEnd                                   [API]
** SYNOPSIS:    void DpEnd()
** DESCRIPTION: Terminates the Dispatcher, initialized by DpInit().
**                Frees Dispatcher buffer memory
**                Ends all DP filters in 'DpFiltAvailable[]'
**                Ends all device drivers
**                Ends all DP appications in 'DpAppsActive[]'
** RETURNS:     void
** SEE ALSO:    DpInit
*************************************************************************/
void DpEnd()
{
    ERR_DEB(ERR_NPD, 3, "DpEnd");
    if (DpStatus & DPE_INIT)
    {
        DpTypeFiltEnd();
        DpDevEnd();
        DpFiltEnd();
        DpAppsEnd();
        DpBufEnd();
        DpStatus &= (~DPE_INIT);
    }
}

/*************************************************************************
** NAME:        DpStart                                 [API]
** SYNOPSIS:    int DpStart(void)
** DESCRIPTION: Starts receiving packets by the Dispatcher.
**                Generates DPE_START events for all DP apps
**                Starts elapsed time timer
**                Resets DP buffers
**                Starts all devices
** RETURNS:     0:  Successfull call
**              !0: Error code
*************************************************************************/
int DpStart()
{
    int ret;
    
    ERR_DEB(ERR_NPD, 3, "DpStart");
    ret = DpAppsStart();
    if (!ret)
    {
        ERR_DEB(ERR_NPD, 4, "DpTimerInit");
        DpTimerInit();
        ERR_DEB(ERR_NPD, 4, "DpBufReset");
        DpBufReset();                     /* clear Packet Pending List */
        ERR_DEB(ERR_NPD, 4, "DpDevReset");
        DpDevStart ();                     /* start all devices */
        DpStatus |= DPE_START;
    }
    return ret;
}

/*************************************************************************
** NAME:        DpStop                                  [API]
** SYNOPSIS:    void DpStop()
** DESCRIPTION: Stops receiving packets by the Dispatcher.
**                Stops all devices
**                Stops elapsed time timer
**                Dispatch pending DP buffers by generating
**                  extra DPE_RECEIVEPKT events
**                Generates DPE_STOP events for all DP apps
** RETURNS:     void
*************************************************************************/
void DpStop()
{
    ERR_DEB(ERR_NPD, 3, "DpStop");
    if (DpStatus & DPE_START)
    {
        DpDevStop ();                          /* stop all devices */
        DpTimerEnd();
        while (pDpActiveBuf = DpBufGetUsed()) /* empty buffer */
        {
            DpAppsReceivePkt();               /*   dispatch packet */
            DpBufFreeUsed(pDpActiveBuf);
        }
        DpAppsStop();
        DpStatus &= (~DPE_START);
    }
}


DPKEY DpInternalLoop(void)
{
    if (pDpActiveBuf = DpBufGetUsed())      /* if buffers pending .. */
    {
        DpAppsReceivePkt();                 /*   dispatch packet */
        DpBufFreeUsed(pDpActiveBuf);
    }
    else                                    /* else .. */
        DpAppsFreeTime();                   /*   dispatch processing time */
    return 0;
}

/*************************************************************************
** NAME:        DpLoop                                  [API]
** SYNOPSIS:    void DpLoop(void)
** DESCRIPTION: Dispatches all Pending Packets to Applications.
**                removing them from the Packet Pending list,
**                to the 'BufFreeSmall' list
**                and the 'BufFreeLarge' list
**              Dispatches free processing time when the
**                Pending Packet list is empty
** RETURNS:     void
*************************************************************************/
void DpLoop()
{
    DpQuitLoop=0;
    while (!DpQuitLoop)
    {
        DpInternalLoop();
        if (DpKbHit())
            DpQuitLoop = DpKbHitEvent();
    }
}

/*************************************************************************
** NAME:        DpQuit                                  [API]
** SYNOPSIS:    void DpQuit(void)
** DESCRIPTION: Stops the dispatcher loop.
** RETURNS:     void
*************************************************************************/
void DpQuit()
{
    DpQuitLoop = 1;
}


/*************************************************************************
** NAME:        DpReceivePkt                            [API]
** SYNOPSIS:    DPBUF *DpReceivePkt(void)
** DESCRIPTION: Returns a ptr to current packet buffer struct.
**              DPBUF {
**                  int Dev;
**                  unsigned long ClockMs;
**                  unsigned Status;
**                  unsigned Size;
**                  BYTE far *pBuf;
**                  struct _DPBUF far *pNext;
**              }
** RETURNS:     Ptr to active buffer struct
*************************************************************************/
DPBUF *DpReceivePkt()
{
    return pDpActiveBuf;
}


